// components/media_router/common/mojom/media_status.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/media_router/common/mojom/media_status.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/media_router/common/mojom/media_status.mojom-params-data.h"
namespace media_router {
namespace mojom {

NOINLINE static const char* MediaStatus_PlayStateToStringHelper(MediaStatus_PlayState value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MediaStatus_PlayState::PLAYING:
      return "PLAYING";
    case MediaStatus_PlayState::PAUSED:
      return "PAUSED";
    case MediaStatus_PlayState::BUFFERING:
      return "BUFFERING";
    default:
      return nullptr;
  }
}

std::string MediaStatus_PlayStateToString(MediaStatus_PlayState value) {
  const char *str = MediaStatus_PlayStateToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MediaStatus_PlayState value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MediaStatus_PlayState value) {
  return os << MediaStatus_PlayStateToString(value);
}

namespace internal {


// static
bool MediaImage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaImage_Data* object =
      static_cast<const MediaImage_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

MediaImage_Data::MediaImage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaStatus_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaStatus_Data* object =
      static_cast<const MediaStatus_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->secondary_title, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& secondary_title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->secondary_title, validation_context,
                                         &secondary_title_validate_params)) {
    return false;
  }


  if (!::media_router::mojom::internal::MediaStatus_PlayState_Data
        ::Validate(object->play_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->duration, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->current_time, 13, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->current_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->images, 14, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& images_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->images, validation_context,
                                         &images_validate_params)) {
    return false;
  }

  return true;
}

MediaStatus_Data::MediaStatus_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaStatusObserver_OnMediaStatusUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaStatusObserver_OnMediaStatusUpdated_Params_Data* object =
      static_cast<const MediaStatusObserver_OnMediaStatusUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

MediaStatusObserver_OnMediaStatusUpdated_Params_Data::MediaStatusObserver_OnMediaStatusUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media_router

namespace perfetto {

// static
void TraceFormatTraits<::media_router::mojom::MediaStatus_PlayState>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_router::mojom::MediaStatus_PlayState value) {
  return std::move(context).WriteString(::media_router::mojom::MediaStatus_PlayStateToString(value));
}

} // namespace perfetto