// components/media_router/common/mojom/media_status.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/media_router/common/mojom/media_status.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace media_router::mojom {
class MediaImageDataView;

class MediaStatusDataView;



}  // media_router::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media_router::mojom::MediaImageDataView> {
  using Data = ::media_router::mojom::internal::MediaImage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media_router::mojom::MediaStatusDataView> {
  using Data = ::media_router::mojom::internal::MediaStatus_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media_router::mojom {


enum class MediaStatus_PlayState : int32_t {
  
  PLAYING = 0,
  
  PAUSED = 1,
  
  BUFFERING = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, MediaStatus_PlayState value);
inline bool IsKnownEnumValue(MediaStatus_PlayState value) {
  return internal::MediaStatus_PlayState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class MediaStatusObserverInterfaceBase {};

using MediaStatusObserverPtrDataView =
    mojo::InterfacePtrDataView<MediaStatusObserverInterfaceBase>;
using MediaStatusObserverRequestDataView =
    mojo::InterfaceRequestDataView<MediaStatusObserverInterfaceBase>;
using MediaStatusObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MediaStatusObserverInterfaceBase>;
using MediaStatusObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MediaStatusObserverInterfaceBase>;


class MediaImageDataView {
 public:
  MediaImageDataView() = default;

  MediaImageDataView(
      internal::MediaImage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSize(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::gfx::mojom::SizeDataView, UserType>(),
    "Attempting to read the optional `size` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSize` instead "
    "of `ReadSize if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaImage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaStatusDataView {
 public:
  MediaStatusDataView() = default;

  MediaStatusDataView(
      internal::MediaStatus_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSecondaryTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSecondaryTitle(UserType* output) {
    
    auto* pointer = data_->secondary_title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  bool can_play_pause() const {
    return data_->can_play_pause;
  }
  bool can_mute() const {
    return data_->can_mute;
  }
  bool can_set_volume() const {
    return data_->can_set_volume;
  }
  bool can_seek() const {
    return data_->can_seek;
  }
  bool can_skip_to_next_track() const {
    return data_->can_skip_to_next_track;
  }
  bool can_skip_to_previous_track() const {
    return data_->can_skip_to_previous_track;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadPlayState(UserType* output) const {
    auto data_value = data_->play_state;
    return mojo::internal::Deserialize<::media_router::mojom::MediaStatus_PlayState>(
        data_value, output);
  }
  MediaStatus_PlayState play_state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::MediaStatus_PlayState>(data_->play_state));
  }
  bool is_muted() const {
    return data_->is_muted;
  }
  float volume() const {
    return data_->volume;
  }
  inline void GetDurationDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuration(UserType* output) {
    
    auto* pointer = data_->duration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetCurrentTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurrentTime(UserType* output) {
    
    auto* pointer = data_->current_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
  inline void GetImagesDataView(
      mojo::ArrayDataView<MediaImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImages(UserType* output) {
    
    auto* pointer = data_->images.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_router::mojom::MediaImageDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaStatus_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // media_router::mojom

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_STATUS_MOJOM_DATA_VIEW_H_