// components/media_router/common/mojom/media_router.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_TEST_UTILS_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_TEST_UTILS_H_

#include "components/media_router/common/mojom/media_router.mojom.h"


namespace media_router::mojom {


class  MediaRouteProviderInterceptorForTesting : public MediaRouteProvider {
  virtual MediaRouteProvider* GetForwardingInterface() = 0;
  void CreateRoute(const std::string& media_source, const std::string& sink_id, const std::string& original_presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, CreateRouteCallback callback) override;
  void JoinRoute(const std::string& media_source, const std::string& presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, JoinRouteCallback callback) override;
  void TerminateRoute(const std::string& route_id, TerminateRouteCallback callback) override;
  void SendRouteMessage(const std::string& media_route_id, const std::string& message) override;
  void SendRouteBinaryMessage(const std::string& media_route_id, const std::vector<uint8_t>& data) override;
  void StartObservingMediaSinks(const std::string& media_source) override;
  void StopObservingMediaSinks(const std::string& media_source) override;
  void StartObservingMediaRoutes() override;
  void DetachRoute(const std::string& route_id) override;
  void DiscoverSinksNow() override;
  void BindMediaController(const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer, BindMediaControllerCallback callback) override;
  void GetState(GetStateCallback callback) override;
};
class  MediaRouteProviderAsyncWaiter {
 public:
  explicit MediaRouteProviderAsyncWaiter(MediaRouteProvider* proxy);

  MediaRouteProviderAsyncWaiter(const MediaRouteProviderAsyncWaiter&) = delete;
  MediaRouteProviderAsyncWaiter& operator=(const MediaRouteProviderAsyncWaiter&) = delete;

  ~MediaRouteProviderAsyncWaiter();
  void CreateRoute(
      const std::string& media_source, const std::string& sink_id, const std::string& original_presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, std::optional<::media_router::MediaRoute>* out_route, RoutePresentationConnectionPtr* out_connection, std::optional<std::string>* out_error_text, ::media_router::mojom::RouteRequestResultCode* out_result_code);
  
  void JoinRoute(
      const std::string& media_source, const std::string& presentation_id, const ::url::Origin& origin, int32_t frame_tree_node_id, ::base::TimeDelta timeout, std::optional<::media_router::MediaRoute>* out_route, RoutePresentationConnectionPtr* out_connection, std::optional<std::string>* out_error_text, ::media_router::mojom::RouteRequestResultCode* out_result_code);
  
  void TerminateRoute(
      const std::string& route_id, std::optional<std::string>* out_error_text, ::media_router::mojom::RouteRequestResultCode* out_result_code);
  
  void BindMediaController(
      const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer, bool* out_success);
  bool BindMediaController(const std::string& route_id, ::mojo::PendingReceiver<::media_router::mojom::MediaController> media_controller, ::mojo::PendingRemote<::media_router::mojom::MediaStatusObserver> observer);
  void GetState(
      ProviderStatePtr* out_state);
  ProviderStatePtr GetState();

 private:
  MediaRouteProvider* const proxy_;
};


class  MediaRouterInterceptorForTesting : public MediaRouter {
  virtual MediaRouter* GetForwardingInterface() = 0;
  void RegisterMediaRouteProvider(::media_router::mojom::MediaRouteProviderId provider_id, ::mojo::PendingRemote<MediaRouteProvider> media_router_provider) override;
  void OnSinksReceived(::media_router::mojom::MediaRouteProviderId provider_id, const std::string& media_source, const std::vector<::media_router::MediaSinkInternal>& sinks, const std::vector<::url::Origin>& origins) override;
  void OnIssue(const ::media_router::IssueInfo& issue) override;
  void ClearTopIssueForSink(const std::string& sink_id) override;
  void OnRoutesUpdated(::media_router::mojom::MediaRouteProviderId provider_id, const std::vector<::media_router::MediaRoute>& routes) override;
  void OnPresentationConnectionStateChanged(const std::string& route_id, ::blink::mojom::PresentationConnectionState state) override;
  void OnPresentationConnectionClosed(const std::string& route_id, ::blink::mojom::PresentationConnectionCloseReason reason, const std::string& message) override;
  void OnRouteMessagesReceived(const std::string& route_id, std::vector<RouteMessagePtr> messages) override;
  void GetMediaSinkServiceStatus(GetMediaSinkServiceStatusCallback callback) override;
  void GetLogger(::mojo::PendingReceiver<::media_router::mojom::Logger> receiver) override;
  void GetDebugger(::mojo::PendingReceiver<::media_router::mojom::Debugger> receiver) override;
  void GetLogsAsString(GetLogsAsStringCallback callback) override;
};
class  MediaRouterAsyncWaiter {
 public:
  explicit MediaRouterAsyncWaiter(MediaRouter* proxy);

  MediaRouterAsyncWaiter(const MediaRouterAsyncWaiter&) = delete;
  MediaRouterAsyncWaiter& operator=(const MediaRouterAsyncWaiter&) = delete;

  ~MediaRouterAsyncWaiter();
  void GetMediaSinkServiceStatus(
      std::string* out_status);
  std::string GetMediaSinkServiceStatus();
  void GetLogsAsString(
      std::string* out_logs);
  std::string GetLogsAsString();

 private:
  MediaRouter* const proxy_;
};




}  // media_router::mojom

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_TEST_UTILS_H_