// components/media_router/common/mojom/media_router.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SHARED_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/media_router/common/mojom/media_router.mojom-shared-internal.h"
#include "components/media_router/common/mojom/logger.mojom-shared.h"
#include "components/media_router/common/mojom/debugger.mojom-shared.h"
#include "components/media_router/common/mojom/media_controller.mojom-shared.h"
#include "components/media_router/common/mojom/media_route_provider_id.mojom-shared.h"
#include "components/media_router/common/mojom/media_status.mojom-shared.h"
#include "components/media_router/common/mojom/route_request_result_code.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"
#include "services/network/public/mojom/ip_address.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "third_party/blink/public/mojom/presentation/presentation.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/media_router/common/mojom/media_router.mojom-data-view.h"




namespace std {

template <>
struct hash<::media_router::mojom::SinkIconType>
    : public mojo::internal::EnumHashImpl<::media_router::mojom::SinkIconType> {};

template <>
struct hash<::media_router::mojom::RouteControllerType>
    : public mojo::internal::EnumHashImpl<::media_router::mojom::RouteControllerType> {};

template <>
struct hash<::media_router::mojom::Issue_Severity>
    : public mojo::internal::EnumHashImpl<::media_router::mojom::Issue_Severity> {};

template <>
struct hash<::media_router::mojom::RouteMessage_Type>
    : public mojo::internal::EnumHashImpl<::media_router::mojom::RouteMessage_Type> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::SinkIconType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_router::mojom::SinkIconType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_router::mojom::SinkIconType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::RouteControllerType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_router::mojom::RouteControllerType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_router::mojom::RouteControllerType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::Issue_Severity, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_router::mojom::Issue_Severity, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_router::mojom::Issue_Severity>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::RouteMessage_Type, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::media_router::mojom::RouteMessage_Type, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::media_router::mojom::RouteMessage_Type>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::MediaSinkDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaSinkDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaSink_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sink_id(input)) in_sink_id = Traits::sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sink_id)::BaseType> sink_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sink_id,
      sink_id_fragment);

    fragment->sink_id.Set(
        sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sink_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sink_id in MediaSink struct");

    decltype(Traits::name(input)) in_name = Traits::name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->name)::BaseType> name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_name,
      name_fragment);

    fragment->name.Set(
        name_fragment.is_null() ? nullptr : name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null name in MediaSink struct");

    
    mojo::internal::Serialize<::media_router::mojom::SinkIconType>(
      Traits::icon_type(input),
      &fragment->icon_type);

    
    mojo::internal::Serialize<::media_router::mojom::MediaRouteProviderId>(
      Traits::provider_id(input),
      &fragment->provider_id);

    decltype(Traits::extra_data(input)) in_extra_data = Traits::extra_data(input);
    mojo::internal::MessageFragment<decltype(fragment->extra_data)>
        extra_data_fragment(fragment.message());
    extra_data_fragment.Claim(&fragment->extra_data);
    
    mojo::internal::Serialize<::media_router::mojom::MediaSinkExtraDataDataView>(
      in_extra_data,
      extra_data_fragment,
      true);
  }

  static bool Deserialize(::media_router::mojom::internal::MediaSink_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::MediaSinkDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::DialMediaSinkDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::DialMediaSinkDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::DialMediaSink_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ip_address(input)) in_ip_address = Traits::ip_address(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ip_address)::BaseType> ip_address_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPAddressDataView>(
      in_ip_address,
      ip_address_fragment);

    fragment->ip_address.Set(
        ip_address_fragment.is_null() ? nullptr : ip_address_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ip_address.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ip_address in DialMediaSink struct");

    decltype(Traits::model_name(input)) in_model_name = Traits::model_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_name)::BaseType> model_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model_name,
      model_name_fragment);

    fragment->model_name.Set(
        model_name_fragment.is_null() ? nullptr : model_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_name in DialMediaSink struct");

    decltype(Traits::app_url(input)) in_app_url = Traits::app_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->app_url)::BaseType> app_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_app_url,
      app_url_fragment);

    fragment->app_url.Set(
        app_url_fragment.is_null() ? nullptr : app_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->app_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_url in DialMediaSink struct");
  }

  static bool Deserialize(::media_router::mojom::internal::DialMediaSink_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::DialMediaSinkDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::CastMediaSinkDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::CastMediaSinkDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::CastMediaSink_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::ip_endpoint(input)) in_ip_endpoint = Traits::ip_endpoint(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->ip_endpoint)::BaseType> ip_endpoint_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_ip_endpoint,
      ip_endpoint_fragment);

    fragment->ip_endpoint.Set(
        ip_endpoint_fragment.is_null() ? nullptr : ip_endpoint_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->ip_endpoint.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ip_endpoint in CastMediaSink struct");

    decltype(Traits::model_name(input)) in_model_name = Traits::model_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->model_name)::BaseType> model_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_model_name,
      model_name_fragment);

    fragment->model_name.Set(
        model_name_fragment.is_null() ? nullptr : model_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->model_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null model_name in CastMediaSink struct");

    fragment->capabilities = Traits::capabilities(input);

    fragment->cast_channel_id = Traits::cast_channel_id(input);
  }

  static bool Deserialize(::media_router::mojom::internal::CastMediaSink_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::CastMediaSinkDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::MediaRouteDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::MediaRouteDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::MediaRoute_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::media_route_id(input)) in_media_route_id = Traits::media_route_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_route_id)::BaseType> media_route_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_route_id,
      media_route_id_fragment);

    fragment->media_route_id.Set(
        media_route_id_fragment.is_null() ? nullptr : media_route_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_route_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_route_id in MediaRoute struct");

    decltype(Traits::presentation_id(input)) in_presentation_id = Traits::presentation_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->presentation_id)::BaseType> presentation_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_presentation_id,
      presentation_id_fragment);

    fragment->presentation_id.Set(
        presentation_id_fragment.is_null() ? nullptr : presentation_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->presentation_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null presentation_id in MediaRoute struct");

    decltype(Traits::media_source(input)) in_media_source = Traits::media_source(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_source)::BaseType> media_source_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_source,
      media_source_fragment);

    fragment->media_source.Set(
        media_source_fragment.is_null() ? nullptr : media_source_fragment.data());

    decltype(Traits::media_sink_id(input)) in_media_sink_id = Traits::media_sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_sink_id)::BaseType> media_sink_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_sink_id,
      media_sink_id_fragment);

    fragment->media_sink_id.Set(
        media_sink_id_fragment.is_null() ? nullptr : media_sink_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_sink_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_sink_id in MediaRoute struct");

    decltype(Traits::media_sink_name(input)) in_media_sink_name = Traits::media_sink_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->media_sink_name)::BaseType> media_sink_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_media_sink_name,
      media_sink_name_fragment);

    fragment->media_sink_name.Set(
        media_sink_name_fragment.is_null() ? nullptr : media_sink_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->media_sink_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null media_sink_name in MediaRoute struct");

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in MediaRoute struct");

    fragment->is_local = Traits::is_local(input);

    
    mojo::internal::Serialize<::media_router::mojom::RouteControllerType>(
      Traits::controller_type(input),
      &fragment->controller_type);

    fragment->is_local_presentation = Traits::is_local_presentation(input);

    fragment->is_connecting = Traits::is_connecting(input);
  }

  static bool Deserialize(::media_router::mojom::internal::MediaRoute_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::MediaRouteDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::IssueDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::IssueDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::Issue_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::route_id(input)) in_route_id = Traits::route_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->route_id)::BaseType> route_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_route_id,
      route_id_fragment);

    fragment->route_id.Set(
        route_id_fragment.is_null() ? nullptr : route_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->route_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null route_id in Issue struct");

    decltype(Traits::sink_id(input)) in_sink_id = Traits::sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sink_id)::BaseType> sink_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sink_id,
      sink_id_fragment);

    fragment->sink_id.Set(
        sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sink_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sink_id in Issue struct");

    
    mojo::internal::Serialize<::media_router::mojom::Issue_Severity>(
      Traits::severity(input),
      &fragment->severity);

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in Issue struct");

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());
  }

  static bool Deserialize(::media_router::mojom::internal::Issue_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::IssueDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::RouteMessageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::RouteMessageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::RouteMessage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::media_router::mojom::RouteMessage_Type>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::message(input)) in_message = Traits::message(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->message)::BaseType> message_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_message,
      message_fragment);

    fragment->message.Set(
        message_fragment.is_null() ? nullptr : message_fragment.data());

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());
  }

  static bool Deserialize(::media_router::mojom::internal::RouteMessage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::RouteMessageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::RoutePresentationConnectionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::RoutePresentationConnectionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::RoutePresentationConnection_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::connection_remote(input)) in_connection_remote = Traits::connection_remote(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
      in_connection_remote,
      &fragment->connection_remote,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection_remote)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid connection_remote in RoutePresentationConnection struct");

    decltype(Traits::connection_receiver(input)) in_connection_receiver = Traits::connection_receiver(input);

    
    mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::PresentationConnectionInterfaceBase>>(
      in_connection_receiver,
      &fragment->connection_receiver,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->connection_receiver)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid connection_receiver in RoutePresentationConnection struct");
  }

  static bool Deserialize(::media_router::mojom::internal::RoutePresentationConnection_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::RoutePresentationConnectionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::CastSessionStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::CastSessionStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::CastSessionState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::sink_id(input)) in_sink_id = Traits::sink_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sink_id)::BaseType> sink_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_sink_id,
      sink_id_fragment);

    fragment->sink_id.Set(
        sink_id_fragment.is_null() ? nullptr : sink_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->sink_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sink_id in CastSessionState struct");

    decltype(Traits::app_id(input)) in_app_id = Traits::app_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->app_id)::BaseType> app_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_app_id,
      app_id_fragment);

    fragment->app_id.Set(
        app_id_fragment.is_null() ? nullptr : app_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->app_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null app_id in CastSessionState struct");

    decltype(Traits::session_id(input)) in_session_id = Traits::session_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_id)::BaseType> session_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_session_id,
      session_id_fragment);

    fragment->session_id.Set(
        session_id_fragment.is_null() ? nullptr : session_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_id in CastSessionState struct");

    decltype(Traits::route_description(input)) in_route_description = Traits::route_description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->route_description)::BaseType> route_description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_route_description,
      route_description_fragment);

    fragment->route_description.Set(
        route_description_fragment.is_null() ? nullptr : route_description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->route_description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null route_description in CastSessionState struct");
  }

  static bool Deserialize(::media_router::mojom::internal::CastSessionState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::CastSessionStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::CastProviderStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media_router::mojom::CastProviderStateDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::media_router::mojom::internal::CastProviderState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::session_state(input)) in_session_state = Traits::session_state(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->session_state)::BaseType>
        session_state_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& session_state_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::media_router::mojom::CastSessionStateDataView>>(
      in_session_state,
      session_state_fragment,
      &session_state_validate_params);

    fragment->session_state.Set(
        session_state_fragment.is_null() ? nullptr : session_state_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->session_state.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null session_state in CastProviderState struct");
  }

  static bool Deserialize(::media_router::mojom::internal::CastProviderState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::CastProviderStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::MediaSinkExtraDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media_router::mojom::MediaSinkExtraDataDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media_router::mojom::internal::MediaSinkExtraData_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media_router::mojom::MediaSinkExtraDataDataView::Tag::kDialMediaSink: {
    decltype(Traits::dial_media_sink(input))
    in_dial_media_sink = Traits::dial_media_sink(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_dial_media_sink)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media_router::mojom::DialMediaSinkDataView>(
  in_dial_media_sink,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null dial_media_sink in MediaSinkExtraData union");
    fragment->data.f_dial_media_sink.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::media_router::mojom::MediaSinkExtraDataDataView::Tag::kCastMediaSink: {
    decltype(Traits::cast_media_sink(input))
    in_cast_media_sink = Traits::cast_media_sink(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cast_media_sink)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media_router::mojom::CastMediaSinkDataView>(
  in_cast_media_sink,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cast_media_sink in MediaSinkExtraData union");
    fragment->data.f_cast_media_sink.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::media_router::mojom::internal::MediaSinkExtraData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::MediaSinkExtraDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media_router::mojom::ProviderStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::media_router::mojom::ProviderStateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::media_router::mojom::internal::ProviderState_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::media_router::mojom::ProviderStateDataView::Tag::kCastProviderState: {
    decltype(Traits::cast_provider_state(input))
    in_cast_provider_state = Traits::cast_provider_state(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_cast_provider_state)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::media_router::mojom::CastProviderStateDataView>(
  in_cast_provider_state,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null cast_provider_state in ProviderState union");
    fragment->data.f_cast_provider_state.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::media_router::mojom::internal::ProviderState_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::media_router::mojom::ProviderStateDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media_router::mojom {

inline void MediaSinkDataView::GetSinkIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sink_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaSinkDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaSinkDataView::GetExtraDataDataView(
    MediaSinkExtraDataDataView* output) {
  auto pointer = &data_->extra_data;
  *output = MediaSinkExtraDataDataView(pointer, message_);
}


inline void DialMediaSinkDataView::GetIpAddressDataView(
    ::network::mojom::IPAddressDataView* output) {
  auto pointer = data_->ip_address.Get();
  *output = ::network::mojom::IPAddressDataView(pointer, message_);
}
inline void DialMediaSinkDataView::GetModelNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void DialMediaSinkDataView::GetAppUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->app_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void CastMediaSinkDataView::GetIpEndpointDataView(
    ::network::mojom::IPEndPointDataView* output) {
  auto pointer = data_->ip_endpoint.Get();
  *output = ::network::mojom::IPEndPointDataView(pointer, message_);
}
inline void CastMediaSinkDataView::GetModelNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->model_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouteDataView::GetMediaRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteDataView::GetPresentationIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->presentation_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteDataView::GetMediaSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteDataView::GetMediaSinkIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_sink_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteDataView::GetMediaSinkNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_sink_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void IssueDataView::GetRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IssueDataView::GetSinkIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sink_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IssueDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void IssueDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void RouteMessageDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void RouteMessageDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}




inline void CastSessionStateDataView::GetSinkIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sink_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CastSessionStateDataView::GetAppIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->app_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CastSessionStateDataView::GetSessionIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->session_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void CastSessionStateDataView::GetRouteDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_description.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void CastProviderStateDataView::GetSessionStateDataView(
    mojo::ArrayDataView<CastSessionStateDataView>* output) {
  auto pointer = data_->session_state.Get();
  *output = mojo::ArrayDataView<CastSessionStateDataView>(pointer, message_);
}


inline void MediaSinkExtraDataDataView::GetDialMediaSinkDataView(
    DialMediaSinkDataView* output) const {
  CHECK(is_dial_media_sink());
  *output = DialMediaSinkDataView(data_->data.f_dial_media_sink.Get(), message_);
}
inline void MediaSinkExtraDataDataView::GetCastMediaSinkDataView(
    CastMediaSinkDataView* output) const {
  CHECK(is_cast_media_sink());
  *output = CastMediaSinkDataView(data_->data.f_cast_media_sink.Get(), message_);
}

inline void ProviderStateDataView::GetCastProviderStateDataView(
    CastProviderStateDataView* output) const {
  CHECK(is_cast_provider_state());
  *output = CastProviderStateDataView(data_->data.f_cast_provider_state.Get(), message_);
}


}  // media_router::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_router::mojom::SinkIconType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_router::mojom::SinkIconType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_router::mojom::RouteControllerType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_router::mojom::RouteControllerType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_router::mojom::Issue_Severity> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_router::mojom::Issue_Severity value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::media_router::mojom::RouteMessage_Type> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::media_router::mojom::RouteMessage_Type value);
};

} // namespace perfetto

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_SHARED_H_