// components/media_router/common/mojom/media_router.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/media_router/common/mojom/media_router.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/media_router/common/mojom/media_router.mojom-params-data.h"
namespace media_router {
namespace mojom {

NOINLINE static const char* SinkIconTypeToStringHelper(SinkIconType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SinkIconType::CAST:
      return "CAST";
    case SinkIconType::CAST_AUDIO_GROUP:
      return "CAST_AUDIO_GROUP";
    case SinkIconType::CAST_AUDIO:
      return "CAST_AUDIO";
    case SinkIconType::WIRED_DISPLAY:
      return "WIRED_DISPLAY";
    case SinkIconType::GENERIC:
      return "GENERIC";
    default:
      return nullptr;
  }
}

std::string SinkIconTypeToString(SinkIconType value) {
  const char *str = SinkIconTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SinkIconType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SinkIconType value) {
  return os << SinkIconTypeToString(value);
}

NOINLINE static const char* RouteControllerTypeToStringHelper(RouteControllerType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RouteControllerType::kNone:
      return "kNone";
    case RouteControllerType::kGeneric:
      return "kGeneric";
    case RouteControllerType::kMirroring:
      return "kMirroring";
    default:
      return nullptr;
  }
}

std::string RouteControllerTypeToString(RouteControllerType value) {
  const char *str = RouteControllerTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RouteControllerType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RouteControllerType value) {
  return os << RouteControllerTypeToString(value);
}

NOINLINE static const char* Issue_SeverityToStringHelper(Issue_Severity value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Issue_Severity::WARNING:
      return "WARNING";
    case Issue_Severity::NOTIFICATION:
      return "NOTIFICATION";
    default:
      return nullptr;
  }
}

std::string Issue_SeverityToString(Issue_Severity value) {
  const char *str = Issue_SeverityToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Issue_Severity value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Issue_Severity value) {
  return os << Issue_SeverityToString(value);
}

NOINLINE static const char* RouteMessage_TypeToStringHelper(RouteMessage_Type value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case RouteMessage_Type::TEXT:
      return "TEXT";
    case RouteMessage_Type::BINARY:
      return "BINARY";
    default:
      return nullptr;
  }
}

std::string RouteMessage_TypeToString(RouteMessage_Type value) {
  const char *str = RouteMessage_TypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown RouteMessage_Type value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, RouteMessage_Type value) {
  return os << RouteMessage_TypeToString(value);
}

namespace internal {
// static
bool MediaSinkExtraData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const MediaSinkExtraData_Data* object = static_cast<const MediaSinkExtraData_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case MediaSinkExtraData_Tag::kDialMediaSink: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_dial_media_sink, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_dial_media_sink, validation_context))
        return false;
      return true;
    }
    case MediaSinkExtraData_Tag::kCastMediaSink: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_cast_media_sink, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_cast_media_sink, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in MediaSinkExtraData");
      return false;
    }
  }
}
// static
bool ProviderState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const ProviderState_Data* object = static_cast<const ProviderState_Data*>(data);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case ProviderState_Tag::kCastProviderState: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_cast_provider_state, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_cast_provider_state, validation_context))
        return false;
      return true;
    }
    default: {

      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in ProviderState");
      return false;
    }
  }
}


// static
bool MediaSink_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaSink_Data* object =
      static_cast<const MediaSink_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sink_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sink_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sink_id, validation_context,
                                         &sink_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }


  if (!::media_router::mojom::internal::SinkIconType_Data
        ::Validate(object->icon_type, validation_context))
    return false;


  if (!::media_router::mojom::internal::MediaRouteProviderId_Data
        ::Validate(object->provider_id, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->extra_data, validation_context))
    return false;

  return true;
}

MediaSink_Data::MediaSink_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DialMediaSink_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DialMediaSink_Data* object =
      static_cast<const DialMediaSink_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ip_address, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ip_address, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_name, validation_context,
                                         &model_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->app_url, validation_context))
    return false;

  return true;
}

DialMediaSink_Data::DialMediaSink_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CastMediaSink_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CastMediaSink_Data* object =
      static_cast<const CastMediaSink_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ip_endpoint, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ip_endpoint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->model_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& model_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->model_name, validation_context,
                                         &model_name_validate_params)) {
    return false;
  }

  return true;
}

CastMediaSink_Data::CastMediaSink_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRoute_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRoute_Data* object =
      static_cast<const MediaRoute_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_route_id, validation_context,
                                         &media_route_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_id, validation_context,
                                         &presentation_id_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& media_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source, validation_context,
                                         &media_source_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_sink_id, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_sink_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_sink_id, validation_context,
                                         &media_sink_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_sink_name, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_sink_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_sink_name, validation_context,
                                         &media_sink_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->description, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->description, validation_context,
                                         &description_validate_params)) {
    return false;
  }


  if (!::media_router::mojom::internal::RouteControllerType_Data
        ::Validate(object->controller_type, validation_context))
    return false;

  return true;
}

MediaRoute_Data::MediaRoute_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Issue_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Issue_Data* object =
      static_cast<const Issue_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_id, validation_context,
                                         &route_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sink_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sink_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sink_id, validation_context,
                                         &sink_id_validate_params)) {
    return false;
  }


  if (!::media_router::mojom::internal::Issue_Severity_Data
        ::Validate(object->severity, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

Issue_Data::Issue_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RouteMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RouteMessage_Data* object =
      static_cast<const RouteMessage_Data*>(data);


  if (!::media_router::mojom::internal::RouteMessage_Type_Data
        ::Validate(object->type, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

RouteMessage_Data::RouteMessage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RoutePresentationConnection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const RoutePresentationConnection_Data* object =
      static_cast<const RoutePresentationConnection_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->connection_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->connection_remote,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->connection_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->connection_receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RoutePresentationConnection_Data::RoutePresentationConnection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CastSessionState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CastSessionState_Data* object =
      static_cast<const CastSessionState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sink_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sink_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sink_id, validation_context,
                                         &sink_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->app_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& app_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->app_id, validation_context,
                                         &app_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_description, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_description_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_description, validation_context,
                                         &route_description_validate_params)) {
    return false;
  }

  return true;
}

CastSessionState_Data::CastSessionState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CastProviderState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CastProviderState_Data* object =
      static_cast<const CastProviderState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_state, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_state_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_state, validation_context,
                                         &session_state_validate_params)) {
    return false;
  }

  return true;
}

CastProviderState_Data::CastProviderState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_CreateRoute_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_CreateRoute_Params_Data* object =
      static_cast<const MediaRouteProvider_CreateRoute_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_source, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source, validation_context,
                                         &media_source_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sink_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sink_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sink_id, validation_context,
                                         &sink_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_presentation_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& original_presentation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->original_presentation_id, validation_context,
                                         &original_presentation_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timeout, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  return true;
}

MediaRouteProvider_CreateRoute_Params_Data::MediaRouteProvider_CreateRoute_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_CreateRoute_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_CreateRoute_ResponseParams_Data* object =
      static_cast<const MediaRouteProvider_CreateRoute_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->route, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->connection, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_text, validation_context,
                                         &error_text_validate_params)) {
    return false;
  }


  if (!::media_router::mojom::internal::RouteRequestResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

MediaRouteProvider_CreateRoute_ResponseParams_Data::MediaRouteProvider_CreateRoute_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_JoinRoute_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_JoinRoute_Params_Data* object =
      static_cast<const MediaRouteProvider_JoinRoute_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_source, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source, validation_context,
                                         &media_source_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->presentation_id, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& presentation_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->presentation_id, validation_context,
                                         &presentation_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timeout, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timeout, validation_context))
    return false;

  return true;
}

MediaRouteProvider_JoinRoute_Params_Data::MediaRouteProvider_JoinRoute_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_JoinRoute_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_JoinRoute_ResponseParams_Data* object =
      static_cast<const MediaRouteProvider_JoinRoute_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->route, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->connection, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& error_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_text, validation_context,
                                         &error_text_validate_params)) {
    return false;
  }


  if (!::media_router::mojom::internal::RouteRequestResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

MediaRouteProvider_JoinRoute_ResponseParams_Data::MediaRouteProvider_JoinRoute_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_TerminateRoute_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_TerminateRoute_Params_Data* object =
      static_cast<const MediaRouteProvider_TerminateRoute_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_id, validation_context,
                                         &route_id_validate_params)) {
    return false;
  }

  return true;
}

MediaRouteProvider_TerminateRoute_Params_Data::MediaRouteProvider_TerminateRoute_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_TerminateRoute_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_TerminateRoute_ResponseParams_Data* object =
      static_cast<const MediaRouteProvider_TerminateRoute_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& error_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->error_text, validation_context,
                                         &error_text_validate_params)) {
    return false;
  }


  if (!::media_router::mojom::internal::RouteRequestResultCode_Data
        ::Validate(object->result_code, validation_context))
    return false;

  return true;
}

MediaRouteProvider_TerminateRoute_ResponseParams_Data::MediaRouteProvider_TerminateRoute_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_SendRouteMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_SendRouteMessage_Params_Data* object =
      static_cast<const MediaRouteProvider_SendRouteMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_route_id, validation_context,
                                         &media_route_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

MediaRouteProvider_SendRouteMessage_Params_Data::MediaRouteProvider_SendRouteMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_SendRouteBinaryMessage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_SendRouteBinaryMessage_Params_Data* object =
      static_cast<const MediaRouteProvider_SendRouteBinaryMessage_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_route_id, validation_context,
                                         &media_route_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->data, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->data, validation_context,
                                         &data_validate_params)) {
    return false;
  }

  return true;
}

MediaRouteProvider_SendRouteBinaryMessage_Params_Data::MediaRouteProvider_SendRouteBinaryMessage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_StartObservingMediaSinks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_StartObservingMediaSinks_Params_Data* object =
      static_cast<const MediaRouteProvider_StartObservingMediaSinks_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_source, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source, validation_context,
                                         &media_source_validate_params)) {
    return false;
  }

  return true;
}

MediaRouteProvider_StartObservingMediaSinks_Params_Data::MediaRouteProvider_StartObservingMediaSinks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_StopObservingMediaSinks_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_StopObservingMediaSinks_Params_Data* object =
      static_cast<const MediaRouteProvider_StopObservingMediaSinks_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_source, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source, validation_context,
                                         &media_source_validate_params)) {
    return false;
  }

  return true;
}

MediaRouteProvider_StopObservingMediaSinks_Params_Data::MediaRouteProvider_StopObservingMediaSinks_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_StartObservingMediaRoutes_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_StartObservingMediaRoutes_Params_Data* object =
      static_cast<const MediaRouteProvider_StartObservingMediaRoutes_Params_Data*>(data);

  return true;
}

MediaRouteProvider_StartObservingMediaRoutes_Params_Data::MediaRouteProvider_StartObservingMediaRoutes_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_DetachRoute_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_DetachRoute_Params_Data* object =
      static_cast<const MediaRouteProvider_DetachRoute_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_id, validation_context,
                                         &route_id_validate_params)) {
    return false;
  }

  return true;
}

MediaRouteProvider_DetachRoute_Params_Data::MediaRouteProvider_DetachRoute_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_DiscoverSinksNow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_DiscoverSinksNow_Params_Data* object =
      static_cast<const MediaRouteProvider_DiscoverSinksNow_Params_Data*>(data);

  return true;
}

MediaRouteProvider_DiscoverSinksNow_Params_Data::MediaRouteProvider_DiscoverSinksNow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_BindMediaController_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_BindMediaController_Params_Data* object =
      static_cast<const MediaRouteProvider_BindMediaController_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_id, validation_context,
                                         &route_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->media_controller, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->media_controller,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaRouteProvider_BindMediaController_Params_Data::MediaRouteProvider_BindMediaController_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_BindMediaController_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_BindMediaController_ResponseParams_Data* object =
      static_cast<const MediaRouteProvider_BindMediaController_ResponseParams_Data*>(data);

  return true;
}

MediaRouteProvider_BindMediaController_ResponseParams_Data::MediaRouteProvider_BindMediaController_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_GetState_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_GetState_Params_Data* object =
      static_cast<const MediaRouteProvider_GetState_Params_Data*>(data);

  return true;
}

MediaRouteProvider_GetState_Params_Data::MediaRouteProvider_GetState_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouteProvider_GetState_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouteProvider_GetState_ResponseParams_Data* object =
      static_cast<const MediaRouteProvider_GetState_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnion(object->state, validation_context))
    return false;

  return true;
}

MediaRouteProvider_GetState_ResponseParams_Data::MediaRouteProvider_GetState_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_RegisterMediaRouteProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_RegisterMediaRouteProvider_Params_Data* object =
      static_cast<const MediaRouter_RegisterMediaRouteProvider_Params_Data*>(data);


  if (!::media_router::mojom::internal::MediaRouteProviderId_Data
        ::Validate(object->provider_id, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->media_router_provider, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->media_router_provider,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaRouter_RegisterMediaRouteProvider_Params_Data::MediaRouter_RegisterMediaRouteProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_OnSinksReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_OnSinksReceived_Params_Data* object =
      static_cast<const MediaRouter_OnSinksReceived_Params_Data*>(data);


  if (!::media_router::mojom::internal::MediaRouteProviderId_Data
        ::Validate(object->provider_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->media_source, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& media_source_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->media_source, validation_context,
                                         &media_source_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sinks, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sinks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sinks, validation_context,
                                         &sinks_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origins, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->origins, validation_context,
                                         &origins_validate_params)) {
    return false;
  }

  return true;
}

MediaRouter_OnSinksReceived_Params_Data::MediaRouter_OnSinksReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_OnIssue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_OnIssue_Params_Data* object =
      static_cast<const MediaRouter_OnIssue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issue, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->issue, validation_context))
    return false;

  return true;
}

MediaRouter_OnIssue_Params_Data::MediaRouter_OnIssue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_ClearTopIssueForSink_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_ClearTopIssueForSink_Params_Data* object =
      static_cast<const MediaRouter_ClearTopIssueForSink_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sink_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sink_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->sink_id, validation_context,
                                         &sink_id_validate_params)) {
    return false;
  }

  return true;
}

MediaRouter_ClearTopIssueForSink_Params_Data::MediaRouter_ClearTopIssueForSink_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_OnRoutesUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_OnRoutesUpdated_Params_Data* object =
      static_cast<const MediaRouter_OnRoutesUpdated_Params_Data*>(data);


  if (!::media_router::mojom::internal::MediaRouteProviderId_Data
        ::Validate(object->provider_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->routes, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& routes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->routes, validation_context,
                                         &routes_validate_params)) {
    return false;
  }

  return true;
}

MediaRouter_OnRoutesUpdated_Params_Data::MediaRouter_OnRoutesUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_OnPresentationConnectionStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_OnPresentationConnectionStateChanged_Params_Data* object =
      static_cast<const MediaRouter_OnPresentationConnectionStateChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_id, validation_context,
                                         &route_id_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::PresentationConnectionState_Data
        ::Validate(object->state, validation_context))
    return false;

  return true;
}

MediaRouter_OnPresentationConnectionStateChanged_Params_Data::MediaRouter_OnPresentationConnectionStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_OnPresentationConnectionClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_OnPresentationConnectionClosed_Params_Data* object =
      static_cast<const MediaRouter_OnPresentationConnectionClosed_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_id, validation_context,
                                         &route_id_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::PresentationConnectionCloseReason_Data
        ::Validate(object->reason, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& message_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->message, validation_context,
                                         &message_validate_params)) {
    return false;
  }

  return true;
}

MediaRouter_OnPresentationConnectionClosed_Params_Data::MediaRouter_OnPresentationConnectionClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_OnRouteMessagesReceived_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_OnRouteMessagesReceived_Params_Data* object =
      static_cast<const MediaRouter_OnRouteMessagesReceived_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->route_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& route_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->route_id, validation_context,
                                         &route_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->messages, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& messages_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->messages, validation_context,
                                         &messages_validate_params)) {
    return false;
  }

  return true;
}

MediaRouter_OnRouteMessagesReceived_Params_Data::MediaRouter_OnRouteMessagesReceived_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_GetMediaSinkServiceStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_GetMediaSinkServiceStatus_Params_Data* object =
      static_cast<const MediaRouter_GetMediaSinkServiceStatus_Params_Data*>(data);

  return true;
}

MediaRouter_GetMediaSinkServiceStatus_Params_Data::MediaRouter_GetMediaSinkServiceStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data* object =
      static_cast<const MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& status_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->status, validation_context,
                                         &status_validate_params)) {
    return false;
  }

  return true;
}

MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data::MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_GetLogger_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_GetLogger_Params_Data* object =
      static_cast<const MediaRouter_GetLogger_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaRouter_GetLogger_Params_Data::MediaRouter_GetLogger_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_GetDebugger_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_GetDebugger_Params_Data* object =
      static_cast<const MediaRouter_GetDebugger_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

MediaRouter_GetDebugger_Params_Data::MediaRouter_GetDebugger_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_GetLogsAsString_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_GetLogsAsString_Params_Data* object =
      static_cast<const MediaRouter_GetLogsAsString_Params_Data*>(data);

  return true;
}

MediaRouter_GetLogsAsString_Params_Data::MediaRouter_GetLogsAsString_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool MediaRouter_GetLogsAsString_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const MediaRouter_GetLogsAsString_ResponseParams_Data* object =
      static_cast<const MediaRouter_GetLogsAsString_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->logs, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& logs_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->logs, validation_context,
                                         &logs_validate_params)) {
    return false;
  }

  return true;
}

MediaRouter_GetLogsAsString_ResponseParams_Data::MediaRouter_GetLogsAsString_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace media_router

namespace perfetto {

// static
void TraceFormatTraits<::media_router::mojom::SinkIconType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_router::mojom::SinkIconType value) {
  return std::move(context).WriteString(::media_router::mojom::SinkIconTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_router::mojom::RouteControllerType>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_router::mojom::RouteControllerType value) {
  return std::move(context).WriteString(::media_router::mojom::RouteControllerTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_router::mojom::Issue_Severity>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_router::mojom::Issue_Severity value) {
  return std::move(context).WriteString(::media_router::mojom::Issue_SeverityToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::media_router::mojom::RouteMessage_Type>::WriteIntoTrace(
   perfetto::TracedValue context, ::media_router::mojom::RouteMessage_Type value) {
  return std::move(context).WriteString(::media_router::mojom::RouteMessage_TypeToString(value));
}

} // namespace perfetto