// components/media_router/common/mojom/media_router.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_PARAMS_DATA_H_
#define COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_PARAMS_DATA_H_
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace media_router::mojom {
namespace internal {
class  MediaRouteProvider_CreateRoute_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> media_source;
  mojo::internal::Pointer<mojo::internal::String_Data> sink_id;
  mojo::internal::Pointer<mojo::internal::String_Data> original_presentation_id;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  int32_t frame_tree_node_id;
  uint8_t pad4_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timeout;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_CreateRoute_Params_Data>;

  MediaRouteProvider_CreateRoute_Params_Data();
  ~MediaRouteProvider_CreateRoute_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_CreateRoute_Params_Data) == 56,
              "Bad sizeof(MediaRouteProvider_CreateRoute_Params_Data)");
class  MediaRouteProvider_CreateRoute_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::MediaRoute_Data> route;
  mojo::internal::Pointer<internal::RoutePresentationConnection_Data> connection;
  mojo::internal::Pointer<mojo::internal::String_Data> error_text;
  int32_t result_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_CreateRoute_ResponseParams_Data>;

  MediaRouteProvider_CreateRoute_ResponseParams_Data();
  ~MediaRouteProvider_CreateRoute_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_CreateRoute_ResponseParams_Data) == 40,
              "Bad sizeof(MediaRouteProvider_CreateRoute_ResponseParams_Data)");
class  MediaRouteProvider_JoinRoute_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> media_source;
  mojo::internal::Pointer<mojo::internal::String_Data> presentation_id;
  mojo::internal::Pointer<::url::mojom::internal::Origin_Data> origin;
  int32_t frame_tree_node_id;
  uint8_t pad3_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> timeout;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_JoinRoute_Params_Data>;

  MediaRouteProvider_JoinRoute_Params_Data();
  ~MediaRouteProvider_JoinRoute_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_JoinRoute_Params_Data) == 48,
              "Bad sizeof(MediaRouteProvider_JoinRoute_Params_Data)");
class  MediaRouteProvider_JoinRoute_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::MediaRoute_Data> route;
  mojo::internal::Pointer<internal::RoutePresentationConnection_Data> connection;
  mojo::internal::Pointer<mojo::internal::String_Data> error_text;
  int32_t result_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_JoinRoute_ResponseParams_Data>;

  MediaRouteProvider_JoinRoute_ResponseParams_Data();
  ~MediaRouteProvider_JoinRoute_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_JoinRoute_ResponseParams_Data) == 40,
              "Bad sizeof(MediaRouteProvider_JoinRoute_ResponseParams_Data)");
class  MediaRouteProvider_TerminateRoute_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> route_id;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_TerminateRoute_Params_Data>;

  MediaRouteProvider_TerminateRoute_Params_Data();
  ~MediaRouteProvider_TerminateRoute_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_TerminateRoute_Params_Data) == 16,
              "Bad sizeof(MediaRouteProvider_TerminateRoute_Params_Data)");
class  MediaRouteProvider_TerminateRoute_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> error_text;
  int32_t result_code;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_TerminateRoute_ResponseParams_Data>;

  MediaRouteProvider_TerminateRoute_ResponseParams_Data();
  ~MediaRouteProvider_TerminateRoute_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_TerminateRoute_ResponseParams_Data) == 24,
              "Bad sizeof(MediaRouteProvider_TerminateRoute_ResponseParams_Data)");
class  MediaRouteProvider_SendRouteMessage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> media_route_id;
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_SendRouteMessage_Params_Data>;

  MediaRouteProvider_SendRouteMessage_Params_Data();
  ~MediaRouteProvider_SendRouteMessage_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_SendRouteMessage_Params_Data) == 24,
              "Bad sizeof(MediaRouteProvider_SendRouteMessage_Params_Data)");
class  MediaRouteProvider_SendRouteBinaryMessage_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> media_route_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> data;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_SendRouteBinaryMessage_Params_Data>;

  MediaRouteProvider_SendRouteBinaryMessage_Params_Data();
  ~MediaRouteProvider_SendRouteBinaryMessage_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_SendRouteBinaryMessage_Params_Data) == 24,
              "Bad sizeof(MediaRouteProvider_SendRouteBinaryMessage_Params_Data)");
class  MediaRouteProvider_StartObservingMediaSinks_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> media_source;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_StartObservingMediaSinks_Params_Data>;

  MediaRouteProvider_StartObservingMediaSinks_Params_Data();
  ~MediaRouteProvider_StartObservingMediaSinks_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_StartObservingMediaSinks_Params_Data) == 16,
              "Bad sizeof(MediaRouteProvider_StartObservingMediaSinks_Params_Data)");
class  MediaRouteProvider_StopObservingMediaSinks_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> media_source;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_StopObservingMediaSinks_Params_Data>;

  MediaRouteProvider_StopObservingMediaSinks_Params_Data();
  ~MediaRouteProvider_StopObservingMediaSinks_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_StopObservingMediaSinks_Params_Data) == 16,
              "Bad sizeof(MediaRouteProvider_StopObservingMediaSinks_Params_Data)");
class  MediaRouteProvider_StartObservingMediaRoutes_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_StartObservingMediaRoutes_Params_Data>;

  MediaRouteProvider_StartObservingMediaRoutes_Params_Data();
  ~MediaRouteProvider_StartObservingMediaRoutes_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_StartObservingMediaRoutes_Params_Data) == 8,
              "Bad sizeof(MediaRouteProvider_StartObservingMediaRoutes_Params_Data)");
class  MediaRouteProvider_DetachRoute_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> route_id;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_DetachRoute_Params_Data>;

  MediaRouteProvider_DetachRoute_Params_Data();
  ~MediaRouteProvider_DetachRoute_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_DetachRoute_Params_Data) == 16,
              "Bad sizeof(MediaRouteProvider_DetachRoute_Params_Data)");
class  MediaRouteProvider_DiscoverSinksNow_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_DiscoverSinksNow_Params_Data>;

  MediaRouteProvider_DiscoverSinksNow_Params_Data();
  ~MediaRouteProvider_DiscoverSinksNow_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_DiscoverSinksNow_Params_Data) == 8,
              "Bad sizeof(MediaRouteProvider_DiscoverSinksNow_Params_Data)");
class  MediaRouteProvider_BindMediaController_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> route_id;
  mojo::internal::Handle_Data media_controller;
  mojo::internal::Interface_Data observer;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_BindMediaController_Params_Data>;

  MediaRouteProvider_BindMediaController_Params_Data();
  ~MediaRouteProvider_BindMediaController_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_BindMediaController_Params_Data) == 32,
              "Bad sizeof(MediaRouteProvider_BindMediaController_Params_Data)");
class  MediaRouteProvider_BindMediaController_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_BindMediaController_ResponseParams_Data>;

  MediaRouteProvider_BindMediaController_ResponseParams_Data();
  ~MediaRouteProvider_BindMediaController_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_BindMediaController_ResponseParams_Data) == 16,
              "Bad sizeof(MediaRouteProvider_BindMediaController_ResponseParams_Data)");
class  MediaRouteProvider_GetState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_GetState_Params_Data>;

  MediaRouteProvider_GetState_Params_Data();
  ~MediaRouteProvider_GetState_Params_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_GetState_Params_Data) == 8,
              "Bad sizeof(MediaRouteProvider_GetState_Params_Data)");
class  MediaRouteProvider_GetState_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  internal::ProviderState_Data state;

 private:
  friend class mojo::internal::MessageFragment<MediaRouteProvider_GetState_ResponseParams_Data>;

  MediaRouteProvider_GetState_ResponseParams_Data();
  ~MediaRouteProvider_GetState_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaRouteProvider_GetState_ResponseParams_Data) == 24,
              "Bad sizeof(MediaRouteProvider_GetState_ResponseParams_Data)");
class  MediaRouter_RegisterMediaRouteProvider_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t provider_id;
  mojo::internal::Interface_Data media_router_provider;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_RegisterMediaRouteProvider_Params_Data>;

  MediaRouter_RegisterMediaRouteProvider_Params_Data();
  ~MediaRouter_RegisterMediaRouteProvider_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_RegisterMediaRouteProvider_Params_Data) == 24,
              "Bad sizeof(MediaRouter_RegisterMediaRouteProvider_Params_Data)");
class  MediaRouter_OnSinksReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t provider_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> media_source;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::MediaSink_Data>>> sinks;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::url::mojom::internal::Origin_Data>>> origins;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_OnSinksReceived_Params_Data>;

  MediaRouter_OnSinksReceived_Params_Data();
  ~MediaRouter_OnSinksReceived_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_OnSinksReceived_Params_Data) == 40,
              "Bad sizeof(MediaRouter_OnSinksReceived_Params_Data)");
class  MediaRouter_OnIssue_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::Issue_Data> issue;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_OnIssue_Params_Data>;

  MediaRouter_OnIssue_Params_Data();
  ~MediaRouter_OnIssue_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_OnIssue_Params_Data) == 16,
              "Bad sizeof(MediaRouter_OnIssue_Params_Data)");
class  MediaRouter_ClearTopIssueForSink_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> sink_id;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_ClearTopIssueForSink_Params_Data>;

  MediaRouter_ClearTopIssueForSink_Params_Data();
  ~MediaRouter_ClearTopIssueForSink_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_ClearTopIssueForSink_Params_Data) == 16,
              "Bad sizeof(MediaRouter_ClearTopIssueForSink_Params_Data)");
class  MediaRouter_OnRoutesUpdated_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t provider_id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::MediaRoute_Data>>> routes;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_OnRoutesUpdated_Params_Data>;

  MediaRouter_OnRoutesUpdated_Params_Data();
  ~MediaRouter_OnRoutesUpdated_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_OnRoutesUpdated_Params_Data) == 24,
              "Bad sizeof(MediaRouter_OnRoutesUpdated_Params_Data)");
class  MediaRouter_OnPresentationConnectionStateChanged_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> route_id;
  int32_t state;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_OnPresentationConnectionStateChanged_Params_Data>;

  MediaRouter_OnPresentationConnectionStateChanged_Params_Data();
  ~MediaRouter_OnPresentationConnectionStateChanged_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_OnPresentationConnectionStateChanged_Params_Data) == 24,
              "Bad sizeof(MediaRouter_OnPresentationConnectionStateChanged_Params_Data)");
class  MediaRouter_OnPresentationConnectionClosed_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> route_id;
  int32_t reason;
  uint8_t pad1_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> message;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_OnPresentationConnectionClosed_Params_Data>;

  MediaRouter_OnPresentationConnectionClosed_Params_Data();
  ~MediaRouter_OnPresentationConnectionClosed_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_OnPresentationConnectionClosed_Params_Data) == 32,
              "Bad sizeof(MediaRouter_OnPresentationConnectionClosed_Params_Data)");
class  MediaRouter_OnRouteMessagesReceived_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> route_id;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::RouteMessage_Data>>> messages;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_OnRouteMessagesReceived_Params_Data>;

  MediaRouter_OnRouteMessagesReceived_Params_Data();
  ~MediaRouter_OnRouteMessagesReceived_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_OnRouteMessagesReceived_Params_Data) == 24,
              "Bad sizeof(MediaRouter_OnRouteMessagesReceived_Params_Data)");
class  MediaRouter_GetMediaSinkServiceStatus_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_GetMediaSinkServiceStatus_Params_Data>;

  MediaRouter_GetMediaSinkServiceStatus_Params_Data();
  ~MediaRouter_GetMediaSinkServiceStatus_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_GetMediaSinkServiceStatus_Params_Data) == 8,
              "Bad sizeof(MediaRouter_GetMediaSinkServiceStatus_Params_Data)");
class  MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> status;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data>;

  MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data();
  ~MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data) == 16,
              "Bad sizeof(MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data)");
class  MediaRouter_GetLogger_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_GetLogger_Params_Data>;

  MediaRouter_GetLogger_Params_Data();
  ~MediaRouter_GetLogger_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_GetLogger_Params_Data) == 16,
              "Bad sizeof(MediaRouter_GetLogger_Params_Data)");
class  MediaRouter_GetDebugger_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data receiver;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_GetDebugger_Params_Data>;

  MediaRouter_GetDebugger_Params_Data();
  ~MediaRouter_GetDebugger_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_GetDebugger_Params_Data) == 16,
              "Bad sizeof(MediaRouter_GetDebugger_Params_Data)");
class  MediaRouter_GetLogsAsString_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_GetLogsAsString_Params_Data>;

  MediaRouter_GetLogsAsString_Params_Data();
  ~MediaRouter_GetLogsAsString_Params_Data() = delete;
};
static_assert(sizeof(MediaRouter_GetLogsAsString_Params_Data) == 8,
              "Bad sizeof(MediaRouter_GetLogsAsString_Params_Data)");
class  MediaRouter_GetLogsAsString_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> logs;

 private:
  friend class mojo::internal::MessageFragment<MediaRouter_GetLogsAsString_ResponseParams_Data>;

  MediaRouter_GetLogsAsString_ResponseParams_Data();
  ~MediaRouter_GetLogsAsString_ResponseParams_Data() = delete;
};
static_assert(sizeof(MediaRouter_GetLogsAsString_ResponseParams_Data) == 16,
              "Bad sizeof(MediaRouter_GetLogsAsString_ResponseParams_Data)");

}  // namespace internal


class MediaRouteProvider_CreateRoute_ParamsDataView {
 public:
  MediaRouteProvider_CreateRoute_ParamsDataView() = default;

  MediaRouteProvider_CreateRoute_ParamsDataView(
      internal::MediaRouteProvider_CreateRoute_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSource(UserType* output) {
    
    auto* pointer = data_->media_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinkId(UserType* output) {
    
    auto* pointer = data_->sink_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginalPresentationIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalPresentationId(UserType* output) {
    
    auto* pointer = data_->original_presentation_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  int32_t frame_tree_node_id() const {
    return data_->frame_tree_node_id;
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_CreateRoute_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_CreateRoute_ResponseParamsDataView {
 public:
  MediaRouteProvider_CreateRoute_ResponseParamsDataView() = default;

  MediaRouteProvider_CreateRoute_ResponseParamsDataView(
      internal::MediaRouteProvider_CreateRoute_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteDataView(
      MediaRouteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRoute(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_router::mojom::MediaRouteDataView, UserType>(),
    "Attempting to read the optional `route` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRoute` instead "
    "of `ReadRoute if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->route.Get();
    return mojo::internal::Deserialize<::media_router::mojom::MediaRouteDataView>(
        pointer, output, message_);
  }
  inline void GetConnectionDataView(
      RoutePresentationConnectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnection(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_router::mojom::RoutePresentationConnectionDataView, UserType>(),
    "Attempting to read the optional `connection` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConnection` instead "
    "of `ReadConnection if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->connection.Get();
    return mojo::internal::Deserialize<::media_router::mojom::RoutePresentationConnectionDataView>(
        pointer, output, message_);
  }
  inline void GetErrorTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadErrorText` instead "
    "of `ReadErrorText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResultCode(UserType* output) const {
    auto data_value = data_->result_code;
    return mojo::internal::Deserialize<::media_router::mojom::RouteRequestResultCode>(
        data_value, output);
  }
  ::media_router::mojom::RouteRequestResultCode result_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::RouteRequestResultCode>(data_->result_code));
  }
 private:
  internal::MediaRouteProvider_CreateRoute_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_JoinRoute_ParamsDataView {
 public:
  MediaRouteProvider_JoinRoute_ParamsDataView() = default;

  MediaRouteProvider_JoinRoute_ParamsDataView(
      internal::MediaRouteProvider_JoinRoute_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSource(UserType* output) {
    
    auto* pointer = data_->media_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPresentationIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPresentationId(UserType* output) {
    
    auto* pointer = data_->presentation_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetOriginDataView(
      ::url::mojom::OriginDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigin(UserType* output) {
    
    auto* pointer = data_->origin.Get();
    return mojo::internal::Deserialize<::url::mojom::OriginDataView>(
        pointer, output, message_);
  }
  int32_t frame_tree_node_id() const {
    return data_->frame_tree_node_id;
  }
  inline void GetTimeoutDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTimeout(UserType* output) {
    
    auto* pointer = data_->timeout.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_JoinRoute_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_JoinRoute_ResponseParamsDataView {
 public:
  MediaRouteProvider_JoinRoute_ResponseParamsDataView() = default;

  MediaRouteProvider_JoinRoute_ResponseParamsDataView(
      internal::MediaRouteProvider_JoinRoute_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteDataView(
      MediaRouteDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRoute(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_router::mojom::MediaRouteDataView, UserType>(),
    "Attempting to read the optional `route` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadRoute` instead "
    "of `ReadRoute if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->route.Get();
    return mojo::internal::Deserialize<::media_router::mojom::MediaRouteDataView>(
        pointer, output, message_);
  }
  inline void GetConnectionDataView(
      RoutePresentationConnectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadConnection(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_router::mojom::RoutePresentationConnectionDataView, UserType>(),
    "Attempting to read the optional `connection` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadConnection` instead "
    "of `ReadConnection if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->connection.Get();
    return mojo::internal::Deserialize<::media_router::mojom::RoutePresentationConnectionDataView>(
        pointer, output, message_);
  }
  inline void GetErrorTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadErrorText` instead "
    "of `ReadErrorText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResultCode(UserType* output) const {
    auto data_value = data_->result_code;
    return mojo::internal::Deserialize<::media_router::mojom::RouteRequestResultCode>(
        data_value, output);
  }
  ::media_router::mojom::RouteRequestResultCode result_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::RouteRequestResultCode>(data_->result_code));
  }
 private:
  internal::MediaRouteProvider_JoinRoute_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_TerminateRoute_ParamsDataView {
 public:
  MediaRouteProvider_TerminateRoute_ParamsDataView() = default;

  MediaRouteProvider_TerminateRoute_ParamsDataView(
      internal::MediaRouteProvider_TerminateRoute_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteId(UserType* output) {
    
    auto* pointer = data_->route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_TerminateRoute_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_TerminateRoute_ResponseParamsDataView {
 public:
  MediaRouteProvider_TerminateRoute_ResponseParamsDataView() = default;

  MediaRouteProvider_TerminateRoute_ResponseParamsDataView(
      internal::MediaRouteProvider_TerminateRoute_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetErrorTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorText(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `error_text` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadErrorText` instead "
    "of `ReadErrorText if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->error_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadResultCode(UserType* output) const {
    auto data_value = data_->result_code;
    return mojo::internal::Deserialize<::media_router::mojom::RouteRequestResultCode>(
        data_value, output);
  }
  ::media_router::mojom::RouteRequestResultCode result_code() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::RouteRequestResultCode>(data_->result_code));
  }
 private:
  internal::MediaRouteProvider_TerminateRoute_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_SendRouteMessage_ParamsDataView {
 public:
  MediaRouteProvider_SendRouteMessage_ParamsDataView() = default;

  MediaRouteProvider_SendRouteMessage_ParamsDataView(
      internal::MediaRouteProvider_SendRouteMessage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaRouteId(UserType* output) {
    
    auto* pointer = data_->media_route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_SendRouteMessage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_SendRouteBinaryMessage_ParamsDataView {
 public:
  MediaRouteProvider_SendRouteBinaryMessage_ParamsDataView() = default;

  MediaRouteProvider_SendRouteBinaryMessage_ParamsDataView(
      internal::MediaRouteProvider_SendRouteBinaryMessage_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaRouteId(UserType* output) {
    
    auto* pointer = data_->media_route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_SendRouteBinaryMessage_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_StartObservingMediaSinks_ParamsDataView {
 public:
  MediaRouteProvider_StartObservingMediaSinks_ParamsDataView() = default;

  MediaRouteProvider_StartObservingMediaSinks_ParamsDataView(
      internal::MediaRouteProvider_StartObservingMediaSinks_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSource(UserType* output) {
    
    auto* pointer = data_->media_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_StartObservingMediaSinks_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_StopObservingMediaSinks_ParamsDataView {
 public:
  MediaRouteProvider_StopObservingMediaSinks_ParamsDataView() = default;

  MediaRouteProvider_StopObservingMediaSinks_ParamsDataView(
      internal::MediaRouteProvider_StopObservingMediaSinks_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMediaSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSource(UserType* output) {
    
    auto* pointer = data_->media_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_StopObservingMediaSinks_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_StartObservingMediaRoutes_ParamsDataView {
 public:
  MediaRouteProvider_StartObservingMediaRoutes_ParamsDataView() = default;

  MediaRouteProvider_StartObservingMediaRoutes_ParamsDataView(
      internal::MediaRouteProvider_StartObservingMediaRoutes_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaRouteProvider_StartObservingMediaRoutes_Params_Data* data_ = nullptr;
};


class MediaRouteProvider_DetachRoute_ParamsDataView {
 public:
  MediaRouteProvider_DetachRoute_ParamsDataView() = default;

  MediaRouteProvider_DetachRoute_ParamsDataView(
      internal::MediaRouteProvider_DetachRoute_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteId(UserType* output) {
    
    auto* pointer = data_->route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_DetachRoute_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_DiscoverSinksNow_ParamsDataView {
 public:
  MediaRouteProvider_DiscoverSinksNow_ParamsDataView() = default;

  MediaRouteProvider_DiscoverSinksNow_ParamsDataView(
      internal::MediaRouteProvider_DiscoverSinksNow_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaRouteProvider_DiscoverSinksNow_Params_Data* data_ = nullptr;
};


class MediaRouteProvider_BindMediaController_ParamsDataView {
 public:
  MediaRouteProvider_BindMediaController_ParamsDataView() = default;

  MediaRouteProvider_BindMediaController_ParamsDataView(
      internal::MediaRouteProvider_BindMediaController_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteId(UserType* output) {
    
    auto* pointer = data_->route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeMediaController() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media_router::mojom::MediaControllerInterfaceBase>>(
            &data_->media_controller, &result, message_);
    DCHECK(ret);
    return result;
  }
  template <typename UserType>
  UserType TakeObserver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media_router::mojom::MediaStatusObserverInterfaceBase>>(
            &data_->observer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaRouteProvider_BindMediaController_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouteProvider_BindMediaController_ResponseParamsDataView {
 public:
  MediaRouteProvider_BindMediaController_ResponseParamsDataView() = default;

  MediaRouteProvider_BindMediaController_ResponseParamsDataView(
      internal::MediaRouteProvider_BindMediaController_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::MediaRouteProvider_BindMediaController_ResponseParams_Data* data_ = nullptr;
};


class MediaRouteProvider_GetState_ParamsDataView {
 public:
  MediaRouteProvider_GetState_ParamsDataView() = default;

  MediaRouteProvider_GetState_ParamsDataView(
      internal::MediaRouteProvider_GetState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaRouteProvider_GetState_Params_Data* data_ = nullptr;
};


class MediaRouteProvider_GetState_ResponseParamsDataView {
 public:
  MediaRouteProvider_GetState_ResponseParamsDataView() = default;

  MediaRouteProvider_GetState_ResponseParamsDataView(
      internal::MediaRouteProvider_GetState_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStateDataView(
      ProviderStateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media_router::mojom::ProviderStateDataView, UserType>(),
    "Attempting to read the optional `state` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadState` instead "
    "of `ReadState if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->state.is_null() ? &data_->state : nullptr;
    return mojo::internal::Deserialize<::media_router::mojom::ProviderStateDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouteProvider_GetState_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_RegisterMediaRouteProvider_ParamsDataView {
 public:
  MediaRouter_RegisterMediaRouteProvider_ParamsDataView() = default;

  MediaRouter_RegisterMediaRouteProvider_ParamsDataView(
      internal::MediaRouter_RegisterMediaRouteProvider_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProviderId(UserType* output) const {
    auto data_value = data_->provider_id;
    return mojo::internal::Deserialize<::media_router::mojom::MediaRouteProviderId>(
        data_value, output);
  }
  ::media_router::mojom::MediaRouteProviderId provider_id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::MediaRouteProviderId>(data_->provider_id));
  }
  template <typename UserType>
  UserType TakeMediaRouterProvider() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::media_router::mojom::MediaRouteProviderInterfaceBase>>(
            &data_->media_router_provider, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaRouter_RegisterMediaRouteProvider_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_OnSinksReceived_ParamsDataView {
 public:
  MediaRouter_OnSinksReceived_ParamsDataView() = default;

  MediaRouter_OnSinksReceived_ParamsDataView(
      internal::MediaRouter_OnSinksReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProviderId(UserType* output) const {
    auto data_value = data_->provider_id;
    return mojo::internal::Deserialize<::media_router::mojom::MediaRouteProviderId>(
        data_value, output);
  }
  ::media_router::mojom::MediaRouteProviderId provider_id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::MediaRouteProviderId>(data_->provider_id));
  }
  inline void GetMediaSourceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaSource(UserType* output) {
    
    auto* pointer = data_->media_source.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSinksDataView(
      mojo::ArrayDataView<MediaSinkDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinks(UserType* output) {
    
    auto* pointer = data_->sinks.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_router::mojom::MediaSinkDataView>>(
        pointer, output, message_);
  }
  inline void GetOriginsDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOrigins(UserType* output) {
    
    auto* pointer = data_->origins.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_OnSinksReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_OnIssue_ParamsDataView {
 public:
  MediaRouter_OnIssue_ParamsDataView() = default;

  MediaRouter_OnIssue_ParamsDataView(
      internal::MediaRouter_OnIssue_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIssueDataView(
      IssueDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssue(UserType* output) {
    
    auto* pointer = data_->issue.Get();
    return mojo::internal::Deserialize<::media_router::mojom::IssueDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_OnIssue_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_ClearTopIssueForSink_ParamsDataView {
 public:
  MediaRouter_ClearTopIssueForSink_ParamsDataView() = default;

  MediaRouter_ClearTopIssueForSink_ParamsDataView(
      internal::MediaRouter_ClearTopIssueForSink_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSinkIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSinkId(UserType* output) {
    
    auto* pointer = data_->sink_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_ClearTopIssueForSink_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_OnRoutesUpdated_ParamsDataView {
 public:
  MediaRouter_OnRoutesUpdated_ParamsDataView() = default;

  MediaRouter_OnRoutesUpdated_ParamsDataView(
      internal::MediaRouter_OnRoutesUpdated_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadProviderId(UserType* output) const {
    auto data_value = data_->provider_id;
    return mojo::internal::Deserialize<::media_router::mojom::MediaRouteProviderId>(
        data_value, output);
  }
  ::media_router::mojom::MediaRouteProviderId provider_id() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::media_router::mojom::MediaRouteProviderId>(data_->provider_id));
  }
  inline void GetRoutesDataView(
      mojo::ArrayDataView<MediaRouteDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRoutes(UserType* output) {
    
    auto* pointer = data_->routes.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_router::mojom::MediaRouteDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_OnRoutesUpdated_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_OnPresentationConnectionStateChanged_ParamsDataView {
 public:
  MediaRouter_OnPresentationConnectionStateChanged_ParamsDataView() = default;

  MediaRouter_OnPresentationConnectionStateChanged_ParamsDataView(
      internal::MediaRouter_OnPresentationConnectionStateChanged_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteId(UserType* output) {
    
    auto* pointer = data_->route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadState(UserType* output) const {
    auto data_value = data_->state;
    return mojo::internal::Deserialize<::blink::mojom::PresentationConnectionState>(
        data_value, output);
  }
  ::blink::mojom::PresentationConnectionState state() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PresentationConnectionState>(data_->state));
  }
 private:
  internal::MediaRouter_OnPresentationConnectionStateChanged_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_OnPresentationConnectionClosed_ParamsDataView {
 public:
  MediaRouter_OnPresentationConnectionClosed_ParamsDataView() = default;

  MediaRouter_OnPresentationConnectionClosed_ParamsDataView(
      internal::MediaRouter_OnPresentationConnectionClosed_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteId(UserType* output) {
    
    auto* pointer = data_->route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadReason(UserType* output) const {
    auto data_value = data_->reason;
    return mojo::internal::Deserialize<::blink::mojom::PresentationConnectionCloseReason>(
        data_value, output);
  }
  ::blink::mojom::PresentationConnectionCloseReason reason() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::PresentationConnectionCloseReason>(data_->reason));
  }
  inline void GetMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_OnPresentationConnectionClosed_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_OnRouteMessagesReceived_ParamsDataView {
 public:
  MediaRouter_OnRouteMessagesReceived_ParamsDataView() = default;

  MediaRouter_OnRouteMessagesReceived_ParamsDataView(
      internal::MediaRouter_OnRouteMessagesReceived_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetRouteIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRouteId(UserType* output) {
    
    auto* pointer = data_->route_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMessagesDataView(
      mojo::ArrayDataView<RouteMessageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessages(UserType* output) {
    
    auto* pointer = data_->messages.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media_router::mojom::RouteMessageDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_OnRouteMessagesReceived_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_GetMediaSinkServiceStatus_ParamsDataView {
 public:
  MediaRouter_GetMediaSinkServiceStatus_ParamsDataView() = default;

  MediaRouter_GetMediaSinkServiceStatus_ParamsDataView(
      internal::MediaRouter_GetMediaSinkServiceStatus_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaRouter_GetMediaSinkServiceStatus_Params_Data* data_ = nullptr;
};


class MediaRouter_GetMediaSinkServiceStatus_ResponseParamsDataView {
 public:
  MediaRouter_GetMediaSinkServiceStatus_ResponseParamsDataView() = default;

  MediaRouter_GetMediaSinkServiceStatus_ResponseParamsDataView(
      internal::MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetStatusDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatus(UserType* output) {
    
    auto* pointer = data_->status.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_GetMediaSinkServiceStatus_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_GetLogger_ParamsDataView {
 public:
  MediaRouter_GetLogger_ParamsDataView() = default;

  MediaRouter_GetLogger_ParamsDataView(
      internal::MediaRouter_GetLogger_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media_router::mojom::LoggerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaRouter_GetLogger_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_GetDebugger_ParamsDataView {
 public:
  MediaRouter_GetDebugger_ParamsDataView() = default;

  MediaRouter_GetDebugger_ParamsDataView(
      internal::MediaRouter_GetDebugger_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeReceiver() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::media_router::mojom::DebuggerInterfaceBase>>(
            &data_->receiver, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::MediaRouter_GetDebugger_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MediaRouter_GetLogsAsString_ParamsDataView {
 public:
  MediaRouter_GetLogsAsString_ParamsDataView() = default;

  MediaRouter_GetLogsAsString_ParamsDataView(
      internal::MediaRouter_GetLogsAsString_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::MediaRouter_GetLogsAsString_Params_Data* data_ = nullptr;
};


class MediaRouter_GetLogsAsString_ResponseParamsDataView {
 public:
  MediaRouter_GetLogsAsString_ResponseParamsDataView() = default;

  MediaRouter_GetLogsAsString_ResponseParamsDataView(
      internal::MediaRouter_GetLogsAsString_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLogsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLogs(UserType* output) {
    
    auto* pointer = data_->logs.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::MediaRouter_GetLogsAsString_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void MediaRouteProvider_CreateRoute_ParamsDataView::GetMediaSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteProvider_CreateRoute_ParamsDataView::GetSinkIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sink_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteProvider_CreateRoute_ParamsDataView::GetOriginalPresentationIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->original_presentation_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteProvider_CreateRoute_ParamsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void MediaRouteProvider_CreateRoute_ParamsDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void MediaRouteProvider_CreateRoute_ResponseParamsDataView::GetRouteDataView(
    MediaRouteDataView* output) {
  auto pointer = data_->route.Get();
  *output = MediaRouteDataView(pointer, message_);
}
inline void MediaRouteProvider_CreateRoute_ResponseParamsDataView::GetConnectionDataView(
    RoutePresentationConnectionDataView* output) {
  auto pointer = data_->connection.Get();
  *output = RoutePresentationConnectionDataView(pointer, message_);
}
inline void MediaRouteProvider_CreateRoute_ResponseParamsDataView::GetErrorTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouteProvider_JoinRoute_ParamsDataView::GetMediaSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteProvider_JoinRoute_ParamsDataView::GetPresentationIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->presentation_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteProvider_JoinRoute_ParamsDataView::GetOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void MediaRouteProvider_JoinRoute_ParamsDataView::GetTimeoutDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->timeout.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}


inline void MediaRouteProvider_JoinRoute_ResponseParamsDataView::GetRouteDataView(
    MediaRouteDataView* output) {
  auto pointer = data_->route.Get();
  *output = MediaRouteDataView(pointer, message_);
}
inline void MediaRouteProvider_JoinRoute_ResponseParamsDataView::GetConnectionDataView(
    RoutePresentationConnectionDataView* output) {
  auto pointer = data_->connection.Get();
  *output = RoutePresentationConnectionDataView(pointer, message_);
}
inline void MediaRouteProvider_JoinRoute_ResponseParamsDataView::GetErrorTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouteProvider_TerminateRoute_ParamsDataView::GetRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouteProvider_TerminateRoute_ResponseParamsDataView::GetErrorTextDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->error_text.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouteProvider_SendRouteMessage_ParamsDataView::GetMediaRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteProvider_SendRouteMessage_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouteProvider_SendRouteBinaryMessage_ParamsDataView::GetMediaRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouteProvider_SendRouteBinaryMessage_ParamsDataView::GetDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void MediaRouteProvider_StartObservingMediaSinks_ParamsDataView::GetMediaSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouteProvider_StopObservingMediaSinks_ParamsDataView::GetMediaSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void MediaRouteProvider_DetachRoute_ParamsDataView::GetRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void MediaRouteProvider_BindMediaController_ParamsDataView::GetRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}






inline void MediaRouteProvider_GetState_ResponseParamsDataView::GetStateDataView(
    ProviderStateDataView* output) {
  auto pointer = &data_->state;
  *output = ProviderStateDataView(pointer, message_);
}




inline void MediaRouter_OnSinksReceived_ParamsDataView::GetMediaSourceDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->media_source.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouter_OnSinksReceived_ParamsDataView::GetSinksDataView(
    mojo::ArrayDataView<MediaSinkDataView>* output) {
  auto pointer = data_->sinks.Get();
  *output = mojo::ArrayDataView<MediaSinkDataView>(pointer, message_);
}
inline void MediaRouter_OnSinksReceived_ParamsDataView::GetOriginsDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->origins.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, message_);
}


inline void MediaRouter_OnIssue_ParamsDataView::GetIssueDataView(
    IssueDataView* output) {
  auto pointer = data_->issue.Get();
  *output = IssueDataView(pointer, message_);
}


inline void MediaRouter_ClearTopIssueForSink_ParamsDataView::GetSinkIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sink_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouter_OnRoutesUpdated_ParamsDataView::GetRoutesDataView(
    mojo::ArrayDataView<MediaRouteDataView>* output) {
  auto pointer = data_->routes.Get();
  *output = mojo::ArrayDataView<MediaRouteDataView>(pointer, message_);
}


inline void MediaRouter_OnPresentationConnectionStateChanged_ParamsDataView::GetRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouter_OnPresentationConnectionClosed_ParamsDataView::GetRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouter_OnPresentationConnectionClosed_ParamsDataView::GetMessageDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->message.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void MediaRouter_OnRouteMessagesReceived_ParamsDataView::GetRouteIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->route_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void MediaRouter_OnRouteMessagesReceived_ParamsDataView::GetMessagesDataView(
    mojo::ArrayDataView<RouteMessageDataView>* output) {
  auto pointer = data_->messages.Get();
  *output = mojo::ArrayDataView<RouteMessageDataView>(pointer, message_);
}




inline void MediaRouter_GetMediaSinkServiceStatus_ResponseParamsDataView::GetStatusDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->status.Get();
  *output = mojo::StringDataView(pointer, message_);
}








inline void MediaRouter_GetLogsAsString_ResponseParamsDataView::GetLogsDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->logs.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // media_router::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // COMPONENTS_MEDIA_ROUTER_COMMON_MOJOM_MEDIA_ROUTER_MOJOM_PARAMS_DATA_H_