// components/media_router/common/mojom/media_controller.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/media_router/common/mojom/media_controller.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/media_router/common/mojom/media_controller.mojom-params-data.h"
#include "components/media_router/common/mojom/media_controller.mojom-shared-message-ids.h"

#include "components/media_router/common/mojom/media_controller.mojom-import-headers.h"
#include "components/media_router/common/mojom/media_controller.mojom-test-utils.h"


namespace media_router::mojom {
// The declaration includes the definition on other builds.

MediaController::IPCStableHashFunction MediaController::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MediaController>(message.name())) {
    case messages::MediaController::kPlay: {
      return &MediaController::Play_Sym::IPCStableHash;
    }
    case messages::MediaController::kPause: {
      return &MediaController::Pause_Sym::IPCStableHash;
    }
    case messages::MediaController::kSetMute: {
      return &MediaController::SetMute_Sym::IPCStableHash;
    }
    case messages::MediaController::kSetVolume: {
      return &MediaController::SetVolume_Sym::IPCStableHash;
    }
    case messages::MediaController::kSeek: {
      return &MediaController::Seek_Sym::IPCStableHash;
    }
    case messages::MediaController::kNextTrack: {
      return &MediaController::NextTrack_Sym::IPCStableHash;
    }
    case messages::MediaController::kPreviousTrack: {
      return &MediaController::PreviousTrack_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MediaController::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MediaController>(message.name())) {
      case messages::MediaController::kPlay:
            return "Receive media_router::mojom::MediaController::Play";
      case messages::MediaController::kPause:
            return "Receive media_router::mojom::MediaController::Pause";
      case messages::MediaController::kSetMute:
            return "Receive media_router::mojom::MediaController::SetMute";
      case messages::MediaController::kSetVolume:
            return "Receive media_router::mojom::MediaController::SetVolume";
      case messages::MediaController::kSeek:
            return "Receive media_router::mojom::MediaController::Seek";
      case messages::MediaController::kNextTrack:
            return "Receive media_router::mojom::MediaController::NextTrack";
      case messages::MediaController::kPreviousTrack:
            return "Receive media_router::mojom::MediaController::PreviousTrack";
    }
  } else {
    switch (static_cast<messages::MediaController>(message.name())) {
      case messages::MediaController::kPlay:
            return "Receive reply media_router::mojom::MediaController::Play";
      case messages::MediaController::kPause:
            return "Receive reply media_router::mojom::MediaController::Pause";
      case messages::MediaController::kSetMute:
            return "Receive reply media_router::mojom::MediaController::SetMute";
      case messages::MediaController::kSetVolume:
            return "Receive reply media_router::mojom::MediaController::SetVolume";
      case messages::MediaController::kSeek:
            return "Receive reply media_router::mojom::MediaController::Seek";
      case messages::MediaController::kNextTrack:
            return "Receive reply media_router::mojom::MediaController::NextTrack";
      case messages::MediaController::kPreviousTrack:
            return "Receive reply media_router::mojom::MediaController::PreviousTrack";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MediaController::Play_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9b9bd401;  // IPCStableHash for media_router::mojom::MediaController::Play
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::Pause_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3287f927;  // IPCStableHash for media_router::mojom::MediaController::Pause
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::SetMute_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x3054827d;  // IPCStableHash for media_router::mojom::MediaController::SetMute
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::SetVolume_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcdefba51;  // IPCStableHash for media_router::mojom::MediaController::SetVolume
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::Seek_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf92eb97b;  // IPCStableHash for media_router::mojom::MediaController::Seek
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::NextTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x36a022e5;  // IPCStableHash for media_router::mojom::MediaController::NextTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t MediaController::PreviousTrack_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1818d10e;  // IPCStableHash for media_router::mojom::MediaController::PreviousTrack
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

MediaControllerProxy::MediaControllerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void MediaControllerProxy::Play(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaController::Play");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kPlay), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaController_Play_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Play");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::Pause(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaController::Pause");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kPause), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaController_Pause_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Pause");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::SetMute(
    bool in_mute) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaController::SetMute", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mute"), in_mute,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSetMute), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaController_SetMute_Params_Data> params(
          message);
  params.Allocate();

  params->mute = in_mute;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SetMute");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::SetVolume(
    float in_volume) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaController::SetVolume", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("volume"), in_volume,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSetVolume), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaController_SetVolume_Params_Data> params(
          message);
  params.Allocate();

  params->volume = in_volume;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("SetVolume");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::Seek(
    ::base::TimeDelta in_time) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send media_router::mojom::MediaController::Seek", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("time"), in_time,
                        "<value of type ::base::TimeDelta>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kSeek), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaController_Seek_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->time)::BaseType> time_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
    in_time,
    time_fragment);

  params->time.Set(
      time_fragment.is_null() ? nullptr : time_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->time.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null time in MediaController.Seek request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("Seek");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::NextTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaController::NextTrack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kNextTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaController_NextTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("NextTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void MediaControllerProxy::PreviousTrack(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send media_router::mojom::MediaController::PreviousTrack");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MediaController::kPreviousTrack), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::media_router::mojom::internal::MediaController_PreviousTrack_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MediaController::Name_);
  message.set_method_name("PreviousTrack");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool MediaControllerStubDispatch::Accept(
    MediaController* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MediaController>(message->header()->name)) {
    case messages::MediaController::kPlay: {
      DCHECK(message->is_serialized());
      internal::MediaController_Play_Params_Data* params =
          reinterpret_cast<internal::MediaController_Play_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.0
      bool success = true;
      MediaController_Play_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Play(        );
      return true;
    }
    case messages::MediaController::kPause: {
      DCHECK(message->is_serialized());
      internal::MediaController_Pause_Params_Data* params =
          reinterpret_cast<internal::MediaController_Pause_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.1
      bool success = true;
      MediaController_Pause_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Pause(        );
      return true;
    }
    case messages::MediaController::kSetMute: {
      DCHECK(message->is_serialized());
      internal::MediaController_SetMute_Params_Data* params =
          reinterpret_cast<internal::MediaController_SetMute_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.2
      bool success = true;
      bool p_mute{};
      MediaController_SetMute_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_mute = input_data_view.mute();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMute(        
        std::move(p_mute));
      return true;
    }
    case messages::MediaController::kSetVolume: {
      DCHECK(message->is_serialized());
      internal::MediaController_SetVolume_Params_Data* params =
          reinterpret_cast<internal::MediaController_SetVolume_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.3
      bool success = true;
      float p_volume{};
      MediaController_SetVolume_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_volume = input_data_view.volume();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetVolume(        
        std::move(p_volume));
      return true;
    }
    case messages::MediaController::kSeek: {
      DCHECK(message->is_serialized());
      internal::MediaController_Seek_Params_Data* params =
          reinterpret_cast<internal::MediaController_Seek_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.4
      bool success = true;
      ::base::TimeDelta p_time{};
      MediaController_Seek_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTime(&p_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Seek(        
        std::move(p_time));
      return true;
    }
    case messages::MediaController::kNextTrack: {
      DCHECK(message->is_serialized());
      internal::MediaController_NextTrack_Params_Data* params =
          reinterpret_cast<internal::MediaController_NextTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.5
      bool success = true;
      MediaController_NextTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NextTrack(        );
      return true;
    }
    case messages::MediaController::kPreviousTrack: {
      DCHECK(message->is_serialized());
      internal::MediaController_PreviousTrack_Params_Data* params =
          reinterpret_cast<internal::MediaController_PreviousTrack_Params_Data*>(
              message->mutable_payload());
      

      // Validation for MediaController.6
      bool success = true;
      MediaController_PreviousTrack_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MediaController::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreviousTrack(        );
      return true;
    }
  }
  return false;
}

// static
bool MediaControllerStubDispatch::AcceptWithResponder(
    MediaController* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MediaController>(message->header()->name)) {
    case messages::MediaController::kPlay: {
      break;
    }
    case messages::MediaController::kPause: {
      break;
    }
    case messages::MediaController::kSetMute: {
      break;
    }
    case messages::MediaController::kSetVolume: {
      break;
    }
    case messages::MediaController::kSeek: {
      break;
    }
    case messages::MediaController::kNextTrack: {
      break;
    }
    case messages::MediaController::kPreviousTrack: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMediaControllerValidationInfo[] = {
    { &internal::MediaController_Play_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_Pause_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_SetMute_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_SetVolume_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_Seek_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_NextTrack_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::MediaController_PreviousTrack_Params_Data::Validate,
     nullptr /* no response */},
};

bool MediaControllerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::media_router::mojom::MediaController::Name_,
    kMediaControllerValidationInfo);
}



}  // media_router::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace media_router::mojom {


void MediaControllerInterceptorForTesting::Play() {
  GetForwardingInterface()->Play();
}
void MediaControllerInterceptorForTesting::Pause() {
  GetForwardingInterface()->Pause();
}
void MediaControllerInterceptorForTesting::SetMute(bool mute) {
  GetForwardingInterface()->SetMute(
    std::move(mute)
    );
}
void MediaControllerInterceptorForTesting::SetVolume(float volume) {
  GetForwardingInterface()->SetVolume(
    std::move(volume)
    );
}
void MediaControllerInterceptorForTesting::Seek(::base::TimeDelta time) {
  GetForwardingInterface()->Seek(
    std::move(time)
    );
}
void MediaControllerInterceptorForTesting::NextTrack() {
  GetForwardingInterface()->NextTrack();
}
void MediaControllerInterceptorForTesting::PreviousTrack() {
  GetForwardingInterface()->PreviousTrack();
}
MediaControllerAsyncWaiter::MediaControllerAsyncWaiter(
    MediaController* proxy) : proxy_(proxy) {}

MediaControllerAsyncWaiter::~MediaControllerAsyncWaiter() = default;







}  // media_router::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif