// components/lens/lens_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_LENS_LENS_METADATA_MOJOM_H_
#define COMPONENTS_LENS_LENS_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/lens/lens_metadata.mojom-features.h"  // IWYU pragma: export
#include "components/lens/lens_metadata.mojom-shared.h"  // IWYU pragma: export
#include "components/lens/lens_metadata.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include <string>
#include <vector>








namespace lens::mojom {








class  LatencyLog {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LatencyLog, T>::value>;
  using DataView = LatencyLogDataView;
  using Data_ = internal::LatencyLog_Data;

  template <typename... Args>
  static LatencyLogPtr New(Args&&... args) {
    return LatencyLogPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LatencyLogPtr From(const U& u) {
    return mojo::TypeConverter<LatencyLogPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LatencyLog>::Convert(*this);
  }


  LatencyLog();

  LatencyLog(
      Phase phase,
      const ::gfx::Size& original_size,
      const ::gfx::Size& downscaled_size,
      ImageFormat image_format,
      ::base::Time time,
      uint32_t encoded_bytes_size);


  ~LatencyLog();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LatencyLogPtr>
  LatencyLogPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LatencyLog::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LatencyLog::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LatencyLog::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LatencyLog::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LatencyLog::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LatencyLog::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LatencyLog_UnserializedMessageContext<
            UserType, LatencyLog::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LatencyLog::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LatencyLog::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LatencyLog_UnserializedMessageContext<
            UserType, LatencyLog::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LatencyLog::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  Phase phase;
  
  ::gfx::Size original_size;
  
  ::gfx::Size downscaled_size;
  
  ImageFormat image_format;
  
  ::base::Time time;
  
  uint32_t encoded_bytes_size;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LatencyLog::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LatencyLog::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LatencyLog::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LatencyLog::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LatencyLogPtr LatencyLog::Clone() const {
  return New(
      mojo::Clone(phase),
      mojo::Clone(original_size),
      mojo::Clone(downscaled_size),
      mojo::Clone(image_format),
      mojo::Clone(time),
      mojo::Clone(encoded_bytes_size)
  );
}

template <typename T, LatencyLog::EnableIfSame<T>*>
bool LatencyLog::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->phase, other_struct.phase))
    return false;
  if (!mojo::Equals(this->original_size, other_struct.original_size))
    return false;
  if (!mojo::Equals(this->downscaled_size, other_struct.downscaled_size))
    return false;
  if (!mojo::Equals(this->image_format, other_struct.image_format))
    return false;
  if (!mojo::Equals(this->time, other_struct.time))
    return false;
  if (!mojo::Equals(this->encoded_bytes_size, other_struct.encoded_bytes_size))
    return false;
  return true;
}

template <typename T, LatencyLog::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.phase < rhs.phase)
    return true;
  if (rhs.phase < lhs.phase)
    return false;
  if (lhs.original_size < rhs.original_size)
    return true;
  if (rhs.original_size < lhs.original_size)
    return false;
  if (lhs.downscaled_size < rhs.downscaled_size)
    return true;
  if (rhs.downscaled_size < lhs.downscaled_size)
    return false;
  if (lhs.image_format < rhs.image_format)
    return true;
  if (rhs.image_format < lhs.image_format)
    return false;
  if (lhs.time < rhs.time)
    return true;
  if (rhs.time < lhs.time)
    return false;
  if (lhs.encoded_bytes_size < rhs.encoded_bytes_size)
    return true;
  if (rhs.encoded_bytes_size < lhs.encoded_bytes_size)
    return false;
  return false;
}


}  // lens::mojom

namespace mojo {


template <>
struct  StructTraits<::lens::mojom::LatencyLog::DataView,
                                         ::lens::mojom::LatencyLogPtr> {
  static bool IsNull(const ::lens::mojom::LatencyLogPtr& input) { return !input; }
  static void SetToNull(::lens::mojom::LatencyLogPtr* output) { output->reset(); }

  static decltype(::lens::mojom::LatencyLog::phase) phase(
      const ::lens::mojom::LatencyLogPtr& input) {
    return input->phase;
  }

  static const decltype(::lens::mojom::LatencyLog::original_size)& original_size(
      const ::lens::mojom::LatencyLogPtr& input) {
    return input->original_size;
  }

  static const decltype(::lens::mojom::LatencyLog::downscaled_size)& downscaled_size(
      const ::lens::mojom::LatencyLogPtr& input) {
    return input->downscaled_size;
  }

  static decltype(::lens::mojom::LatencyLog::image_format) image_format(
      const ::lens::mojom::LatencyLogPtr& input) {
    return input->image_format;
  }

  static const decltype(::lens::mojom::LatencyLog::time)& time(
      const ::lens::mojom::LatencyLogPtr& input) {
    return input->time;
  }

  static decltype(::lens::mojom::LatencyLog::encoded_bytes_size) encoded_bytes_size(
      const ::lens::mojom::LatencyLogPtr& input) {
    return input->encoded_bytes_size;
  }

  static bool Read(::lens::mojom::LatencyLog::DataView input, ::lens::mojom::LatencyLogPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_LENS_LENS_METADATA_MOJOM_H_