// components/lens/lens_metadata.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/lens/lens_metadata.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/lens/lens_metadata.mojom-params-data.h"
namespace lens {
namespace mojom {

NOINLINE static const char* ImageFormatToStringHelper(ImageFormat value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ImageFormat::JPEG:
      return "JPEG";
    case ImageFormat::PNG:
      return "PNG";
    case ImageFormat::WEBP:
      return "WEBP";
    case ImageFormat::ORIGINAL:
      return "ORIGINAL";
    default:
      return nullptr;
  }
}

std::string ImageFormatToString(ImageFormat value) {
  const char *str = ImageFormatToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ImageFormat value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ImageFormat value) {
  return os << ImageFormatToString(value);
}

NOINLINE static const char* PhaseToStringHelper(Phase value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case Phase::OVERALL_START:
      return "OVERALL_START";
    case Phase::DOWNSCALE_START:
      return "DOWNSCALE_START";
    case Phase::DOWNSCALE_END:
      return "DOWNSCALE_END";
    case Phase::ENCODE_START:
      return "ENCODE_START";
    case Phase::ENCODE_END:
      return "ENCODE_END";
    default:
      return nullptr;
  }
}

std::string PhaseToString(Phase value) {
  const char *str = PhaseToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown Phase value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, Phase value) {
  return os << PhaseToString(value);
}

namespace internal {


// static
bool LatencyLog_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const LatencyLog_Data* object =
      static_cast<const LatencyLog_Data*>(data);


  if (!::lens::mojom::internal::Phase_Data
        ::Validate(object->phase, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_size, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_size, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->downscaled_size, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->downscaled_size, validation_context))
    return false;


  if (!::lens::mojom::internal::ImageFormat_Data
        ::Validate(object->image_format, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time, validation_context))
    return false;

  return true;
}

LatencyLog_Data::LatencyLog_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace lens

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::ImageFormat>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::ImageFormat value) {
  return std::move(context).WriteString(::lens::mojom::ImageFormatToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::lens::mojom::Phase>::WriteIntoTrace(
   perfetto::TracedValue context, ::lens::mojom::Phase value) {
  return std::move(context).WriteString(::lens::mojom::PhaseToString(value));
}

} // namespace perfetto