// components/lens/lens_metadata.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_LENS_LENS_METADATA_MOJOM_DATA_VIEW_H_
#define COMPONENTS_LENS_LENS_METADATA_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/lens/lens_metadata.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"


namespace lens::mojom {
class LatencyLogDataView;



}  // lens::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::lens::mojom::LatencyLogDataView> {
  using Data = ::lens::mojom::internal::LatencyLog_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace lens::mojom {


enum class ImageFormat : int32_t {
  
  JPEG = 0,
  
  PNG = 1,
  
  WEBP = 2,
  
  ORIGINAL = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, ImageFormat value);
inline bool IsKnownEnumValue(ImageFormat value) {
  return internal::ImageFormat_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class Phase : int32_t {
  
  OVERALL_START = 0,
  
  DOWNSCALE_START = 1,
  
  DOWNSCALE_END = 2,
  
  ENCODE_START = 3,
  
  ENCODE_END = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

 std::ostream& operator<<(std::ostream& os, Phase value);
inline bool IsKnownEnumValue(Phase value) {
  return internal::Phase_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class LatencyLogDataView {
 public:
  LatencyLogDataView() = default;

  LatencyLogDataView(
      internal::LatencyLog_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadPhase(UserType* output) const {
    auto data_value = data_->phase;
    return mojo::internal::Deserialize<::lens::mojom::Phase>(
        data_value, output);
  }
  Phase phase() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::Phase>(data_->phase));
  }
  inline void GetOriginalSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOriginalSize(UserType* output) {
    
    auto* pointer = data_->original_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  inline void GetDownscaledSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDownscaledSize(UserType* output) {
    
    auto* pointer = data_->downscaled_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadImageFormat(UserType* output) const {
    auto data_value = data_->image_format;
    return mojo::internal::Deserialize<::lens::mojom::ImageFormat>(
        data_value, output);
  }
  ImageFormat image_format() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::lens::mojom::ImageFormat>(data_->image_format));
  }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  uint32_t encoded_bytes_size() const {
    return data_->encoded_bytes_size;
  }
 private:
  internal::LatencyLog_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // lens::mojom

#endif  // COMPONENTS_LENS_LENS_METADATA_MOJOM_DATA_VIEW_H_