// components/language_detection/content/common/language_detection.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/language_detection/content/common/language_detection.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/language_detection/content/common/language_detection.mojom-params-data.h"
namespace language_detection {
namespace mojom {

NOINLINE static const char* LanguageDetectionModelStatusToStringHelper(LanguageDetectionModelStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case LanguageDetectionModelStatus::kReadily:
      return "kReadily";
    case LanguageDetectionModelStatus::kAfterDownload:
      return "kAfterDownload";
    case LanguageDetectionModelStatus::kNotAvailable:
      return "kNotAvailable";
    default:
      return nullptr;
  }
}

std::string LanguageDetectionModelStatusToString(LanguageDetectionModelStatus value) {
  const char *str = LanguageDetectionModelStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown LanguageDetectionModelStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, LanguageDetectionModelStatus value) {
  return os << LanguageDetectionModelStatusToString(value);
}

namespace internal {


// static
bool ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data* object =
      static_cast<const ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data*>(data);

  return true;
}

ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data::ContentLanguageDetectionDriver_GetLanguageDetectionModel_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data* object =
      static_cast<const ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->model_file, validation_context))
    return false;

  return true;
}

ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data::ContentLanguageDetectionDriver_GetLanguageDetectionModel_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data* object =
      static_cast<const ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data*>(data);

  return true;
}

ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data* object =
      static_cast<const ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data*>(data);


  if (!::language_detection::mojom::internal::LanguageDetectionModelStatus_Data
        ::Validate(object->status, validation_context))
    return false;

  return true;
}

ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data::ContentLanguageDetectionDriver_GetLanguageDetectionModelStatus_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace language_detection

namespace perfetto {

// static
void TraceFormatTraits<::language_detection::mojom::LanguageDetectionModelStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::language_detection::mojom::LanguageDetectionModelStatus value) {
  return std::move(context).WriteString(::language_detection::mojom::LanguageDetectionModelStatusToString(value));
}

} // namespace perfetto