// components/ip_protection/mojom/data_types.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/ip_protection/mojom/data_types.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ipProtection.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }


  var ProxyLayer = {};
  ProxyLayer.kProxyA = 0;
  ProxyLayer.kProxyB = 1;
  ProxyLayer.MIN_VALUE = 0;
  ProxyLayer.MAX_VALUE = 1;

  ProxyLayer.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ProxyLayer.toKnownEnumValue = function(value) {
    return value;
  };

  ProxyLayer.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var TryGetProbabilisticRevealTokensStatus = {};
  TryGetProbabilisticRevealTokensStatus.kSuccess = 0;
  TryGetProbabilisticRevealTokensStatus.kNetNotOk = 1;
  TryGetProbabilisticRevealTokensStatus.kNetOkNullResponse = 2;
  TryGetProbabilisticRevealTokensStatus.kNullResponse = 3;
  TryGetProbabilisticRevealTokensStatus.kResponseParsingFailed = 4;
  TryGetProbabilisticRevealTokensStatus.kInvalidTokenVersion = 5;
  TryGetProbabilisticRevealTokensStatus.kInvalidTokenSize = 6;
  TryGetProbabilisticRevealTokensStatus.kTooFewTokens = 7;
  TryGetProbabilisticRevealTokensStatus.kTooManyTokens = 8;
  TryGetProbabilisticRevealTokensStatus.kExpirationTooSoon = 9;
  TryGetProbabilisticRevealTokensStatus.kExpirationTooLate = 10;
  TryGetProbabilisticRevealTokensStatus.kInvalidPublicKey = 11;
  TryGetProbabilisticRevealTokensStatus.kInvalidNumTokensWithSignal = 12;
  TryGetProbabilisticRevealTokensStatus.kRequestBackedOff = 13;
  TryGetProbabilisticRevealTokensStatus.kNoGoogleChromeBranding = 14;
  TryGetProbabilisticRevealTokensStatus.kInvalidEpochIdSize = 15;
  TryGetProbabilisticRevealTokensStatus.MIN_VALUE = 0;
  TryGetProbabilisticRevealTokensStatus.MAX_VALUE = 15;

  TryGetProbabilisticRevealTokensStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
    case 11:
    case 12:
    case 13:
    case 14:
    case 15:
      return true;
    }
    return false;
  };

  TryGetProbabilisticRevealTokensStatus.toKnownEnumValue = function(value) {
    return value;
  };

  TryGetProbabilisticRevealTokensStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var IpProxyStatus = {};
  IpProxyStatus.kOk = 0;
  IpProxyStatus.kFeatureNotEnabled = 1;
  IpProxyStatus.kMaskedDomainListNotEnabled = 2;
  IpProxyStatus.kMaskedDomainListNotPopulated = 3;
  IpProxyStatus.kAuthTokensUnavailable = 4;
  IpProxyStatus.kUnavailable = 5;
  IpProxyStatus.kBypassedByDevTools = 6;
  IpProxyStatus.MIN_VALUE = 0;
  IpProxyStatus.MAX_VALUE = 6;

  IpProxyStatus.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
      return true;
    }
    return false;
  };

  IpProxyStatus.toKnownEnumValue = function(value) {
    return value;
  };

  IpProxyStatus.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function GeoHint(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GeoHint.prototype.initDefaults_ = function() {
    this.countryCode = null;
    this.isoRegion = null;
    this.cityName = null;
  };
  GeoHint.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GeoHint.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeoHint.countryCode
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeoHint.isoRegion
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate GeoHint.cityName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GeoHint.encodedSize = codec.kStructHeaderSize + 24;

  GeoHint.decode = function(decoder) {
    var packed;
    var val = new GeoHint();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.countryCode =
        decoder.decodeStruct(codec.String);
    val.isoRegion =
        decoder.decodeStruct(codec.String);
    val.cityName =
        decoder.decodeStruct(codec.String);
    return val;
  };

  GeoHint.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GeoHint.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.countryCode);
    encoder.encodeStruct(codec.String, val.isoRegion);
    encoder.encodeStruct(codec.String, val.cityName);
  };
  function BlindSignedAuthToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BlindSignedAuthToken.prototype.initDefaults_ = function() {
    this.token = null;
    this.expiration = null;
    this.geoHint = null;
  };
  BlindSignedAuthToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BlindSignedAuthToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlindSignedAuthToken.token
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlindSignedAuthToken.expiration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BlindSignedAuthToken.geoHint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, GeoHint, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  BlindSignedAuthToken.encodedSize = codec.kStructHeaderSize + 24;

  BlindSignedAuthToken.decode = function(decoder) {
    var packed;
    var val = new BlindSignedAuthToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.String);
    val.expiration =
        decoder.decodeStructPointer(time$.Time);
    val.geoHint =
        decoder.decodeStructPointer(GeoHint);
    return val;
  };

  BlindSignedAuthToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BlindSignedAuthToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.token);
    encoder.encodeStructPointer(time$.Time, val.expiration);
    encoder.encodeStructPointer(GeoHint, val.geoHint);
  };
  function ProbabilisticRevealToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ProbabilisticRevealToken.prototype.initDefaults_ = function() {
    this.version = 0;
    this.u = null;
    this.e = null;
  };
  ProbabilisticRevealToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ProbabilisticRevealToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate ProbabilisticRevealToken.u
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate ProbabilisticRevealToken.e
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ProbabilisticRevealToken.encodedSize = codec.kStructHeaderSize + 24;

  ProbabilisticRevealToken.decode = function(decoder) {
    var packed;
    var val = new ProbabilisticRevealToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.version =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.u =
        decoder.decodeStruct(codec.String);
    val.e =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ProbabilisticRevealToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ProbabilisticRevealToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.version);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.u);
    encoder.encodeStruct(codec.String, val.e);
  };
  function TryGetProbabilisticRevealTokensResult(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TryGetProbabilisticRevealTokensResult.prototype.initDefaults_ = function() {
    this.status = 0;
    this.networkErrorCode = 0;
    this.tryAgainAfter = null;
  };
  TryGetProbabilisticRevealTokensResult.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TryGetProbabilisticRevealTokensResult.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TryGetProbabilisticRevealTokensResult.status
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, TryGetProbabilisticRevealTokensStatus);
    if (err !== validator.validationError.NONE)
        return err;



    // validate TryGetProbabilisticRevealTokensResult.tryAgainAfter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TryGetProbabilisticRevealTokensResult.encodedSize = codec.kStructHeaderSize + 16;

  TryGetProbabilisticRevealTokensResult.decode = function(decoder) {
    var packed;
    var val = new TryGetProbabilisticRevealTokensResult();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.status =
        decoder.decodeStruct(new codec.Enum(TryGetProbabilisticRevealTokensStatus));
    val.networkErrorCode =
        decoder.decodeStruct(codec.Int32);
    val.tryAgainAfter =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  TryGetProbabilisticRevealTokensResult.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TryGetProbabilisticRevealTokensResult.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.status);
    encoder.encodeStruct(codec.Int32, val.networkErrorCode);
    encoder.encodeStructPointer(time$.Time, val.tryAgainAfter);
  };
  function TryGetProbabilisticRevealTokensOutcome(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  TryGetProbabilisticRevealTokensOutcome.prototype.initDefaults_ = function() {
    this.tokens = null;
    this.publicKey = null;
    this.expirationTimeSeconds = 0;
    this.nextEpochStartTimeSeconds = 0;
    this.numTokensWithSignal = 0;
    this.epochId = null;
  };
  TryGetProbabilisticRevealTokensOutcome.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  TryGetProbabilisticRevealTokensOutcome.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TryGetProbabilisticRevealTokensOutcome.tokens
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ProbabilisticRevealToken), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate TryGetProbabilisticRevealTokensOutcome.publicKey
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;





    // validate TryGetProbabilisticRevealTokensOutcome.epochId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 40, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  TryGetProbabilisticRevealTokensOutcome.encodedSize = codec.kStructHeaderSize + 48;

  TryGetProbabilisticRevealTokensOutcome.decode = function(decoder) {
    var packed;
    var val = new TryGetProbabilisticRevealTokensOutcome();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.tokens =
        decoder.decodeArrayPointer(new codec.PointerTo(ProbabilisticRevealToken));
    val.publicKey =
        decoder.decodeStruct(codec.String);
    val.expirationTimeSeconds =
        decoder.decodeStruct(codec.Uint64);
    val.nextEpochStartTimeSeconds =
        decoder.decodeStruct(codec.Uint64);
    val.numTokensWithSignal =
        decoder.decodeStruct(codec.Int32);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.epochId =
        decoder.decodeStruct(codec.String);
    return val;
  };

  TryGetProbabilisticRevealTokensOutcome.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(TryGetProbabilisticRevealTokensOutcome.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ProbabilisticRevealToken), val.tokens);
    encoder.encodeStruct(codec.String, val.publicKey);
    encoder.encodeStruct(codec.Uint64, val.expirationTimeSeconds);
    encoder.encodeStruct(codec.Uint64, val.nextEpochStartTimeSeconds);
    encoder.encodeStruct(codec.Int32, val.numTokensWithSignal);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.epochId);
  };
  exports.ProxyLayer = ProxyLayer;
  exports.TryGetProbabilisticRevealTokensStatus = TryGetProbabilisticRevealTokensStatus;
  exports.IpProxyStatus = IpProxyStatus;
  exports.GeoHint = GeoHint;
  exports.BlindSignedAuthToken = BlindSignedAuthToken;
  exports.ProbabilisticRevealToken = ProbabilisticRevealToken;
  exports.TryGetProbabilisticRevealTokensResult = TryGetProbabilisticRevealTokensResult;
  exports.TryGetProbabilisticRevealTokensOutcome = TryGetProbabilisticRevealTokensOutcome;
})();