// components/ip_protection/mojom/data_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/ip_protection/mojom/data_types.mojom-features.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/data_types.mojom-shared.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/data_types.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include <string>
#include <vector>




#include "components/ip_protection/mojom/data_types_mojom_traits.h"




namespace ip_protection::mojom {





class  GeoHint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GeoHint, T>::value>;
  using DataView = GeoHintDataView;
  using Data_ = internal::GeoHint_Data;

  template <typename... Args>
  static GeoHintPtr New(Args&&... args) {
    return GeoHintPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GeoHintPtr From(const U& u) {
    return mojo::TypeConverter<GeoHintPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GeoHint>::Convert(*this);
  }


  GeoHint();

  GeoHint(
      const std::string& country_code,
      const std::string& iso_region,
      const std::string& city_name);


  ~GeoHint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GeoHintPtr>
  GeoHintPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GeoHint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GeoHint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GeoHint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeoHint::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GeoHint::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GeoHint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GeoHint_UnserializedMessageContext<
            UserType, GeoHint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GeoHint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GeoHint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GeoHint_UnserializedMessageContext<
            UserType, GeoHint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GeoHint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string country_code;
  
  std::string iso_region;
  
  std::string city_name;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GeoHint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GeoHint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GeoHint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GeoHint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  BlindSignedAuthToken {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<BlindSignedAuthToken, T>::value>;
  using DataView = BlindSignedAuthTokenDataView;
  using Data_ = internal::BlindSignedAuthToken_Data;

  template <typename... Args>
  static BlindSignedAuthTokenPtr New(Args&&... args) {
    return BlindSignedAuthTokenPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static BlindSignedAuthTokenPtr From(const U& u) {
    return mojo::TypeConverter<BlindSignedAuthTokenPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, BlindSignedAuthToken>::Convert(*this);
  }


  BlindSignedAuthToken();

  BlindSignedAuthToken(
      const std::string& token,
      ::base::Time expiration,
      const ::ip_protection::GeoHint& geo_hint);


  ~BlindSignedAuthToken();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = BlindSignedAuthTokenPtr>
  BlindSignedAuthTokenPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, BlindSignedAuthToken::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, BlindSignedAuthToken::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, BlindSignedAuthToken::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlindSignedAuthToken::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        BlindSignedAuthToken::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        BlindSignedAuthToken::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::BlindSignedAuthToken_UnserializedMessageContext<
            UserType, BlindSignedAuthToken::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<BlindSignedAuthToken::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return BlindSignedAuthToken::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::BlindSignedAuthToken_UnserializedMessageContext<
            UserType, BlindSignedAuthToken::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<BlindSignedAuthToken::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string token;
  
  ::base::Time expiration;
  
  ::ip_protection::GeoHint geo_hint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, BlindSignedAuthToken::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, BlindSignedAuthToken::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, BlindSignedAuthToken::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, BlindSignedAuthToken::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GeoHintPtr GeoHint::Clone() const {
  return New(
      mojo::Clone(country_code),
      mojo::Clone(iso_region),
      mojo::Clone(city_name)
  );
}

template <typename T, GeoHint::EnableIfSame<T>*>
bool GeoHint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->country_code, other_struct.country_code))
    return false;
  if (!mojo::Equals(this->iso_region, other_struct.iso_region))
    return false;
  if (!mojo::Equals(this->city_name, other_struct.city_name))
    return false;
  return true;
}

template <typename T, GeoHint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.country_code < rhs.country_code)
    return true;
  if (rhs.country_code < lhs.country_code)
    return false;
  if (lhs.iso_region < rhs.iso_region)
    return true;
  if (rhs.iso_region < lhs.iso_region)
    return false;
  if (lhs.city_name < rhs.city_name)
    return true;
  if (rhs.city_name < lhs.city_name)
    return false;
  return false;
}
template <typename StructPtrType>
BlindSignedAuthTokenPtr BlindSignedAuthToken::Clone() const {
  return New(
      mojo::Clone(token),
      mojo::Clone(expiration),
      mojo::Clone(geo_hint)
  );
}

template <typename T, BlindSignedAuthToken::EnableIfSame<T>*>
bool BlindSignedAuthToken::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->token, other_struct.token))
    return false;
  if (!mojo::Equals(this->expiration, other_struct.expiration))
    return false;
  if (!mojo::Equals(this->geo_hint, other_struct.geo_hint))
    return false;
  return true;
}

template <typename T, BlindSignedAuthToken::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.token < rhs.token)
    return true;
  if (rhs.token < lhs.token)
    return false;
  if (lhs.expiration < rhs.expiration)
    return true;
  if (rhs.expiration < lhs.expiration)
    return false;
  if (lhs.geo_hint < rhs.geo_hint)
    return true;
  if (rhs.geo_hint < lhs.geo_hint)
    return false;
  return false;
}


}  // ip_protection::mojom

namespace mojo {


template <>
struct  StructTraits<::ip_protection::mojom::GeoHint::DataView,
                                         ::ip_protection::mojom::GeoHintPtr> {
  static bool IsNull(const ::ip_protection::mojom::GeoHintPtr& input) { return !input; }
  static void SetToNull(::ip_protection::mojom::GeoHintPtr* output) { output->reset(); }

  static const decltype(::ip_protection::mojom::GeoHint::country_code)& country_code(
      const ::ip_protection::mojom::GeoHintPtr& input) {
    return input->country_code;
  }

  static const decltype(::ip_protection::mojom::GeoHint::iso_region)& iso_region(
      const ::ip_protection::mojom::GeoHintPtr& input) {
    return input->iso_region;
  }

  static const decltype(::ip_protection::mojom::GeoHint::city_name)& city_name(
      const ::ip_protection::mojom::GeoHintPtr& input) {
    return input->city_name;
  }

  static bool Read(::ip_protection::mojom::GeoHint::DataView input, ::ip_protection::mojom::GeoHintPtr* output);
};


template <>
struct  StructTraits<::ip_protection::mojom::BlindSignedAuthToken::DataView,
                                         ::ip_protection::mojom::BlindSignedAuthTokenPtr> {
  static bool IsNull(const ::ip_protection::mojom::BlindSignedAuthTokenPtr& input) { return !input; }
  static void SetToNull(::ip_protection::mojom::BlindSignedAuthTokenPtr* output) { output->reset(); }

  static const decltype(::ip_protection::mojom::BlindSignedAuthToken::token)& token(
      const ::ip_protection::mojom::BlindSignedAuthTokenPtr& input) {
    return input->token;
  }

  static const decltype(::ip_protection::mojom::BlindSignedAuthToken::expiration)& expiration(
      const ::ip_protection::mojom::BlindSignedAuthTokenPtr& input) {
    return input->expiration;
  }

  static const decltype(::ip_protection::mojom::BlindSignedAuthToken::geo_hint)& geo_hint(
      const ::ip_protection::mojom::BlindSignedAuthTokenPtr& input) {
    return input->geo_hint;
  }

  static bool Read(::ip_protection::mojom::BlindSignedAuthToken::DataView input, ::ip_protection::mojom::BlindSignedAuthTokenPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_H_