// components/ip_protection/mojom/data_types.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SEND_VALIDATION_H_

#include "components/ip_protection/mojom/data_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"

#include "components/ip_protection/mojom/data_types.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ip_protection::mojom::ProxyLayer, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ip_protection::mojom::GeoHintDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::GeoHintDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::GeoHint_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::country_code(input)) in_country_code = Traits::country_code(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->country_code)::BaseType> country_code_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_country_code,
        country_code_fragment);

      fragment->country_code.Set(
          country_code_fragment.is_null() ? nullptr : country_code_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->country_code.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null country_code in GeoHint struct");

      decltype(Traits::iso_region(input)) in_iso_region = Traits::iso_region(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->iso_region)::BaseType> iso_region_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_iso_region,
        iso_region_fragment);

      fragment->iso_region.Set(
          iso_region_fragment.is_null() ? nullptr : iso_region_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->iso_region.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null iso_region in GeoHint struct");

      decltype(Traits::city_name(input)) in_city_name = Traits::city_name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->city_name)::BaseType> city_name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_city_name,
        city_name_fragment);

      fragment->city_name.Set(
          city_name_fragment.is_null() ? nullptr : city_name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->city_name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null city_name in GeoHint struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ip_protection::mojom::BlindSignedAuthTokenDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ip_protection::mojom::BlindSignedAuthTokenDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ip_protection::mojom::internal::BlindSignedAuthToken_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::token(input)) in_token = Traits::token(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->token)::BaseType> token_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_token,
        token_fragment);

      fragment->token.Set(
          token_fragment.is_null() ? nullptr : token_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->token.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null token in BlindSignedAuthToken struct");

      decltype(Traits::expiration(input)) in_expiration = Traits::expiration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->expiration)::BaseType> expiration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeDataView, send_validation>(
        in_expiration,
        expiration_fragment);

      fragment->expiration.Set(
          expiration_fragment.is_null() ? nullptr : expiration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->expiration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiration in BlindSignedAuthToken struct");

      decltype(Traits::geo_hint(input)) in_geo_hint = Traits::geo_hint(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->geo_hint)::BaseType> geo_hint_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::ip_protection::mojom::GeoHintDataView, send_validation>(
        in_geo_hint,
        geo_hint_fragment);

      fragment->geo_hint.Set(
          geo_hint_fragment.is_null() ? nullptr : geo_hint_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->geo_hint.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null geo_hint in BlindSignedAuthToken struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_SEND_VALIDATION_H_