// components/ip_protection/mojom/data_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/ip_protection/mojom/data_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"


namespace ip_protection::mojom {
class GeoHintDataView;

class BlindSignedAuthTokenDataView;



}  // ip_protection::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ip_protection::mojom::GeoHintDataView> {
  using Data = ::ip_protection::mojom::internal::GeoHint_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::ip_protection::mojom::BlindSignedAuthTokenDataView> {
  using Data = ::ip_protection::mojom::internal::BlindSignedAuthToken_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ip_protection::mojom {


enum class ProxyLayer : int32_t {
  
  kProxyA = 0,
  
  kProxyB = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, ProxyLayer value);
inline bool IsKnownEnumValue(ProxyLayer value) {
  return internal::ProxyLayer_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class GeoHintDataView {
 public:
  GeoHintDataView() = default;

  GeoHintDataView(
      internal::GeoHint_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCountryCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCountryCode(UserType* output) {
    
    auto* pointer = data_->country_code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIsoRegionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIsoRegion(UserType* output) {
    
    auto* pointer = data_->iso_region.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCityNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCityName(UserType* output) {
    
    auto* pointer = data_->city_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::GeoHint_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class BlindSignedAuthTokenDataView {
 public:
  BlindSignedAuthTokenDataView() = default;

  BlindSignedAuthTokenDataView(
      internal::BlindSignedAuthToken_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadToken(UserType* output) {
    
    auto* pointer = data_->token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetExpirationDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExpiration(UserType* output) {
    
    auto* pointer = data_->expiration.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
  inline void GetGeoHintDataView(
      GeoHintDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadGeoHint(UserType* output) {
    
    auto* pointer = data_->geo_hint.Get();
    return mojo::internal::Deserialize<::ip_protection::mojom::GeoHintDataView>(
        pointer, output, message_);
  }
 private:
  internal::BlindSignedAuthToken_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ip_protection::mojom

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_DATA_TYPES_MOJOM_DATA_VIEW_H_