// components/ip_protection/mojom/core.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/ip_protection/mojom/core.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('ipProtection.mojom');
  var core_test$ =
      mojo.internal.exposeNamespace('ipProtection.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/ip_protection/mojom/core_test.mojom', 'core_test.mojom.js');
  }
  var data_types$ =
      mojo.internal.exposeNamespace('ipProtection.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/ip_protection/mojom/data_types.mojom', 'data_types.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../mojo/public/mojom/base/time.mojom.js');
  }
  var network_param$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/network_param.mojom', '../../../services/network/public/mojom/network_param.mojom.js');
  }



  function CoreControl_AuthTokensMayBeAvailable_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControl_AuthTokensMayBeAvailable_Params.prototype.initDefaults_ = function() {
  };
  CoreControl_AuthTokensMayBeAvailable_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControl_AuthTokensMayBeAvailable_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControl_AuthTokensMayBeAvailable_Params.encodedSize = codec.kStructHeaderSize + 0;

  CoreControl_AuthTokensMayBeAvailable_Params.decode = function(decoder) {
    var packed;
    var val = new CoreControl_AuthTokensMayBeAvailable_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CoreControl_AuthTokensMayBeAvailable_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControl_AuthTokensMayBeAvailable_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CoreControl_SetIpProtectionEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControl_SetIpProtectionEnabled_Params.prototype.initDefaults_ = function() {
    this.value = false;
  };
  CoreControl_SetIpProtectionEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControl_SetIpProtectionEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  CoreControl_SetIpProtectionEnabled_Params.encodedSize = codec.kStructHeaderSize + 8;

  CoreControl_SetIpProtectionEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new CoreControl_SetIpProtectionEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.value = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CoreControl_SetIpProtectionEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControl_SetIpProtectionEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.value & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CoreControl_BindTestInterfaceForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreControl_BindTestInterfaceForTesting_Params.prototype.initDefaults_ = function() {
    this.receiver = new bindings.InterfaceRequest();
  };
  CoreControl_BindTestInterfaceForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreControl_BindTestInterfaceForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreControl_BindTestInterfaceForTesting_Params.receiver
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreControl_BindTestInterfaceForTesting_Params.encodedSize = codec.kStructHeaderSize + 8;

  CoreControl_BindTestInterfaceForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new CoreControl_BindTestInterfaceForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.receiver =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CoreControl_BindTestInterfaceForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreControl_BindTestInterfaceForTesting_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.receiver);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CoreHost_TryGetAuthTokens_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreHost_TryGetAuthTokens_Params.prototype.initDefaults_ = function() {
    this.batchSize = 0;
    this.proxyLayer = 0;
  };
  CoreHost_TryGetAuthTokens_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreHost_TryGetAuthTokens_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CoreHost_TryGetAuthTokens_Params.proxyLayer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, data_types$.ProxyLayer);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreHost_TryGetAuthTokens_Params.encodedSize = codec.kStructHeaderSize + 8;

  CoreHost_TryGetAuthTokens_Params.decode = function(decoder) {
    var packed;
    var val = new CoreHost_TryGetAuthTokens_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.batchSize =
        decoder.decodeStruct(codec.Uint32);
    val.proxyLayer =
        decoder.decodeStruct(new codec.Enum(data_types$.ProxyLayer));
    return val;
  };

  CoreHost_TryGetAuthTokens_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreHost_TryGetAuthTokens_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.batchSize);
    encoder.encodeStruct(codec.Int32, val.proxyLayer);
  };
  function CoreHost_TryGetAuthTokens_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreHost_TryGetAuthTokens_ResponseParams.prototype.initDefaults_ = function() {
    this.bsaTokens = null;
    this.tryAgainAfter = null;
  };
  CoreHost_TryGetAuthTokens_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreHost_TryGetAuthTokens_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_TryGetAuthTokens_ResponseParams.bsaTokens
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(data_types$.BlindSignedAuthToken), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_TryGetAuthTokens_ResponseParams.tryAgainAfter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreHost_TryGetAuthTokens_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CoreHost_TryGetAuthTokens_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CoreHost_TryGetAuthTokens_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.bsaTokens =
        decoder.decodeArrayPointer(new codec.PointerTo(data_types$.BlindSignedAuthToken));
    val.tryAgainAfter =
        decoder.decodeStructPointer(time$.Time);
    return val;
  };

  CoreHost_TryGetAuthTokens_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreHost_TryGetAuthTokens_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(data_types$.BlindSignedAuthToken), val.bsaTokens);
    encoder.encodeStructPointer(time$.Time, val.tryAgainAfter);
  };
  function CoreHost_GetProxyConfig_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreHost_GetProxyConfig_Params.prototype.initDefaults_ = function() {
  };
  CoreHost_GetProxyConfig_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreHost_GetProxyConfig_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreHost_GetProxyConfig_Params.encodedSize = codec.kStructHeaderSize + 0;

  CoreHost_GetProxyConfig_Params.decode = function(decoder) {
    var packed;
    var val = new CoreHost_GetProxyConfig_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CoreHost_GetProxyConfig_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreHost_GetProxyConfig_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CoreHost_GetProxyConfig_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreHost_GetProxyConfig_ResponseParams.prototype.initDefaults_ = function() {
    this.proxyList = null;
    this.geoHint = null;
  };
  CoreHost_GetProxyConfig_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreHost_GetProxyConfig_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_GetProxyConfig_ResponseParams.proxyList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(network_param$.ProxyChain), true, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_GetProxyConfig_ResponseParams.geoHint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, data_types$.GeoHint, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreHost_GetProxyConfig_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CoreHost_GetProxyConfig_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CoreHost_GetProxyConfig_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxyList =
        decoder.decodeArrayPointer(new codec.PointerTo(network_param$.ProxyChain));
    val.geoHint =
        decoder.decodeStructPointer(data_types$.GeoHint);
    return val;
  };

  CoreHost_GetProxyConfig_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreHost_GetProxyConfig_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(network_param$.ProxyChain), val.proxyList);
    encoder.encodeStructPointer(data_types$.GeoHint, val.geoHint);
  };
  function CoreHost_TryGetProbabilisticRevealTokens_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreHost_TryGetProbabilisticRevealTokens_Params.prototype.initDefaults_ = function() {
  };
  CoreHost_TryGetProbabilisticRevealTokens_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreHost_TryGetProbabilisticRevealTokens_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreHost_TryGetProbabilisticRevealTokens_Params.encodedSize = codec.kStructHeaderSize + 0;

  CoreHost_TryGetProbabilisticRevealTokens_Params.decode = function(decoder) {
    var packed;
    var val = new CoreHost_TryGetProbabilisticRevealTokens_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  CoreHost_TryGetProbabilisticRevealTokens_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreHost_TryGetProbabilisticRevealTokens_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function CoreHost_TryGetProbabilisticRevealTokens_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.prototype.initDefaults_ = function() {
    this.outcome = null;
    this.result = null;
  };
  CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.outcome
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, data_types$.TryGetProbabilisticRevealTokensOutcome, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.result
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, data_types$.TryGetProbabilisticRevealTokensResult, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.encodedSize = codec.kStructHeaderSize + 16;

  CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new CoreHost_TryGetProbabilisticRevealTokens_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.outcome =
        decoder.decodeStructPointer(data_types$.TryGetProbabilisticRevealTokensOutcome);
    val.result =
        decoder.decodeStructPointer(data_types$.TryGetProbabilisticRevealTokensResult);
    return val;
  };

  CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(data_types$.TryGetProbabilisticRevealTokensOutcome, val.outcome);
    encoder.encodeStructPointer(data_types$.TryGetProbabilisticRevealTokensResult, val.result);
  };
  function CoreHost_RecycleTokens_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CoreHost_RecycleTokens_Params.prototype.initDefaults_ = function() {
    this.proxyLayer = 0;
    this.tokens = null;
  };
  CoreHost_RecycleTokens_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CoreHost_RecycleTokens_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_RecycleTokens_Params.proxyLayer
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, data_types$.ProxyLayer);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CoreHost_RecycleTokens_Params.tokens
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(data_types$.BlindSignedAuthToken), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CoreHost_RecycleTokens_Params.encodedSize = codec.kStructHeaderSize + 16;

  CoreHost_RecycleTokens_Params.decode = function(decoder) {
    var packed;
    var val = new CoreHost_RecycleTokens_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.proxyLayer =
        decoder.decodeStruct(new codec.Enum(data_types$.ProxyLayer));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.tokens =
        decoder.decodeArrayPointer(new codec.PointerTo(data_types$.BlindSignedAuthToken));
    return val;
  };

  CoreHost_RecycleTokens_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CoreHost_RecycleTokens_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.proxyLayer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(data_types$.BlindSignedAuthToken), val.tokens);
  };
  var kCoreControl_AuthTokensMayBeAvailable_Name = 0;
  var kCoreControl_SetIpProtectionEnabled_Name = 1;
  var kCoreControl_BindTestInterfaceForTesting_Name = 2;

  function CoreControlPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CoreControl,
                                                   handleOrPtrInfo);
  }

  function CoreControlAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CoreControl, associatedInterfacePtrInfo);
  }

  CoreControlAssociatedPtr.prototype =
      Object.create(CoreControlPtr.prototype);
  CoreControlAssociatedPtr.prototype.constructor =
      CoreControlAssociatedPtr;

  function CoreControlProxy(receiver) {
    this.receiver_ = receiver;
  }
  CoreControlPtr.prototype.authTokensMayBeAvailable = function() {
    return CoreControlProxy.prototype.authTokensMayBeAvailable
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreControlProxy.prototype.authTokensMayBeAvailable = function() {
    var params_ = new CoreControl_AuthTokensMayBeAvailable_Params();
    var builder = new codec.MessageV0Builder(
        kCoreControl_AuthTokensMayBeAvailable_Name,
        codec.align(CoreControl_AuthTokensMayBeAvailable_Params.encodedSize));
    builder.encodeStruct(CoreControl_AuthTokensMayBeAvailable_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CoreControlPtr.prototype.setIpProtectionEnabled = function() {
    return CoreControlProxy.prototype.setIpProtectionEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreControlProxy.prototype.setIpProtectionEnabled = function(value) {
    var params_ = new CoreControl_SetIpProtectionEnabled_Params();
    params_.value = value;
    var builder = new codec.MessageV0Builder(
        kCoreControl_SetIpProtectionEnabled_Name,
        codec.align(CoreControl_SetIpProtectionEnabled_Params.encodedSize));
    builder.encodeStruct(CoreControl_SetIpProtectionEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  CoreControlPtr.prototype.bindTestInterfaceForTesting = function() {
    return CoreControlProxy.prototype.bindTestInterfaceForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreControlProxy.prototype.bindTestInterfaceForTesting = function(receiver) {
    var params_ = new CoreControl_BindTestInterfaceForTesting_Params();
    params_.receiver = receiver;
    var builder = new codec.MessageV0Builder(
        kCoreControl_BindTestInterfaceForTesting_Name,
        codec.align(CoreControl_BindTestInterfaceForTesting_Params.encodedSize));
    builder.encodeStruct(CoreControl_BindTestInterfaceForTesting_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CoreControlStub(delegate) {
    this.delegate_ = delegate;
  }
  CoreControlStub.prototype.authTokensMayBeAvailable = function() {
    return this.delegate_ && this.delegate_.authTokensMayBeAvailable && this.delegate_.authTokensMayBeAvailable();
  }
  CoreControlStub.prototype.setIpProtectionEnabled = function(value) {
    return this.delegate_ && this.delegate_.setIpProtectionEnabled && this.delegate_.setIpProtectionEnabled(value);
  }
  CoreControlStub.prototype.bindTestInterfaceForTesting = function(receiver) {
    return this.delegate_ && this.delegate_.bindTestInterfaceForTesting && this.delegate_.bindTestInterfaceForTesting(receiver);
  }

  CoreControlStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCoreControl_AuthTokensMayBeAvailable_Name:
      var params = reader.decodeStruct(CoreControl_AuthTokensMayBeAvailable_Params);
      this.authTokensMayBeAvailable();
      return true;
    case kCoreControl_SetIpProtectionEnabled_Name:
      var params = reader.decodeStruct(CoreControl_SetIpProtectionEnabled_Params);
      this.setIpProtectionEnabled(params.value);
      return true;
    case kCoreControl_BindTestInterfaceForTesting_Name:
      var params = reader.decodeStruct(CoreControl_BindTestInterfaceForTesting_Params);
      this.bindTestInterfaceForTesting(params.receiver);
      return true;
    default:
      return false;
    }
  };

  CoreControlStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateCoreControlRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCoreControl_AuthTokensMayBeAvailable_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CoreControl_AuthTokensMayBeAvailable_Params;
      break;
      case kCoreControl_SetIpProtectionEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CoreControl_SetIpProtectionEnabled_Params;
      break;
      case kCoreControl_BindTestInterfaceForTesting_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CoreControl_BindTestInterfaceForTesting_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCoreControlResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var CoreControl = {
    name: 'ip_protection.mojom.CoreControl',
    kVersion: 0,
    ptrClass: CoreControlPtr,
    proxyClass: CoreControlProxy,
    stubClass: CoreControlStub,
    validateRequest: validateCoreControlRequest,
    validateResponse: null,
  };
  CoreControlStub.prototype.validator = validateCoreControlRequest;
  CoreControlProxy.prototype.validator = null;
  var kCoreHost_TryGetAuthTokens_Name = 0;
  var kCoreHost_GetProxyConfig_Name = 1;
  var kCoreHost_TryGetProbabilisticRevealTokens_Name = 2;
  var kCoreHost_RecycleTokens_Name = 3;

  function CoreHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(CoreHost,
                                                   handleOrPtrInfo);
  }

  function CoreHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        CoreHost, associatedInterfacePtrInfo);
  }

  CoreHostAssociatedPtr.prototype =
      Object.create(CoreHostPtr.prototype);
  CoreHostAssociatedPtr.prototype.constructor =
      CoreHostAssociatedPtr;

  function CoreHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  CoreHostPtr.prototype.tryGetAuthTokens = function() {
    return CoreHostProxy.prototype.tryGetAuthTokens
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreHostProxy.prototype.tryGetAuthTokens = function(batchSize, proxyLayer) {
    var params_ = new CoreHost_TryGetAuthTokens_Params();
    params_.batchSize = batchSize;
    params_.proxyLayer = proxyLayer;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCoreHost_TryGetAuthTokens_Name,
          codec.align(CoreHost_TryGetAuthTokens_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CoreHost_TryGetAuthTokens_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CoreHost_TryGetAuthTokens_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CoreHostPtr.prototype.getProxyConfig = function() {
    return CoreHostProxy.prototype.getProxyConfig
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreHostProxy.prototype.getProxyConfig = function() {
    var params_ = new CoreHost_GetProxyConfig_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCoreHost_GetProxyConfig_Name,
          codec.align(CoreHost_GetProxyConfig_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CoreHost_GetProxyConfig_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CoreHost_GetProxyConfig_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CoreHostPtr.prototype.tryGetProbabilisticRevealTokens = function() {
    return CoreHostProxy.prototype.tryGetProbabilisticRevealTokens
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreHostProxy.prototype.tryGetProbabilisticRevealTokens = function() {
    var params_ = new CoreHost_TryGetProbabilisticRevealTokens_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kCoreHost_TryGetProbabilisticRevealTokens_Name,
          codec.align(CoreHost_TryGetProbabilisticRevealTokens_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(CoreHost_TryGetProbabilisticRevealTokens_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(CoreHost_TryGetProbabilisticRevealTokens_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  CoreHostPtr.prototype.recycleTokens = function() {
    return CoreHostProxy.prototype.recycleTokens
        .apply(this.ptr.getProxy(), arguments);
  };

  CoreHostProxy.prototype.recycleTokens = function(proxyLayer, tokens) {
    var params_ = new CoreHost_RecycleTokens_Params();
    params_.proxyLayer = proxyLayer;
    params_.tokens = tokens;
    var builder = new codec.MessageV0Builder(
        kCoreHost_RecycleTokens_Name,
        codec.align(CoreHost_RecycleTokens_Params.encodedSize));
    builder.encodeStruct(CoreHost_RecycleTokens_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function CoreHostStub(delegate) {
    this.delegate_ = delegate;
  }
  CoreHostStub.prototype.tryGetAuthTokens = function(batchSize, proxyLayer) {
    return this.delegate_ && this.delegate_.tryGetAuthTokens && this.delegate_.tryGetAuthTokens(batchSize, proxyLayer);
  }
  CoreHostStub.prototype.getProxyConfig = function() {
    return this.delegate_ && this.delegate_.getProxyConfig && this.delegate_.getProxyConfig();
  }
  CoreHostStub.prototype.tryGetProbabilisticRevealTokens = function() {
    return this.delegate_ && this.delegate_.tryGetProbabilisticRevealTokens && this.delegate_.tryGetProbabilisticRevealTokens();
  }
  CoreHostStub.prototype.recycleTokens = function(proxyLayer, tokens) {
    return this.delegate_ && this.delegate_.recycleTokens && this.delegate_.recycleTokens(proxyLayer, tokens);
  }

  CoreHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCoreHost_RecycleTokens_Name:
      var params = reader.decodeStruct(CoreHost_RecycleTokens_Params);
      this.recycleTokens(params.proxyLayer, params.tokens);
      return true;
    default:
      return false;
    }
  };

  CoreHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kCoreHost_TryGetAuthTokens_Name:
      var params = reader.decodeStruct(CoreHost_TryGetAuthTokens_Params);
      this.tryGetAuthTokens(params.batchSize, params.proxyLayer).then(function(response) {
        var responseParams =
            new CoreHost_TryGetAuthTokens_ResponseParams();
        responseParams.bsaTokens = response.bsaTokens;
        responseParams.tryAgainAfter = response.tryAgainAfter;
        var builder = new codec.MessageV1Builder(
            kCoreHost_TryGetAuthTokens_Name,
            codec.align(CoreHost_TryGetAuthTokens_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CoreHost_TryGetAuthTokens_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCoreHost_GetProxyConfig_Name:
      var params = reader.decodeStruct(CoreHost_GetProxyConfig_Params);
      this.getProxyConfig().then(function(response) {
        var responseParams =
            new CoreHost_GetProxyConfig_ResponseParams();
        responseParams.proxyList = response.proxyList;
        responseParams.geoHint = response.geoHint;
        var builder = new codec.MessageV1Builder(
            kCoreHost_GetProxyConfig_Name,
            codec.align(CoreHost_GetProxyConfig_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CoreHost_GetProxyConfig_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kCoreHost_TryGetProbabilisticRevealTokens_Name:
      var params = reader.decodeStruct(CoreHost_TryGetProbabilisticRevealTokens_Params);
      this.tryGetProbabilisticRevealTokens().then(function(response) {
        var responseParams =
            new CoreHost_TryGetProbabilisticRevealTokens_ResponseParams();
        responseParams.outcome = response.outcome;
        responseParams.result = response.result;
        var builder = new codec.MessageV1Builder(
            kCoreHost_TryGetProbabilisticRevealTokens_Name,
            codec.align(CoreHost_TryGetProbabilisticRevealTokens_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(CoreHost_TryGetProbabilisticRevealTokens_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateCoreHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kCoreHost_TryGetAuthTokens_Name:
        if (message.expectsResponse())
          paramsClass = CoreHost_TryGetAuthTokens_Params;
      break;
      case kCoreHost_GetProxyConfig_Name:
        if (message.expectsResponse())
          paramsClass = CoreHost_GetProxyConfig_Params;
      break;
      case kCoreHost_TryGetProbabilisticRevealTokens_Name:
        if (message.expectsResponse())
          paramsClass = CoreHost_TryGetProbabilisticRevealTokens_Params;
      break;
      case kCoreHost_RecycleTokens_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = CoreHost_RecycleTokens_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateCoreHostResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kCoreHost_TryGetAuthTokens_Name:
        if (message.isResponse())
          paramsClass = CoreHost_TryGetAuthTokens_ResponseParams;
        break;
      case kCoreHost_GetProxyConfig_Name:
        if (message.isResponse())
          paramsClass = CoreHost_GetProxyConfig_ResponseParams;
        break;
      case kCoreHost_TryGetProbabilisticRevealTokens_Name:
        if (message.isResponse())
          paramsClass = CoreHost_TryGetProbabilisticRevealTokens_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var CoreHost = {
    name: 'ip_protection.mojom.CoreHost',
    kVersion: 0,
    ptrClass: CoreHostPtr,
    proxyClass: CoreHostProxy,
    stubClass: CoreHostStub,
    validateRequest: validateCoreHostRequest,
    validateResponse: validateCoreHostResponse,
  };
  CoreHostStub.prototype.validator = validateCoreHostRequest;
  CoreHostProxy.prototype.validator = validateCoreHostResponse;
  exports.CoreControl = CoreControl;
  exports.CoreControlPtr = CoreControlPtr;
  exports.CoreControlAssociatedPtr = CoreControlAssociatedPtr;
  exports.CoreHost = CoreHost;
  exports.CoreHostPtr = CoreHostPtr;
  exports.CoreHostAssociatedPtr = CoreHostAssociatedPtr;
})();