// components/ip_protection/mojom/core.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_IP_PROTECTION_MOJOM_CORE_MOJOM_H_
#define COMPONENTS_IP_PROTECTION_MOJOM_CORE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/ip_protection/mojom/core.mojom-features.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/core.mojom-shared.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/core.mojom-forward.h"  // IWYU pragma: export
#include "components/ip_protection/mojom/core_test.mojom-forward.h"
#include "components/ip_protection/mojom/data_types.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace ip_protection::mojom {

class CoreControlProxy;

template <typename ImplRefTraits>
class CoreControlStub;

class CoreControlRequestValidator;


class CoreControl
    : public CoreControlInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ip_protection.mojom.CoreControl";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CoreControlInterfaceBase;
  using Proxy_ = CoreControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = CoreControlStub<ImplRefTraits>;

  using RequestValidator_ = CoreControlRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAuthTokensMayBeAvailableMinVersion = 0,
    kSetIpProtectionEnabledMinVersion = 0,
    kBindTestInterfaceForTestingMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AuthTokensMayBeAvailable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIpProtectionEnabled_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindTestInterfaceForTesting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CoreControl() = default;

  virtual void AuthTokensMayBeAvailable() = 0;

  virtual void SetIpProtectionEnabled(bool value) = 0;

  virtual void BindTestInterfaceForTesting(::mojo::PendingReceiver<::ip_protection::mojom::CoreControlTest> receiver) = 0;
};

class CoreHostProxy;

template <typename ImplRefTraits>
class CoreHostStub;

class CoreHostRequestValidator;
class CoreHostResponseValidator;


class CoreHost
    : public CoreHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "ip_protection.mojom.CoreHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = CoreHostInterfaceBase;
  using Proxy_ = CoreHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = CoreHostStub<ImplRefTraits>;

  using RequestValidator_ = CoreHostRequestValidator;
  using ResponseValidator_ = CoreHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kTryGetAuthTokensMinVersion = 0,
    kGetProxyConfigMinVersion = 0,
    kRecycleTokensMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct TryGetAuthTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetProxyConfig_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecycleTokens_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~CoreHost() = default;

  using TryGetAuthTokensCallback = base::OnceCallback<void(std::optional<std::vector<::ip_protection::BlindSignedAuthToken>>, std::optional<::base::Time>)>;
  using TryGetAuthTokensMojoCallback = base::OnceCallback<void(std::optional<std::vector<::ip_protection::BlindSignedAuthToken>>, std::optional<::base::Time>)>;

  virtual void TryGetAuthTokens(uint32_t batch_size, ::ip_protection::ProxyLayer proxy_layer, TryGetAuthTokensCallback callback) = 0;

  using GetProxyConfigCallback = base::OnceCallback<void(const std::optional<std::vector<::net::ProxyChain>>&, const std::optional<::ip_protection::GeoHint>&)>;
  using GetProxyConfigMojoCallback = base::OnceCallback<void(const std::optional<std::vector<::net::ProxyChain>>&, const std::optional<::ip_protection::GeoHint>&)>;

  virtual void GetProxyConfig(GetProxyConfigCallback callback) = 0;

  virtual void RecycleTokens(::ip_protection::ProxyLayer proxy_layer, std::vector<::ip_protection::BlindSignedAuthToken> tokens) = 0;
};



class  CoreControlProxy
    : public CoreControl {
 public:
  using InterfaceType = CoreControl;

  explicit CoreControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AuthTokensMayBeAvailable() final;
  
  void SetIpProtectionEnabled(bool value) final;
  
  void BindTestInterfaceForTesting(::mojo::PendingReceiver<::ip_protection::mojom::CoreControlTest> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  CoreHostProxy
    : public CoreHost {
 public:
  using InterfaceType = CoreHost;

  explicit CoreHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void TryGetAuthTokens(uint32_t batch_size, ::ip_protection::ProxyLayer proxy_layer, TryGetAuthTokensCallback callback) final;
  
  void GetProxyConfig(GetProxyConfigCallback callback) final;
  
  void RecycleTokens(::ip_protection::ProxyLayer proxy_layer, std::vector<::ip_protection::BlindSignedAuthToken> tokens) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CoreControlStubDispatch {
 public:
  static bool Accept(CoreControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CoreControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CoreControl>>
class CoreControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CoreControlStub() = default;
  ~CoreControlStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CoreControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CoreControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CoreHostStubDispatch {
 public:
  static bool Accept(CoreHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CoreHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CoreHost>>
class CoreHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CoreHostStub() = default;
  ~CoreHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CoreHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CoreHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CoreControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CoreHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CoreHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // ip_protection::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_IP_PROTECTION_MOJOM_CORE_MOJOM_H_