// components/ip_protection/mojom/core.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('ipProtection.mojom.ProxyLayer');
goog.require('ipProtection.mojom.CoreControlTest');
goog.require('ipProtection.mojom.BlindSignedAuthToken');
goog.require('ipProtection.mojom.GeoHint');
goog.require('network.mojom.ProxyChain');
goog.require('mojoBase.mojom.Time');
goog.require('ipProtection.mojom.TryGetProbabilisticRevealTokensOutcome');
goog.require('ipProtection.mojom.TryGetProbabilisticRevealTokensResult');






goog.provide('ipProtection.mojom.CoreControl');
goog.provide('ipProtection.mojom.CoreControlReceiver');
goog.provide('ipProtection.mojom.CoreControlCallbackRouter');
goog.provide('ipProtection.mojom.CoreControlInterface');
goog.provide('ipProtection.mojom.CoreControlRemote');
goog.provide('ipProtection.mojom.CoreControlPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ipProtection.mojom.CoreControlPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ipProtection.mojom.CoreControl.$interfaceName,
        scope);
  }
};

/** @interface */
ipProtection.mojom.CoreControlInterface = class {
  
  /**
   */

  authTokensMayBeAvailable() {}
  
  /**
   * @param { !boolean } value
   */

  setIpProtectionEnabled(value) {}
  
  /**
   * @param { !ipProtection.mojom.CoreControlTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(receiver) {}
};

/**
 * @export
 * @implements { ipProtection.mojom.CoreControlInterface }
 */
ipProtection.mojom.CoreControlRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ipProtection.mojom.CoreControlPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ipProtection.mojom.CoreControlPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ipProtection.mojom.CoreControlPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  authTokensMayBeAvailable() {
    this.proxy.sendMessage(
        0,
        ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  setIpProtectionEnabled(
      value) {
    this.proxy.sendMessage(
        1,
        ipProtection.mojom.CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !ipProtection.mojom.CoreControlTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(
      receiver) {
    this.proxy.sendMessage(
        2,
        ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CoreControl
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ipProtection.mojom.CoreControlReceiver = class {
  /**
   * @param {!ipProtection.mojom.CoreControlInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ipProtection.mojom.CoreControlRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ipProtection.mojom.CoreControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ipProtection.mojom.CoreControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
        null,
        impl.authTokensMayBeAvailable.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ipProtection.mojom.CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
        null,
        impl.setIpProtectionEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        impl.bindTestInterfaceForTesting.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ipProtection.mojom.CoreControl = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ip_protection.mojom.CoreControl";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ipProtection.mojom.CoreControlRemote}
   * @export
   */
  static getRemote() {
    let remote = new ipProtection.mojom.CoreControlRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CoreControl
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ipProtection.mojom.CoreControlCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ipProtection.mojom.CoreControlRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ipProtection.mojom.CoreControlRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.authTokensMayBeAvailable =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
        null,
        this.authTokensMayBeAvailable.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIpProtectionEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ipProtection.mojom.CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
        null,
        this.setIpProtectionEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindTestInterfaceForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        this.bindTestInterfaceForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ipProtection.mojom.CoreHost');
goog.provide('ipProtection.mojom.CoreHostReceiver');
goog.provide('ipProtection.mojom.CoreHostCallbackRouter');
goog.provide('ipProtection.mojom.CoreHostInterface');
goog.provide('ipProtection.mojom.CoreHostRemote');
goog.provide('ipProtection.mojom.CoreHostPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
ipProtection.mojom.CoreHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        ipProtection.mojom.CoreHost.$interfaceName,
        scope);
  }
};

/** @interface */
ipProtection.mojom.CoreHostInterface = class {
  
  /**
   * @param { !number } batchSize
   * @param { !ipProtection.mojom.ProxyLayer } proxyLayer
   * @return {!Promise<{
        bsaTokens: ?Array<!ipProtection.mojom.BlindSignedAuthToken>,
        tryAgainAfter: ?mojoBase.mojom.Time,
   *  }>}
   */

  tryGetAuthTokens(batchSize, proxyLayer) {}
  
  /**
   * @return {!Promise<{
        proxyList: ?Array<!network.mojom.ProxyChain>,
        geoHint: ?ipProtection.mojom.GeoHint,
   *  }>}
   */

  getProxyConfig() {}
  
  /**
   * @return {!Promise<{
        outcome: ?ipProtection.mojom.TryGetProbabilisticRevealTokensOutcome,
        result: !ipProtection.mojom.TryGetProbabilisticRevealTokensResult,
   *  }>}
   */

  tryGetProbabilisticRevealTokens() {}
  
  /**
   * @param { !ipProtection.mojom.ProxyLayer } proxyLayer
   * @param { !Array<!ipProtection.mojom.BlindSignedAuthToken> } tokens
   */

  recycleTokens(proxyLayer, tokens) {}
};

/**
 * @export
 * @implements { ipProtection.mojom.CoreHostInterface }
 */
ipProtection.mojom.CoreHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ipProtection.mojom.CoreHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ipProtection.mojom.CoreHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ipProtection.mojom.CoreHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } batchSize
   * @param { !ipProtection.mojom.ProxyLayer } proxyLayer
   * @return {!Promise<{
        bsaTokens: ?Array<!ipProtection.mojom.BlindSignedAuthToken>,
        tryAgainAfter: ?mojoBase.mojom.Time,
   *  }>}
   */

  tryGetAuthTokens(
      batchSize,
      proxyLayer) {
    return this.proxy.sendMessage(
        0,
        ipProtection.mojom.CoreHost_TryGetAuthTokens_ParamsSpec.$,
        ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
        [
          batchSize,
          proxyLayer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        proxyList: ?Array<!network.mojom.ProxyChain>,
        geoHint: ?ipProtection.mojom.GeoHint,
   *  }>}
   */

  getProxyConfig() {
    return this.proxy.sendMessage(
        1,
        ipProtection.mojom.CoreHost_GetProxyConfig_ParamsSpec.$,
        ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        outcome: ?ipProtection.mojom.TryGetProbabilisticRevealTokensOutcome,
        result: !ipProtection.mojom.TryGetProbabilisticRevealTokensResult,
   *  }>}
   */

  tryGetProbabilisticRevealTokens() {
    return this.proxy.sendMessage(
        2,
        ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
        ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !ipProtection.mojom.ProxyLayer } proxyLayer
   * @param { !Array<!ipProtection.mojom.BlindSignedAuthToken> } tokens
   */

  recycleTokens(
      proxyLayer,
      tokens) {
    this.proxy.sendMessage(
        3,
        ipProtection.mojom.CoreHost_RecycleTokens_ParamsSpec.$,
        null,
        [
          proxyLayer,
          tokens
        ],
        false);
  }
};

/**
 * An object which receives request messages for the CoreHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
ipProtection.mojom.CoreHostReceiver = class {
  /**
   * @param {!ipProtection.mojom.CoreHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ipProtection.mojom.CoreHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ipProtection.mojom.CoreHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ipProtection.mojom.CoreHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ipProtection.mojom.CoreHost_TryGetAuthTokens_ParamsSpec.$,
        ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
        impl.tryGetAuthTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ipProtection.mojom.CoreHost_GetProxyConfig_ParamsSpec.$,
        ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParamsSpec.$,
        impl.getProxyConfig.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
        ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
        impl.tryGetProbabilisticRevealTokens.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ipProtection.mojom.CoreHost_RecycleTokens_ParamsSpec.$,
        null,
        impl.recycleTokens.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
ipProtection.mojom.CoreHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ip_protection.mojom.CoreHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ipProtection.mojom.CoreHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new ipProtection.mojom.CoreHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the CoreHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
ipProtection.mojom.CoreHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ipProtection.mojom.CoreHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ipProtection.mojom.CoreHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.tryGetAuthTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ipProtection.mojom.CoreHost_TryGetAuthTokens_ParamsSpec.$,
        ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
        this.tryGetAuthTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getProxyConfig =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ipProtection.mojom.CoreHost_GetProxyConfig_ParamsSpec.$,
        ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParamsSpec.$,
        this.getProxyConfig.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.tryGetProbabilisticRevealTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
        ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
        this.tryGetProbabilisticRevealTokens.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.recycleTokens =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ipProtection.mojom.CoreHost_RecycleTokens_ParamsSpec.$,
        null,
        this.recycleTokens.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreControl_SetIpProtectionEnabled_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControl_SetIpProtectionEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreHost_TryGetAuthTokens_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreHost_TryGetAuthTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreHost_GetProxyConfig_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreHost_GetProxyConfig_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('ipProtection.mojom.CoreHost_RecycleTokens_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
ipProtection.mojom.CoreHost_RecycleTokens_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_ParamsSpec.$,
    'CoreControl_AuthTokensMayBeAvailable_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_Params');

/** @record */
ipProtection.mojom.CoreControl_AuthTokensMayBeAvailable_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControl_SetIpProtectionEnabled_ParamsSpec.$,
    'CoreControl_SetIpProtectionEnabled_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ipProtection.mojom.CoreControl_SetIpProtectionEnabled_Params');

/** @record */
ipProtection.mojom.CoreControl_SetIpProtectionEnabled_Params = class {
  constructor() {
    /** @export { !boolean } */
    this.value;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_ParamsSpec.$,
    'CoreControl_BindTestInterfaceForTesting_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ipProtection.mojom.CoreControlTestPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_Params');

/** @record */
ipProtection.mojom.CoreControl_BindTestInterfaceForTesting_Params = class {
  constructor() {
    /** @export { !ipProtection.mojom.CoreControlTestPendingReceiver } */
    this.receiver;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreHost_TryGetAuthTokens_ParamsSpec.$,
    'CoreHost_TryGetAuthTokens_Params',
    [
      mojo.internal.StructField(
        'batchSize', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'proxyLayer', 4,
        0,
        ipProtection.mojom.ProxyLayerSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('ipProtection.mojom.CoreHost_TryGetAuthTokens_Params');

/** @record */
ipProtection.mojom.CoreHost_TryGetAuthTokens_Params = class {
  constructor() {
    /** @export { !number } */
    this.batchSize;
    /** @export { !ipProtection.mojom.ProxyLayer } */
    this.proxyLayer;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParamsSpec.$,
    'CoreHost_TryGetAuthTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'bsaTokens', 0,
        0,
        mojo.internal.Array(ipProtection.mojom.BlindSignedAuthTokenSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tryAgainAfter', 8,
        0,
        mojoBase.mojom.TimeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParams');

/** @record */
ipProtection.mojom.CoreHost_TryGetAuthTokens_ResponseParams = class {
  constructor() {
    /** @export { (Array<!ipProtection.mojom.BlindSignedAuthToken>|undefined) } */
    this.bsaTokens;
    /** @export { (mojoBase.mojom.Time|undefined) } */
    this.tryAgainAfter;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreHost_GetProxyConfig_ParamsSpec.$,
    'CoreHost_GetProxyConfig_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ipProtection.mojom.CoreHost_GetProxyConfig_Params');

/** @record */
ipProtection.mojom.CoreHost_GetProxyConfig_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParamsSpec.$,
    'CoreHost_GetProxyConfig_ResponseParams',
    [
      mojo.internal.StructField(
        'proxyList', 0,
        0,
        mojo.internal.Array(network.mojom.ProxyChainSpec.$, false),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'geoHint', 8,
        0,
        ipProtection.mojom.GeoHintSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParams');

/** @record */
ipProtection.mojom.CoreHost_GetProxyConfig_ResponseParams = class {
  constructor() {
    /** @export { (Array<!network.mojom.ProxyChain>|undefined) } */
    this.proxyList;
    /** @export { (ipProtection.mojom.GeoHint|undefined) } */
    this.geoHint;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ParamsSpec.$,
    'CoreHost_TryGetProbabilisticRevealTokens_Params',
    [
    ],
    [[0, 8],]);



goog.provide('ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_Params');

/** @record */
ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParamsSpec.$,
    'CoreHost_TryGetProbabilisticRevealTokens_ResponseParams',
    [
      mojo.internal.StructField(
        'outcome', 0,
        0,
        ipProtection.mojom.TryGetProbabilisticRevealTokensOutcomeSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'result', 8,
        0,
        ipProtection.mojom.TryGetProbabilisticRevealTokensResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParams');

/** @record */
ipProtection.mojom.CoreHost_TryGetProbabilisticRevealTokens_ResponseParams = class {
  constructor() {
    /** @export { (ipProtection.mojom.TryGetProbabilisticRevealTokensOutcome|undefined) } */
    this.outcome;
    /** @export { !ipProtection.mojom.TryGetProbabilisticRevealTokensResult } */
    this.result;
  }
};



mojo.internal.Struct(
    ipProtection.mojom.CoreHost_RecycleTokens_ParamsSpec.$,
    'CoreHost_RecycleTokens_Params',
    [
      mojo.internal.StructField(
        'proxyLayer', 0,
        0,
        ipProtection.mojom.ProxyLayerSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'tokens', 8,
        0,
        mojo.internal.Array(ipProtection.mojom.BlindSignedAuthTokenSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('ipProtection.mojom.CoreHost_RecycleTokens_Params');

/** @record */
ipProtection.mojom.CoreHost_RecycleTokens_Params = class {
  constructor() {
    /** @export { !ipProtection.mojom.ProxyLayer } */
    this.proxyLayer;
    /** @export { !Array<!ipProtection.mojom.BlindSignedAuthToken> } */
    this.tokens;
  }
};

