// components/input/render_input_router.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_H_
#define COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/input/render_input_router.mojom-features.h"  // IWYU pragma: export
#include "components/input/render_input_router.mojom-shared.h"  // IWYU pragma: export
#include "components/input/render_input_router.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-forward.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "base/component_export.h"




namespace input::mojom {

class RenderInputRouterDelegateProxy;

template <typename ImplRefTraits>
class RenderInputRouterDelegateStub;

class RenderInputRouterDelegateRequestValidator;


class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegate
    : public RenderInputRouterDelegateInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "input.mojom.RenderInputRouterDelegate";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr bool kSupportsDirectReceiver = true;
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RenderInputRouterDelegateInterfaceBase;
  using Proxy_ = RenderInputRouterDelegateProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderInputRouterDelegateStub<ImplRefTraits>;

  using RequestValidator_ = RenderInputRouterDelegateRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStateOnTouchTransferMinVersion = 0,
    kForceEnableZoomStateChangedMinVersion = 0,
    kStopFlingingOnVizMinVersion = 0,
    kRestartInputEventAckTimeoutIfNecessaryMinVersion = 0,
    kNotifyVisibilityChangedMinVersion = 0,
    kResetGestureDetectionMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StateOnTouchTransfer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ForceEnableZoomStateChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopFlingingOnViz_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RestartInputEventAckTimeoutIfNecessary_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyVisibilityChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResetGestureDetection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RenderInputRouterDelegate() = default;

  virtual void StateOnTouchTransfer(TouchTransferStatePtr state) = 0;

  virtual void ForceEnableZoomStateChanged(bool force_enable_zoom, const ::viz::FrameSinkId& frame_sink_id) = 0;

  virtual void StopFlingingOnViz(const ::viz::FrameSinkId& frame_sink_id) = 0;

  virtual void RestartInputEventAckTimeoutIfNecessary(const ::viz::FrameSinkId& frame_sink_id) = 0;

  virtual void NotifyVisibilityChanged(const ::viz::FrameSinkId& frame_sink_id, bool is_hidden) = 0;

  virtual void ResetGestureDetection(const ::viz::FrameSinkId& root_widget_frame_sink_id) = 0;
};

class RenderInputRouterDelegateClientProxy;

template <typename ImplRefTraits>
class RenderInputRouterDelegateClientStub;

class RenderInputRouterDelegateClientRequestValidator;


class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegateClient
    : public RenderInputRouterDelegateClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "input.mojom.RenderInputRouterDelegateClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RenderInputRouterDelegateClientInterfaceBase;
  using Proxy_ = RenderInputRouterDelegateClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderInputRouterDelegateClientStub<ImplRefTraits>;

  using RequestValidator_ = RenderInputRouterDelegateClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyObserversOfInputEventMinVersion = 0,
    kNotifyObserversOfInputEventAcksMinVersion = 0,
    kOnInvalidInputEventSourceMinVersion = 0,
    kStateOnOverscrollTransferMinVersion = 0,
    kRendererInputResponsivenessChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyObserversOfInputEvent_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyObserversOfInputEventAcks_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnInvalidInputEventSource_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StateOnOverscrollTransfer_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RendererInputResponsivenessChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RenderInputRouterDelegateClient() = default;

  virtual void NotifyObserversOfInputEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool dispatched_to_renderer) = 0;

  virtual void NotifyObserversOfInputEventAcks(::blink::mojom::InputEventResultSource ack_source, ::blink::mojom::InputEventResultState ack_result, ::std::unique_ptr<::blink::WebCoalescedInputEvent> event) = 0;

  virtual void OnInvalidInputEventSource() = 0;

  virtual void StateOnOverscrollTransfer(::blink::mojom::DidOverscrollParamsPtr overscroll) = 0;

  virtual void RendererInputResponsivenessChanged(bool is_responsive, std::optional<::base::TimeTicks> ack_timeout_ts) = 0;
};



class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegateProxy
    : public RenderInputRouterDelegate {
 public:
  using InterfaceType = RenderInputRouterDelegate;

  explicit RenderInputRouterDelegateProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StateOnTouchTransfer(TouchTransferStatePtr state) final;
  
  void ForceEnableZoomStateChanged(bool force_enable_zoom, const ::viz::FrameSinkId& frame_sink_id) final;
  
  void StopFlingingOnViz(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void RestartInputEventAckTimeoutIfNecessary(const ::viz::FrameSinkId& frame_sink_id) final;
  
  void NotifyVisibilityChanged(const ::viz::FrameSinkId& frame_sink_id, bool is_hidden) final;
  
  void ResetGestureDetection(const ::viz::FrameSinkId& root_widget_frame_sink_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegateClientProxy
    : public RenderInputRouterDelegateClient {
 public:
  using InterfaceType = RenderInputRouterDelegateClient;

  explicit RenderInputRouterDelegateClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyObserversOfInputEvent(::std::unique_ptr<::blink::WebCoalescedInputEvent> event, bool dispatched_to_renderer) final;
  
  void NotifyObserversOfInputEventAcks(::blink::mojom::InputEventResultSource ack_source, ::blink::mojom::InputEventResultState ack_result, ::std::unique_ptr<::blink::WebCoalescedInputEvent> event) final;
  
  void OnInvalidInputEventSource() final;
  
  void StateOnOverscrollTransfer(::blink::mojom::DidOverscrollParamsPtr overscroll) final;
  
  void RendererInputResponsivenessChanged(bool is_responsive, std::optional<::base::TimeTicks> ack_timeout_ts) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegateStubDispatch {
 public:
  static bool Accept(RenderInputRouterDelegate* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderInputRouterDelegate* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderInputRouterDelegate>>
class RenderInputRouterDelegateStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderInputRouterDelegateStub() = default;
  ~RenderInputRouterDelegateStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderInputRouterDelegateStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderInputRouterDelegateStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegateClientStubDispatch {
 public:
  static bool Accept(RenderInputRouterDelegateClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderInputRouterDelegateClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderInputRouterDelegateClient>>
class RenderInputRouterDelegateClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderInputRouterDelegateClientStub() = default;
  ~RenderInputRouterDelegateClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderInputRouterDelegateClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderInputRouterDelegateClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegateRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterDelegateClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) RenderInputRouterConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RenderInputRouterConfig, T>::value>;
  using DataView = RenderInputRouterConfigDataView;
  using Data_ = internal::RenderInputRouterConfig_Data;

  template <typename... Args>
  static RenderInputRouterConfigPtr New(Args&&... args) {
    return RenderInputRouterConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RenderInputRouterConfigPtr From(const U& u) {
    return mojo::TypeConverter<RenderInputRouterConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RenderInputRouterConfig>::Convert(*this);
  }


  RenderInputRouterConfig();

  RenderInputRouterConfig(
      ::mojo::PendingRemote<::blink::mojom::RenderInputRouterClient> rir_client,
      const ::base::UnguessableToken& grouping_id,
      bool force_enable_zoom);

RenderInputRouterConfig(const RenderInputRouterConfig&) = delete;
RenderInputRouterConfig& operator=(const RenderInputRouterConfig&) = delete;

  ~RenderInputRouterConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RenderInputRouterConfigPtr>
  RenderInputRouterConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RenderInputRouterConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RenderInputRouterConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RenderInputRouterConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RenderInputRouterConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RenderInputRouterConfig_UnserializedMessageContext<
            UserType, RenderInputRouterConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RenderInputRouterConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RenderInputRouterConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RenderInputRouterConfig_UnserializedMessageContext<
            UserType, RenderInputRouterConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RenderInputRouterConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::mojo::PendingRemote<::blink::mojom::RenderInputRouterClient> rir_client;
  
  ::base::UnguessableToken grouping_id;
  
  bool force_enable_zoom;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RenderInputRouterConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RenderInputRouterConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RenderInputRouterConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RenderInputRouterConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) TouchTransferState {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TouchTransferState, T>::value>;
  using DataView = TouchTransferStateDataView;
  using Data_ = internal::TouchTransferState_Data;

  template <typename... Args>
  static TouchTransferStatePtr New(Args&&... args) {
    return TouchTransferStatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TouchTransferStatePtr From(const U& u) {
    return mojo::TypeConverter<TouchTransferStatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TouchTransferState>::Convert(*this);
  }


  TouchTransferState();

  TouchTransferState(
      ::base::TimeTicks down_time_ms,
      const ::viz::FrameSinkId& root_widget_frame_sink_id,
      float web_contents_y_offset_pix,
      float dip_scale,
      bool browser_would_have_handled);


  ~TouchTransferState();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TouchTransferStatePtr>
  TouchTransferStatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TouchTransferState::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TouchTransferState::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TouchTransferState::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchTransferState::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TouchTransferState::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TouchTransferState::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TouchTransferState_UnserializedMessageContext<
            UserType, TouchTransferState::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TouchTransferState::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TouchTransferState::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TouchTransferState_UnserializedMessageContext<
            UserType, TouchTransferState::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TouchTransferState::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks down_time_ms;
  
  ::viz::FrameSinkId root_widget_frame_sink_id;
  
  float web_contents_y_offset_pix;
  
  float dip_scale;
  
  bool browser_would_have_handled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TouchTransferState::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TouchTransferState::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TouchTransferState::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TouchTransferState::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RenderInputRouterConfigPtr RenderInputRouterConfig::Clone() const {
  return New(
      mojo::Clone(rir_client),
      mojo::Clone(grouping_id),
      mojo::Clone(force_enable_zoom)
  );
}

template <typename T, RenderInputRouterConfig::EnableIfSame<T>*>
bool RenderInputRouterConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rir_client, other_struct.rir_client))
    return false;
  if (!mojo::Equals(this->grouping_id, other_struct.grouping_id))
    return false;
  if (!mojo::Equals(this->force_enable_zoom, other_struct.force_enable_zoom))
    return false;
  return true;
}

template <typename T, RenderInputRouterConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.rir_client < rhs.rir_client)
    return true;
  if (rhs.rir_client < lhs.rir_client)
    return false;
  if (lhs.grouping_id < rhs.grouping_id)
    return true;
  if (rhs.grouping_id < lhs.grouping_id)
    return false;
  if (lhs.force_enable_zoom < rhs.force_enable_zoom)
    return true;
  if (rhs.force_enable_zoom < lhs.force_enable_zoom)
    return false;
  return false;
}
template <typename StructPtrType>
TouchTransferStatePtr TouchTransferState::Clone() const {
  return New(
      mojo::Clone(down_time_ms),
      mojo::Clone(root_widget_frame_sink_id),
      mojo::Clone(web_contents_y_offset_pix),
      mojo::Clone(dip_scale),
      mojo::Clone(browser_would_have_handled)
  );
}

template <typename T, TouchTransferState::EnableIfSame<T>*>
bool TouchTransferState::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->down_time_ms, other_struct.down_time_ms))
    return false;
  if (!mojo::Equals(this->root_widget_frame_sink_id, other_struct.root_widget_frame_sink_id))
    return false;
  if (!mojo::Equals(this->web_contents_y_offset_pix, other_struct.web_contents_y_offset_pix))
    return false;
  if (!mojo::Equals(this->dip_scale, other_struct.dip_scale))
    return false;
  if (!mojo::Equals(this->browser_would_have_handled, other_struct.browser_would_have_handled))
    return false;
  return true;
}

template <typename T, TouchTransferState::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.down_time_ms < rhs.down_time_ms)
    return true;
  if (rhs.down_time_ms < lhs.down_time_ms)
    return false;
  if (lhs.root_widget_frame_sink_id < rhs.root_widget_frame_sink_id)
    return true;
  if (rhs.root_widget_frame_sink_id < lhs.root_widget_frame_sink_id)
    return false;
  if (lhs.web_contents_y_offset_pix < rhs.web_contents_y_offset_pix)
    return true;
  if (rhs.web_contents_y_offset_pix < lhs.web_contents_y_offset_pix)
    return false;
  if (lhs.dip_scale < rhs.dip_scale)
    return true;
  if (rhs.dip_scale < lhs.dip_scale)
    return false;
  if (lhs.browser_would_have_handled < rhs.browser_would_have_handled)
    return true;
  if (rhs.browser_would_have_handled < lhs.browser_would_have_handled)
    return false;
  return false;
}


}  // input::mojom

namespace mojo {


template <>
struct COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) StructTraits<::input::mojom::RenderInputRouterConfig::DataView,
                                         ::input::mojom::RenderInputRouterConfigPtr> {
  static bool IsNull(const ::input::mojom::RenderInputRouterConfigPtr& input) { return !input; }
  static void SetToNull(::input::mojom::RenderInputRouterConfigPtr* output) { output->reset(); }

  static  decltype(::input::mojom::RenderInputRouterConfig::rir_client)& rir_client(
       ::input::mojom::RenderInputRouterConfigPtr& input) {
    return input->rir_client;
  }

  static const decltype(::input::mojom::RenderInputRouterConfig::grouping_id)& grouping_id(
      const ::input::mojom::RenderInputRouterConfigPtr& input) {
    return input->grouping_id;
  }

  static decltype(::input::mojom::RenderInputRouterConfig::force_enable_zoom) force_enable_zoom(
      const ::input::mojom::RenderInputRouterConfigPtr& input) {
    return input->force_enable_zoom;
  }

  static bool Read(::input::mojom::RenderInputRouterConfig::DataView input, ::input::mojom::RenderInputRouterConfigPtr* output);
};


template <>
struct COMPONENT_EXPORT(COMPONENTS_INPUT_MOJOM) StructTraits<::input::mojom::TouchTransferState::DataView,
                                         ::input::mojom::TouchTransferStatePtr> {
  static bool IsNull(const ::input::mojom::TouchTransferStatePtr& input) { return !input; }
  static void SetToNull(::input::mojom::TouchTransferStatePtr* output) { output->reset(); }

  static const decltype(::input::mojom::TouchTransferState::down_time_ms)& down_time_ms(
      const ::input::mojom::TouchTransferStatePtr& input) {
    return input->down_time_ms;
  }

  static const decltype(::input::mojom::TouchTransferState::root_widget_frame_sink_id)& root_widget_frame_sink_id(
      const ::input::mojom::TouchTransferStatePtr& input) {
    return input->root_widget_frame_sink_id;
  }

  static decltype(::input::mojom::TouchTransferState::web_contents_y_offset_pix) web_contents_y_offset_pix(
      const ::input::mojom::TouchTransferStatePtr& input) {
    return input->web_contents_y_offset_pix;
  }

  static decltype(::input::mojom::TouchTransferState::dip_scale) dip_scale(
      const ::input::mojom::TouchTransferStatePtr& input) {
    return input->dip_scale;
  }

  static decltype(::input::mojom::TouchTransferState::browser_would_have_handled) browser_would_have_handled(
      const ::input::mojom::TouchTransferStatePtr& input) {
    return input->browser_would_have_handled;
  }

  static bool Read(::input::mojom::TouchTransferState::DataView input, ::input::mojom::TouchTransferStatePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_H_