// components/input/render_input_router.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_SEND_VALIDATION_H_

#include "components/input/render_input_router.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/viz/public/mojom/compositing/frame_sink_id.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_event_result.mojom-shared.h"
#include "third_party/blink/public/mojom/input/input_handler.mojom-shared.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-shared.h"

#include "components/input/render_input_router.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::input::mojom::RenderInputRouterConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::input::mojom::RenderInputRouterConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::input::mojom::internal::RenderInputRouterConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::rir_client(input)) in_rir_client = Traits::rir_client(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::RenderInputRouterClientInterfaceBase>>(
        in_rir_client,
        &fragment->rir_client,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->rir_client)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid rir_client in RenderInputRouterConfig struct");

      decltype(Traits::grouping_id(input)) in_grouping_id = Traits::grouping_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->grouping_id)::BaseType> grouping_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_grouping_id,
        grouping_id_fragment);

      fragment->grouping_id.Set(
          grouping_id_fragment.is_null() ? nullptr : grouping_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->grouping_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null grouping_id in RenderInputRouterConfig struct");

      fragment->force_enable_zoom = Traits::force_enable_zoom(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::input::mojom::TouchTransferStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::input::mojom::TouchTransferStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::input::mojom::internal::TouchTransferState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::down_time_ms(input)) in_down_time_ms = Traits::down_time_ms(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->down_time_ms)::BaseType> down_time_ms_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_down_time_ms,
        down_time_ms_fragment);

      fragment->down_time_ms.Set(
          down_time_ms_fragment.is_null() ? nullptr : down_time_ms_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->down_time_ms.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null down_time_ms in TouchTransferState struct");

      decltype(Traits::root_widget_frame_sink_id(input)) in_root_widget_frame_sink_id = Traits::root_widget_frame_sink_id(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->root_widget_frame_sink_id)::BaseType> root_widget_frame_sink_id_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::viz::mojom::FrameSinkIdDataView, send_validation>(
        in_root_widget_frame_sink_id,
        root_widget_frame_sink_id_fragment);

      fragment->root_widget_frame_sink_id.Set(
          root_widget_frame_sink_id_fragment.is_null() ? nullptr : root_widget_frame_sink_id_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->root_widget_frame_sink_id.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_widget_frame_sink_id in TouchTransferState struct");

      fragment->web_contents_y_offset_pix = Traits::web_contents_y_offset_pix(input);

      fragment->dip_scale = Traits::dip_scale(input);

      fragment->browser_would_have_handled = Traits::browser_would_have_handled(input);
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_INPUT_RENDER_INPUT_ROUTER_MOJOM_SEND_VALIDATION_H_