// components/history_clusters/public/mojom/history_cluster_types.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_SHARED_H_
#define COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/history_clusters/public/mojom/history_cluster_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "components/history_clusters/public/mojom/history_cluster_types.mojom-data-view.h"




namespace std {

template <>
struct hash<::history_clusters::mojom::Annotation>
    : public mojo::internal::EnumHashImpl<::history_clusters::mojom::Annotation> {};

template <>
struct hash<::history_clusters::mojom::InteractionState>
    : public mojo::internal::EnumHashImpl<::history_clusters::mojom::InteractionState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::Annotation, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_clusters::mojom::Annotation, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_clusters::mojom::Annotation>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::InteractionState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::history_clusters::mojom::InteractionState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::history_clusters::mojom::InteractionState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::MatchPositionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history_clusters::mojom::MatchPositionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history_clusters::mojom::internal::MatchPosition_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->begin = Traits::begin(input);

    fragment->end = Traits::end(input);
  }

  static bool Deserialize(::history_clusters::mojom::internal::MatchPosition_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history_clusters::mojom::MatchPositionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::SearchQueryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history_clusters::mojom::SearchQueryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history_clusters::mojom::internal::SearchQuery_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::query(input)) in_query = Traits::query(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->query)::BaseType> query_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_query,
      query_fragment);

    fragment->query.Set(
        query_fragment.is_null() ? nullptr : query_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->query.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query in SearchQuery struct");

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in SearchQuery struct");
  }

  static bool Deserialize(::history_clusters::mojom::internal::SearchQuery_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history_clusters::mojom::SearchQueryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::RawVisitDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history_clusters::mojom::RawVisitDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history_clusters::mojom::internal::RawVisitData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url,
      url_fragment);

    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in RawVisitData struct");

    decltype(Traits::visit_time(input)) in_visit_time = Traits::visit_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visit_time)::BaseType> visit_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_visit_time,
      visit_time_fragment);

    fragment->visit_time.Set(
        visit_time_fragment.is_null() ? nullptr : visit_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visit_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visit_time in RawVisitData struct");
  }

  static bool Deserialize(::history_clusters::mojom::internal::RawVisitData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history_clusters::mojom::RawVisitDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::URLVisitDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history_clusters::mojom::URLVisitDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history_clusters::mojom::internal::URLVisit_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->visit_id = Traits::visit_id(input);

    decltype(Traits::normalized_url(input)) in_normalized_url = Traits::normalized_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->normalized_url)::BaseType> normalized_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_normalized_url,
      normalized_url_fragment);

    fragment->normalized_url.Set(
        normalized_url_fragment.is_null() ? nullptr : normalized_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->normalized_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null normalized_url in URLVisit struct");

    decltype(Traits::url_for_display(input)) in_url_for_display = Traits::url_for_display(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_for_display)::BaseType> url_for_display_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_url_for_display,
      url_for_display_fragment);

    fragment->url_for_display.Set(
        url_for_display_fragment.is_null() ? nullptr : url_for_display_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url_for_display.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_for_display in URLVisit struct");

    decltype(Traits::page_title(input)) in_page_title = Traits::page_title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_title)::BaseType> page_title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_page_title,
      page_title_fragment);

    fragment->page_title.Set(
        page_title_fragment.is_null() ? nullptr : page_title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_title in URLVisit struct");

    decltype(Traits::title_match_positions(input)) in_title_match_positions = Traits::title_match_positions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title_match_positions)::BaseType>
        title_match_positions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& title_match_positions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::MatchPositionDataView>>(
      in_title_match_positions,
      title_match_positions_fragment,
      &title_match_positions_validate_params);

    fragment->title_match_positions.Set(
        title_match_positions_fragment.is_null() ? nullptr : title_match_positions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title_match_positions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title_match_positions in URLVisit struct");

    decltype(Traits::url_for_display_match_positions(input)) in_url_for_display_match_positions = Traits::url_for_display_match_positions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url_for_display_match_positions)::BaseType>
        url_for_display_match_positions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& url_for_display_match_positions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::MatchPositionDataView>>(
      in_url_for_display_match_positions,
      url_for_display_match_positions_fragment,
      &url_for_display_match_positions_validate_params);

    fragment->url_for_display_match_positions.Set(
        url_for_display_match_positions_fragment.is_null() ? nullptr : url_for_display_match_positions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->url_for_display_match_positions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url_for_display_match_positions in URLVisit struct");

    decltype(Traits::raw_visit_data(input)) in_raw_visit_data = Traits::raw_visit_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->raw_visit_data)::BaseType> raw_visit_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::history_clusters::mojom::RawVisitDataDataView>(
      in_raw_visit_data,
      raw_visit_data_fragment);

    fragment->raw_visit_data.Set(
        raw_visit_data_fragment.is_null() ? nullptr : raw_visit_data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->raw_visit_data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null raw_visit_data in URLVisit struct");

    decltype(Traits::duplicates(input)) in_duplicates = Traits::duplicates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->duplicates)::BaseType>
        duplicates_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& duplicates_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::RawVisitDataDataView>>(
      in_duplicates,
      duplicates_fragment,
      &duplicates_validate_params);

    fragment->duplicates.Set(
        duplicates_fragment.is_null() ? nullptr : duplicates_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->duplicates.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null duplicates in URLVisit struct");

    decltype(Traits::relative_date(input)) in_relative_date = Traits::relative_date(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relative_date)::BaseType> relative_date_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_relative_date,
      relative_date_fragment);

    fragment->relative_date.Set(
        relative_date_fragment.is_null() ? nullptr : relative_date_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relative_date.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relative_date in URLVisit struct");

    decltype(Traits::annotations(input)) in_annotations = Traits::annotations(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->annotations)::BaseType>
        annotations_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& annotations_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::history_clusters::mojom::internal::Annotation_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::Annotation>>(
      in_annotations,
      annotations_fragment,
      &annotations_validate_params);

    fragment->annotations.Set(
        annotations_fragment.is_null() ? nullptr : annotations_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->annotations.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null annotations in URLVisit struct");

    fragment->is_known_to_sync = Traits::is_known_to_sync(input);

    decltype(Traits::debug_info(input)) in_debug_info = Traits::debug_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_info)::BaseType>
        debug_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& debug_info_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_debug_info,
      debug_info_fragment,
      &debug_info_validate_params);

    fragment->debug_info.Set(
        debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->debug_info.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null debug_info in URLVisit struct");

    fragment->has_url_keyed_image = Traits::has_url_keyed_image(input);
  }

  static bool Deserialize(::history_clusters::mojom::internal::URLVisit_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history_clusters::mojom::URLVisitDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::history_clusters::mojom::ClusterDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::history_clusters::mojom::ClusterDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::history_clusters::mojom::internal::Cluster_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::visits(input)) in_visits = Traits::visits(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->visits)::BaseType>
        visits_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& visits_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::URLVisitDataView>>(
      in_visits,
      visits_fragment,
      &visits_validate_params);

    fragment->visits.Set(
        visits_fragment.is_null() ? nullptr : visits_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->visits.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visits in Cluster struct");

    decltype(Traits::label(input)) in_label = Traits::label(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label)::BaseType> label_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_label,
      label_fragment);

    fragment->label.Set(
        label_fragment.is_null() ? nullptr : label_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label in Cluster struct");

    decltype(Traits::tab_group_name(input)) in_tab_group_name = Traits::tab_group_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->tab_group_name)::BaseType> tab_group_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_tab_group_name,
      tab_group_name_fragment);

    fragment->tab_group_name.Set(
        tab_group_name_fragment.is_null() ? nullptr : tab_group_name_fragment.data());

    decltype(Traits::label_match_positions(input)) in_label_match_positions = Traits::label_match_positions(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->label_match_positions)::BaseType>
        label_match_positions_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& label_match_positions_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::MatchPositionDataView>>(
      in_label_match_positions,
      label_match_positions_fragment,
      &label_match_positions_validate_params);

    fragment->label_match_positions.Set(
        label_match_positions_fragment.is_null() ? nullptr : label_match_positions_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->label_match_positions.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null label_match_positions in Cluster struct");

    decltype(Traits::related_searches(input)) in_related_searches = Traits::related_searches(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->related_searches)::BaseType>
        related_searches_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& related_searches_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::history_clusters::mojom::SearchQueryDataView>>(
      in_related_searches,
      related_searches_fragment,
      &related_searches_validate_params);

    fragment->related_searches.Set(
        related_searches_fragment.is_null() ? nullptr : related_searches_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->related_searches.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null related_searches in Cluster struct");

    decltype(Traits::image_url(input)) in_image_url = Traits::image_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->image_url)::BaseType> image_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_image_url,
      image_url_fragment);

    fragment->image_url.Set(
        image_url_fragment.is_null() ? nullptr : image_url_fragment.data());

    fragment->from_persistence = Traits::from_persistence(input);

    decltype(Traits::debug_info(input)) in_debug_info = Traits::debug_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_info)::BaseType> debug_info_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_debug_info,
      debug_info_fragment);

    fragment->debug_info.Set(
        debug_info_fragment.is_null() ? nullptr : debug_info_fragment.data());
  }

  static bool Deserialize(::history_clusters::mojom::internal::Cluster_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::history_clusters::mojom::ClusterDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace history_clusters::mojom {



inline void SearchQueryDataView::GetQueryDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->query.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void SearchQueryDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}


inline void RawVisitDataDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RawVisitDataDataView::GetVisitTimeDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->visit_time.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, message_);
}


inline void URLVisitDataView::GetNormalizedUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->normalized_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void URLVisitDataView::GetUrlForDisplayDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url_for_display.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLVisitDataView::GetPageTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->page_title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLVisitDataView::GetTitleMatchPositionsDataView(
    mojo::ArrayDataView<MatchPositionDataView>* output) {
  auto pointer = data_->title_match_positions.Get();
  *output = mojo::ArrayDataView<MatchPositionDataView>(pointer, message_);
}
inline void URLVisitDataView::GetUrlForDisplayMatchPositionsDataView(
    mojo::ArrayDataView<MatchPositionDataView>* output) {
  auto pointer = data_->url_for_display_match_positions.Get();
  *output = mojo::ArrayDataView<MatchPositionDataView>(pointer, message_);
}
inline void URLVisitDataView::GetRawVisitDataDataView(
    RawVisitDataDataView* output) {
  auto pointer = data_->raw_visit_data.Get();
  *output = RawVisitDataDataView(pointer, message_);
}
inline void URLVisitDataView::GetDuplicatesDataView(
    mojo::ArrayDataView<RawVisitDataDataView>* output) {
  auto pointer = data_->duplicates.Get();
  *output = mojo::ArrayDataView<RawVisitDataDataView>(pointer, message_);
}
inline void URLVisitDataView::GetRelativeDateDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->relative_date.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void URLVisitDataView::GetAnnotationsDataView(
    mojo::ArrayDataView<Annotation>* output) {
  auto pointer = data_->annotations.Get();
  *output = mojo::ArrayDataView<Annotation>(pointer, message_);
}
inline void URLVisitDataView::GetDebugInfoDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->debug_info.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}


inline void ClusterDataView::GetVisitsDataView(
    mojo::ArrayDataView<URLVisitDataView>* output) {
  auto pointer = data_->visits.Get();
  *output = mojo::ArrayDataView<URLVisitDataView>(pointer, message_);
}
inline void ClusterDataView::GetLabelDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->label.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClusterDataView::GetTabGroupNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->tab_group_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ClusterDataView::GetLabelMatchPositionsDataView(
    mojo::ArrayDataView<MatchPositionDataView>* output) {
  auto pointer = data_->label_match_positions.Get();
  *output = mojo::ArrayDataView<MatchPositionDataView>(pointer, message_);
}
inline void ClusterDataView::GetRelatedSearchesDataView(
    mojo::ArrayDataView<SearchQueryDataView>* output) {
  auto pointer = data_->related_searches.Get();
  *output = mojo::ArrayDataView<SearchQueryDataView>(pointer, message_);
}
inline void ClusterDataView::GetImageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->image_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void ClusterDataView::GetDebugInfoDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->debug_info.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // history_clusters::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_clusters::mojom::Annotation> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_clusters::mojom::Annotation value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::history_clusters::mojom::InteractionState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::history_clusters::mojom::InteractionState value);
};

} // namespace perfetto

#endif  // COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_SHARED_H_