// components/history_clusters/public/mojom/history_cluster_types.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_DATA_VIEW_H_
#define COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/history_clusters/public/mojom/history_cluster_types.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace history_clusters::mojom {
class MatchPositionDataView;

class SearchQueryDataView;

class RawVisitDataDataView;

class URLVisitDataView;

class ClusterDataView;



}  // history_clusters::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::history_clusters::mojom::MatchPositionDataView> {
  using Data = ::history_clusters::mojom::internal::MatchPosition_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history_clusters::mojom::SearchQueryDataView> {
  using Data = ::history_clusters::mojom::internal::SearchQuery_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history_clusters::mojom::RawVisitDataDataView> {
  using Data = ::history_clusters::mojom::internal::RawVisitData_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history_clusters::mojom::URLVisitDataView> {
  using Data = ::history_clusters::mojom::internal::URLVisit_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::history_clusters::mojom::ClusterDataView> {
  using Data = ::history_clusters::mojom::internal::Cluster_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace history_clusters::mojom {


enum class Annotation : int32_t {
  
  kBookmarked = 0,
  
  kSearchResultsPage = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, Annotation value);
inline bool IsKnownEnumValue(Annotation value) {
  return internal::Annotation_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class InteractionState : int32_t {
  
  kDefault = 0,
  
  kHidden = 1,
  
  kDone = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, InteractionState value);
inline bool IsKnownEnumValue(InteractionState value) {
  return internal::InteractionState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class MatchPositionDataView {
 public:
  MatchPositionDataView() = default;

  MatchPositionDataView(
      internal::MatchPosition_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t begin() const {
    return data_->begin;
  }
  uint32_t end() const {
    return data_->end;
  }
 private:
  internal::MatchPosition_Data* data_ = nullptr;
};


class SearchQueryDataView {
 public:
  SearchQueryDataView() = default;

  SearchQueryDataView(
      internal::SearchQuery_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetQueryDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadQuery(UserType* output) {
    
    auto* pointer = data_->query.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
 private:
  internal::SearchQuery_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class RawVisitDataDataView {
 public:
  RawVisitDataDataView() = default;

  RawVisitDataDataView(
      internal::RawVisitData_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetVisitTimeDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisitTime(UserType* output) {
    
    auto* pointer = data_->visit_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, message_);
  }
 private:
  internal::RawVisitData_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class URLVisitDataView {
 public:
  URLVisitDataView() = default;

  URLVisitDataView(
      internal::URLVisit_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t visit_id() const {
    return data_->visit_id;
  }
  inline void GetNormalizedUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNormalizedUrl(UserType* output) {
    
    auto* pointer = data_->normalized_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetUrlForDisplayDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlForDisplay(UserType* output) {
    
    auto* pointer = data_->url_for_display.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPageTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageTitle(UserType* output) {
    
    auto* pointer = data_->page_title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleMatchPositionsDataView(
      mojo::ArrayDataView<MatchPositionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitleMatchPositions(UserType* output) {
    
    auto* pointer = data_->title_match_positions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::MatchPositionDataView>>(
        pointer, output, message_);
  }
  inline void GetUrlForDisplayMatchPositionsDataView(
      mojo::ArrayDataView<MatchPositionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrlForDisplayMatchPositions(UserType* output) {
    
    auto* pointer = data_->url_for_display_match_positions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::MatchPositionDataView>>(
        pointer, output, message_);
  }
  inline void GetRawVisitDataDataView(
      RawVisitDataDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRawVisitData(UserType* output) {
    
    auto* pointer = data_->raw_visit_data.Get();
    return mojo::internal::Deserialize<::history_clusters::mojom::RawVisitDataDataView>(
        pointer, output, message_);
  }
  inline void GetDuplicatesDataView(
      mojo::ArrayDataView<RawVisitDataDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDuplicates(UserType* output) {
    
    auto* pointer = data_->duplicates.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::RawVisitDataDataView>>(
        pointer, output, message_);
  }
  inline void GetRelativeDateDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelativeDate(UserType* output) {
    
    auto* pointer = data_->relative_date.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetAnnotationsDataView(
      mojo::ArrayDataView<Annotation>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAnnotations(UserType* output) {
    
    auto* pointer = data_->annotations.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::Annotation>>(
        pointer, output, message_);
  }
  bool is_known_to_sync() const {
    return data_->is_known_to_sync;
  }
  inline void GetDebugInfoDataView(
      mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugInfo(UserType* output) {
    
    auto* pointer = data_->debug_info.Get();
    return mojo::internal::Deserialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
        pointer, output, message_);
  }
  bool has_url_keyed_image() const {
    return data_->has_url_keyed_image;
  }
 private:
  internal::URLVisit_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ClusterDataView {
 public:
  ClusterDataView() = default;

  ClusterDataView(
      internal::Cluster_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t id() const {
    return data_->id;
  }
  inline void GetVisitsDataView(
      mojo::ArrayDataView<URLVisitDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadVisits(UserType* output) {
    
    auto* pointer = data_->visits.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::URLVisitDataView>>(
        pointer, output, message_);
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTabGroupNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTabGroupName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `tab_group_name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTabGroupName` instead "
    "of `ReadTabGroupName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tab_group_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLabelMatchPositionsDataView(
      mojo::ArrayDataView<MatchPositionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabelMatchPositions(UserType* output) {
    
    auto* pointer = data_->label_match_positions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::MatchPositionDataView>>(
        pointer, output, message_);
  }
  inline void GetRelatedSearchesDataView(
      mojo::ArrayDataView<SearchQueryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRelatedSearches(UserType* output) {
    
    auto* pointer = data_->related_searches.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::history_clusters::mojom::SearchQueryDataView>>(
        pointer, output, message_);
  }
  inline void GetImageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::url::mojom::UrlDataView, UserType>(),
    "Attempting to read the optional `image_url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadImageUrl` instead "
    "of `ReadImageUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->image_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool from_persistence() const {
    return data_->from_persistence;
  }
  inline void GetDebugInfoDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugInfo(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `debug_info` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDebugInfo` instead "
    "of `ReadDebugInfo if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->debug_info.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::Cluster_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // history_clusters::mojom

#endif  // COMPONENTS_HISTORY_CLUSTERS_PUBLIC_MOJOM_HISTORY_CLUSTER_TYPES_MOJOM_DATA_VIEW_H_