// components/guest_view/common/guest_view.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/guest_view/common/guest_view.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/guest_view/common/guest_view.mojom-params-data.h"
#include "components/guest_view/common/guest_view.mojom-shared-message-ids.h"

#include "components/guest_view/common/guest_view.mojom-import-headers.h"
#include "components/guest_view/common/guest_view.mojom-test-utils.h"


namespace guest_view::mojom {
// The declaration includes the definition on other builds.

ViewHandle::IPCStableHashFunction ViewHandle::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ViewHandle::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

ViewHandleProxy::ViewHandleProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool ViewHandleStubDispatch::Accept(
    ViewHandle* impl,
    mojo::Message* message) {
  return false;
}

// static
bool ViewHandleStubDispatch::AcceptWithResponder(
    ViewHandle* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool ViewHandleRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::guest_view::mojom::ViewHandle::Name_,
    {});
}

// The declaration includes the definition on other builds.

GuestViewHost::IPCStableHashFunction GuestViewHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GuestViewHost>(message.name())) {
    case messages::GuestViewHost::kAttachToEmbedderFrame: {
      return &GuestViewHost::AttachToEmbedderFrame_Sym::IPCStableHash;
    }
    case messages::GuestViewHost::kViewCreated: {
      return &GuestViewHost::ViewCreated_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GuestViewHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GuestViewHost>(message.name())) {
      case messages::GuestViewHost::kAttachToEmbedderFrame:
            return "Receive guest_view::mojom::GuestViewHost::AttachToEmbedderFrame";
      case messages::GuestViewHost::kViewCreated:
            return "Receive guest_view::mojom::GuestViewHost::ViewCreated";
    }
  } else {
    switch (static_cast<messages::GuestViewHost>(message.name())) {
      case messages::GuestViewHost::kAttachToEmbedderFrame:
            return "Receive reply guest_view::mojom::GuestViewHost::AttachToEmbedderFrame";
      case messages::GuestViewHost::kViewCreated:
            return "Receive reply guest_view::mojom::GuestViewHost::ViewCreated";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GuestViewHost::AttachToEmbedderFrame_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x417caed5;  // IPCStableHash for guest_view::mojom::GuestViewHost::AttachToEmbedderFrame
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t GuestViewHost::ViewCreated_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xeaf75df2;  // IPCStableHash for guest_view::mojom::GuestViewHost::ViewCreated
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GuestViewHost_AttachToEmbedderFrame_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GuestViewHost_AttachToEmbedderFrame_ForwardToCallback(
      GuestViewHost::AttachToEmbedderFrameCallback callback
      ) : callback_(std::move(callback)) {
  }

  GuestViewHost_AttachToEmbedderFrame_ForwardToCallback(const GuestViewHost_AttachToEmbedderFrame_ForwardToCallback&) = delete;
  GuestViewHost_AttachToEmbedderFrame_ForwardToCallback& operator=(const GuestViewHost_AttachToEmbedderFrame_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GuestViewHost::AttachToEmbedderFrameCallback callback_;
};

GuestViewHostProxy::GuestViewHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GuestViewHostProxy::AttachToEmbedderFrame(
    int32_t in_element_instance_id, int32_t in_guest_instance_id, ::base::Value::Dict in_params, AttachToEmbedderFrameCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send guest_view::mojom::GuestViewHost::AttachToEmbedderFrame", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("element_instance_id"), in_element_instance_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guest_instance_id"), in_guest_instance_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("params"), in_params,
                        "<value of type ::base::Value::Dict>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestViewHost::kAttachToEmbedderFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::guest_view::mojom::internal::GuestViewHost_AttachToEmbedderFrame_Params_Data> params(
          message);
  params.Allocate();

  params->element_instance_id = in_element_instance_id;

  params->guest_instance_id = in_guest_instance_id;
  mojo::internal::MessageFragment<
      typename decltype(params->params)::BaseType> params_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
    in_params,
    params_fragment);

  params->params.Set(
      params_fragment.is_null() ? nullptr : params_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->params.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null params in GuestViewHost.AttachToEmbedderFrame request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestViewHost::Name_);
  message.set_method_name("AttachToEmbedderFrame");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GuestViewHost_AttachToEmbedderFrame_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void GuestViewHostProxy::ViewCreated(
    int32_t in_view_instance_id, const std::string& in_view_type, ::mojo::PendingReceiver<ViewHandle> in_keep_alive_handle_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send guest_view::mojom::GuestViewHost::ViewCreated", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_instance_id"), in_view_instance_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("view_type"), in_view_type,
                        "<value of type const std::string&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("keep_alive_handle_receiver"), in_keep_alive_handle_receiver,
                        "<value of type ::mojo::PendingReceiver<ViewHandle>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestViewHost::kViewCreated), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::guest_view::mojom::internal::GuestViewHost_ViewCreated_Params_Data> params(
          message);
  params.Allocate();

  params->view_instance_id = in_view_instance_id;
  mojo::internal::MessageFragment<
      typename decltype(params->view_type)::BaseType> view_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_view_type,
    view_type_fragment);

  params->view_type.Set(
      view_type_fragment.is_null() ? nullptr : view_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->view_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null view_type in GuestViewHost.ViewCreated request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::guest_view::mojom::ViewHandleInterfaceBase>>(
    in_keep_alive_handle_receiver,
    &params->keep_alive_handle_receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->keep_alive_handle_receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid keep_alive_handle_receiver in GuestViewHost.ViewCreated request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestViewHost::Name_);
  message.set_method_name("ViewCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class GuestViewHost_AttachToEmbedderFrame_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GuestViewHost::AttachToEmbedderFrameCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GuestViewHost_AttachToEmbedderFrame_ProxyToResponder> proxy(
        new GuestViewHost_AttachToEmbedderFrame_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GuestViewHost_AttachToEmbedderFrame_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GuestViewHost_AttachToEmbedderFrame_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GuestViewHost_AttachToEmbedderFrame_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GuestViewHost::AttachToEmbedderFrameCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool GuestViewHost_AttachToEmbedderFrame_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GuestViewHost_AttachToEmbedderFrame_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GuestViewHost_AttachToEmbedderFrame_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GuestViewHost.0
  bool success = true;
  GuestViewHost_AttachToEmbedderFrame_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GuestViewHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void GuestViewHost_AttachToEmbedderFrame_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply guest_view::mojom::GuestViewHost::AttachToEmbedderFrame");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestViewHost::kAttachToEmbedderFrame), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::guest_view::mojom::internal::GuestViewHost_AttachToEmbedderFrame_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestViewHost::Name_);
  message.set_method_name("AttachToEmbedderFrame");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GuestViewHostStubDispatch::Accept(
    GuestViewHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GuestViewHost>(message->header()->name)) {
    case messages::GuestViewHost::kAttachToEmbedderFrame: {
      break;
    }
    case messages::GuestViewHost::kViewCreated: {
      DCHECK(message->is_serialized());
      internal::GuestViewHost_ViewCreated_Params_Data* params =
          reinterpret_cast<internal::GuestViewHost_ViewCreated_Params_Data*>(
              message->mutable_payload());
      

      // Validation for GuestViewHost.1
      bool success = true;
      int32_t p_view_instance_id{};
      std::string p_view_type{};
      ::mojo::PendingReceiver<ViewHandle> p_keep_alive_handle_receiver{};
      GuestViewHost_ViewCreated_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_view_instance_id = input_data_view.view_instance_id();
      if (success && !input_data_view.ReadViewType(&p_view_type))
        success = false;
      if (success) {
        p_keep_alive_handle_receiver =
            input_data_view.TakeKeepAliveHandleReceiver<decltype(p_keep_alive_handle_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestViewHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ViewCreated(        
        std::move(p_view_instance_id), 
        std::move(p_view_type), 
        std::move(p_keep_alive_handle_receiver));
      return true;
    }
  }
  return false;
}

// static
bool GuestViewHostStubDispatch::AcceptWithResponder(
    GuestViewHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GuestViewHost>(message->header()->name)) {
    case messages::GuestViewHost::kAttachToEmbedderFrame: {
      internal::GuestViewHost_AttachToEmbedderFrame_Params_Data* params =
          reinterpret_cast<
              internal::GuestViewHost_AttachToEmbedderFrame_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GuestViewHost.0
      bool success = true;
      int32_t p_element_instance_id{};
      int32_t p_guest_instance_id{};
      ::base::Value::Dict p_params{};
      GuestViewHost_AttachToEmbedderFrame_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_element_instance_id = input_data_view.element_instance_id();
      if (success)
        p_guest_instance_id = input_data_view.guest_instance_id();
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestViewHost::Name_, 0, false);
        return false;
      }
      auto callback =
          GuestViewHost_AttachToEmbedderFrame_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AttachToEmbedderFrame(        
        std::move(p_element_instance_id), 
        std::move(p_guest_instance_id), 
        std::move(p_params), std::move(callback));
      return true;
    }
    case messages::GuestViewHost::kViewCreated: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGuestViewHostValidationInfo[] = {
    { &internal::GuestViewHost_AttachToEmbedderFrame_Params_Data::Validate,
     &internal::GuestViewHost_AttachToEmbedderFrame_ResponseParams_Data::Validate},
    { &internal::GuestViewHost_ViewCreated_Params_Data::Validate,
     nullptr /* no response */},
};

bool GuestViewHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::guest_view::mojom::GuestViewHost::Name_,
    kGuestViewHostValidationInfo);
}

bool GuestViewHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::guest_view::mojom::GuestViewHost::Name_,
    kGuestViewHostValidationInfo);
}


}  // guest_view::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace guest_view::mojom {


ViewHandleAsyncWaiter::ViewHandleAsyncWaiter(
    ViewHandle* proxy) : proxy_(proxy) {}

ViewHandleAsyncWaiter::~ViewHandleAsyncWaiter() = default;





void GuestViewHostInterceptorForTesting::AttachToEmbedderFrame(int32_t element_instance_id, int32_t guest_instance_id, ::base::Value::Dict params, AttachToEmbedderFrameCallback callback) {
  GetForwardingInterface()->AttachToEmbedderFrame(
    std::move(element_instance_id)
    , 
    std::move(guest_instance_id)
    , 
    std::move(params)
    , std::move(callback));
}
void GuestViewHostInterceptorForTesting::ViewCreated(int32_t view_instance_id, const std::string& view_type, ::mojo::PendingReceiver<ViewHandle> keep_alive_handle_receiver) {
  GetForwardingInterface()->ViewCreated(
    std::move(view_instance_id)
    , 
    std::move(view_type)
    , 
    std::move(keep_alive_handle_receiver)
    );
}
GuestViewHostAsyncWaiter::GuestViewHostAsyncWaiter(
    GuestViewHost* proxy) : proxy_(proxy) {}

GuestViewHostAsyncWaiter::~GuestViewHostAsyncWaiter() = default;


void GuestViewHostAsyncWaiter::AttachToEmbedderFrame(
    int32_t element_instance_id, int32_t guest_instance_id, ::base::Value::Dict params) {
  base::RunLoop loop;
  proxy_->AttachToEmbedderFrame(
      std::move(element_instance_id),
      std::move(guest_instance_id),
      std::move(params),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}








}  // guest_view::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif