// components/guest_contents/common/guest_contents.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/guest_contents/common/guest_contents.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/guest_contents/common/guest_contents.mojom-params-data.h"
#include "components/guest_contents/common/guest_contents.mojom-shared-message-ids.h"

#include "components/guest_contents/common/guest_contents.mojom-import-headers.h"
#include "components/guest_contents/common/guest_contents.mojom-test-utils.h"


namespace guest_contents::mojom {
// The declaration includes the definition on other builds.

GuestContentsHost::IPCStableHashFunction GuestContentsHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::GuestContentsHost>(message.name())) {
    case messages::GuestContentsHost::kAttach: {
      return &GuestContentsHost::Attach_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* GuestContentsHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::GuestContentsHost>(message.name())) {
      case messages::GuestContentsHost::kAttach:
            return "Receive guest_contents::mojom::GuestContentsHost::Attach";
    }
  } else {
    switch (static_cast<messages::GuestContentsHost>(message.name())) {
      case messages::GuestContentsHost::kAttach:
            return "Receive reply guest_contents::mojom::GuestContentsHost::Attach";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t GuestContentsHost::Attach_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0565401d;  // IPCStableHash for guest_contents::mojom::GuestContentsHost::Attach
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class GuestContentsHost_Attach_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  GuestContentsHost_Attach_ForwardToCallback(
      GuestContentsHost::AttachCallback callback
      ) : callback_(std::move(callback)) {
  }

  GuestContentsHost_Attach_ForwardToCallback(const GuestContentsHost_Attach_ForwardToCallback&) = delete;
  GuestContentsHost_Attach_ForwardToCallback& operator=(const GuestContentsHost_Attach_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  GuestContentsHost::AttachCallback callback_;
};

GuestContentsHostProxy::GuestContentsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void GuestContentsHostProxy::Attach(
    const ::blink::LocalFrameToken& in_frame_to_swap, int32_t in_guest_contents_id, AttachCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send guest_contents::mojom::GuestContentsHost::Attach", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("frame_to_swap"), in_frame_to_swap,
                        "<value of type const ::blink::LocalFrameToken&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("guest_contents_id"), in_guest_contents_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestContentsHost::kAttach), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::guest_contents::mojom::internal::GuestContentsHost_Attach_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->frame_to_swap)::BaseType> frame_to_swap_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::LocalFrameTokenDataView>(
    in_frame_to_swap,
    frame_to_swap_fragment);

  params->frame_to_swap.Set(
      frame_to_swap_fragment.is_null() ? nullptr : frame_to_swap_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->frame_to_swap.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null frame_to_swap in GuestContentsHost.Attach request");

  params->guest_contents_id = in_guest_contents_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestContentsHost::Name_);
  message.set_method_name("Attach");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new GuestContentsHost_Attach_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class GuestContentsHost_Attach_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static GuestContentsHost::AttachCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<GuestContentsHost_Attach_ProxyToResponder> proxy(
        new GuestContentsHost_Attach_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&GuestContentsHost_Attach_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~GuestContentsHost_Attach_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  GuestContentsHost_Attach_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "GuestContentsHost::AttachCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool GuestContentsHost_Attach_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::GuestContentsHost_Attach_ResponseParams_Data* params =
      reinterpret_cast<
          internal::GuestContentsHost_Attach_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for GuestContentsHost.0
  bool success = true;
  bool p_success{};
  GuestContentsHost_Attach_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        GuestContentsHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void GuestContentsHost_Attach_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply guest_contents::mojom::GuestContentsHost::Attach", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::GuestContentsHost::kAttach), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::guest_contents::mojom::internal::GuestContentsHost_Attach_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(GuestContentsHost::Name_);
  message.set_method_name("Attach");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool GuestContentsHostStubDispatch::Accept(
    GuestContentsHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::GuestContentsHost>(message->header()->name)) {
    case messages::GuestContentsHost::kAttach: {
      break;
    }
  }
  return false;
}

// static
bool GuestContentsHostStubDispatch::AcceptWithResponder(
    GuestContentsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::GuestContentsHost>(message->header()->name)) {
    case messages::GuestContentsHost::kAttach: {
      internal::GuestContentsHost_Attach_Params_Data* params =
          reinterpret_cast<
              internal::GuestContentsHost_Attach_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for GuestContentsHost.0
      bool success = true;
      ::blink::LocalFrameToken p_frame_to_swap{};
      int32_t p_guest_contents_id{};
      GuestContentsHost_Attach_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadFrameToSwap(&p_frame_to_swap))
        success = false;
      if (success)
        p_guest_contents_id = input_data_view.guest_contents_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            GuestContentsHost::Name_, 0, false);
        return false;
      }
      auto callback =
          GuestContentsHost_Attach_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Attach(        
        std::move(p_frame_to_swap), 
        std::move(p_guest_contents_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kGuestContentsHostValidationInfo[] = {
    { &internal::GuestContentsHost_Attach_Params_Data::Validate,
     &internal::GuestContentsHost_Attach_ResponseParams_Data::Validate},
};

bool GuestContentsHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::guest_contents::mojom::GuestContentsHost::Name_,
    kGuestContentsHostValidationInfo);
}

bool GuestContentsHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::guest_contents::mojom::GuestContentsHost::Name_,
    kGuestContentsHostValidationInfo);
}


}  // guest_contents::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace guest_contents::mojom {


void GuestContentsHostInterceptorForTesting::Attach(const ::blink::LocalFrameToken& frame_to_swap, int32_t guest_contents_id, AttachCallback callback) {
  GetForwardingInterface()->Attach(
    std::move(frame_to_swap)
    , 
    std::move(guest_contents_id)
    , std::move(callback));
}
GuestContentsHostAsyncWaiter::GuestContentsHostAsyncWaiter(
    GuestContentsHost* proxy) : proxy_(proxy) {}

GuestContentsHostAsyncWaiter::~GuestContentsHostAsyncWaiter() = default;


void GuestContentsHostAsyncWaiter::Attach(
    const ::blink::LocalFrameToken& frame_to_swap, int32_t guest_contents_id, bool* out_success) {
  base::RunLoop loop;
  proxy_->Attach(
      std::move(frame_to_swap),
      std::move(guest_contents_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool GuestContentsHostAsyncWaiter::Attach(
    const ::blink::LocalFrameToken& frame_to_swap, int32_t guest_contents_id) {
  bool async_wait_result;
  Attach(std::move(frame_to_swap),std::move(guest_contents_id),&async_wait_result);
  return async_wait_result;
}






}  // guest_contents::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif