// components/global_media_controls/public/mojom/device_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_H_
#define COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/global_media_controls/public/mojom/device_service.mojom-features.h"  // IWYU pragma: export
#include "components/global_media_controls/public/mojom/device_service.mojom-shared.h"  // IWYU pragma: export
#include "components/global_media_controls/public/mojom/device_service.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "services/media_session/public/mojom/media_session.mojom.h"
#include "ui/gfx/image/mojom/image.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace global_media_controls::mojom {

class DeviceListHostProxy;

template <typename ImplRefTraits>
class DeviceListHostStub;

class DeviceListHostRequestValidator;


class DeviceListHost
    : public DeviceListHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "global_media_controls.mojom.DeviceListHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceListHostInterfaceBase;
  using Proxy_ = DeviceListHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceListHostStub<ImplRefTraits>;

  using RequestValidator_ = DeviceListHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSelectDeviceMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SelectDevice_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceListHost() = default;

  virtual void SelectDevice(const std::string& device_id) = 0;
};

class DeviceListClientProxy;

template <typename ImplRefTraits>
class DeviceListClientStub;

class DeviceListClientRequestValidator;


class DeviceListClient
    : public DeviceListClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "global_media_controls.mojom.DeviceListClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 1;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceListClientInterfaceBase;
  using Proxy_ = DeviceListClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceListClientStub<ImplRefTraits>;

  using RequestValidator_ = DeviceListClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDevicesUpdatedMinVersion = 0,
    kOnPermissionRejectedMinVersion = 1,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnDevicesUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPermissionRejected_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceListClient() = default;

  virtual void OnDevicesUpdated(std::vector<DevicePtr> devices) = 0;

  virtual void OnPermissionRejected() = 0;
};

class DeviceServiceProxy;

template <typename ImplRefTraits>
class DeviceServiceStub;

class DeviceServiceRequestValidator;


class DeviceService
    : public DeviceServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "global_media_controls.mojom.DeviceService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 1;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DeviceServiceInterfaceBase;
  using Proxy_ = DeviceServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DeviceServiceStub<ImplRefTraits>;

  using RequestValidator_ = DeviceServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kGetDeviceListHostForSessionMinVersion = 0,
    kGetDeviceListHostForPresentationMinVersion = 0,
    kSetDevicePickerProviderMinVersion = 1,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetDeviceListHostForSession_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetDeviceListHostForPresentation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDevicePickerProvider_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DeviceService() = default;

  virtual void GetDeviceListHostForSession(const std::string& session_id, ::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) = 0;

  virtual void GetDeviceListHostForPresentation(::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) = 0;

  virtual void SetDevicePickerProvider(::mojo::PendingRemote<DevicePickerProvider> provider_remote) = 0;
};

class DevicePickerProviderProxy;

template <typename ImplRefTraits>
class DevicePickerProviderStub;

class DevicePickerProviderRequestValidator;


class DevicePickerProvider
    : public DevicePickerProviderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "global_media_controls.mojom.DevicePickerProvider";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevicePickerProviderInterfaceBase;
  using Proxy_ = DevicePickerProviderProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevicePickerProviderStub<ImplRefTraits>;

  using RequestValidator_ = DevicePickerProviderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateItemMinVersion = 0,
    kDeleteItemMinVersion = 0,
    kShowItemMinVersion = 0,
    kHideItemMinVersion = 0,
    kOnMetadataChangedMinVersion = 0,
    kOnArtworkImageChangedMinVersion = 0,
    kOnFaviconImageChangedMinVersion = 0,
    kAddObserverMinVersion = 0,
    kHideMediaUIMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HideItem_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMetadataChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnArtworkImageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnFaviconImageChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AddObserver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HideMediaUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevicePickerProvider() = default;

  virtual void CreateItem(const ::base::UnguessableToken& source_id) = 0;

  virtual void DeleteItem() = 0;

  virtual void ShowItem() = 0;

  virtual void HideItem() = 0;

  virtual void OnMetadataChanged(const ::media_session::MediaMetadata& metadata) = 0;

  virtual void OnArtworkImageChanged(const ::gfx::ImageSkia& artwork_image) = 0;

  virtual void OnFaviconImageChanged(const ::gfx::ImageSkia& favicon_image) = 0;

  virtual void AddObserver(::mojo::PendingRemote<DevicePickerObserver> observer) = 0;

  virtual void HideMediaUI() = 0;
};

class DevicePickerObserverProxy;

template <typename ImplRefTraits>
class DevicePickerObserverStub;

class DevicePickerObserverRequestValidator;


class DevicePickerObserver
    : public DevicePickerObserverInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "global_media_controls.mojom.DevicePickerObserver";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DevicePickerObserverInterfaceBase;
  using Proxy_ = DevicePickerObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = DevicePickerObserverStub<ImplRefTraits>;

  using RequestValidator_ = DevicePickerObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnMediaUIOpenedMinVersion = 0,
    kOnMediaUIClosedMinVersion = 0,
    kOnMediaUIUpdatedMinVersion = 0,
    kOnPickerDismissedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnMediaUIOpened_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMediaUIClosed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMediaUIUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPickerDismissed_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DevicePickerObserver() = default;

  virtual void OnMediaUIOpened() = 0;

  virtual void OnMediaUIClosed() = 0;

  virtual void OnMediaUIUpdated() = 0;

  virtual void OnPickerDismissed() = 0;
};



class  DeviceListHostProxy
    : public DeviceListHost {
 public:
  using InterfaceType = DeviceListHost;

  explicit DeviceListHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SelectDevice(const std::string& device_id) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DeviceListClientProxy
    : public DeviceListClient {
 public:
  using InterfaceType = DeviceListClient;

  explicit DeviceListClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDevicesUpdated(std::vector<DevicePtr> devices) final;
  
  void OnPermissionRejected() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DeviceServiceProxy
    : public DeviceService {
 public:
  using InterfaceType = DeviceService;

  explicit DeviceServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetDeviceListHostForSession(const std::string& session_id, ::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) final;
  
  void GetDeviceListHostForPresentation(::mojo::PendingReceiver<DeviceListHost> host_receiver, ::mojo::PendingRemote<DeviceListClient> client_remote) final;
  
  void SetDevicePickerProvider(::mojo::PendingRemote<DevicePickerProvider> provider_remote) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DevicePickerProviderProxy
    : public DevicePickerProvider {
 public:
  using InterfaceType = DevicePickerProvider;

  explicit DevicePickerProviderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateItem(const ::base::UnguessableToken& source_id) final;
  
  void DeleteItem() final;
  
  void ShowItem() final;
  
  void HideItem() final;
  
  void OnMetadataChanged(const ::media_session::MediaMetadata& metadata) final;
  
  void OnArtworkImageChanged(const ::gfx::ImageSkia& artwork_image) final;
  
  void OnFaviconImageChanged(const ::gfx::ImageSkia& favicon_image) final;
  
  void AddObserver(::mojo::PendingRemote<DevicePickerObserver> observer) final;
  
  void HideMediaUI() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  DevicePickerObserverProxy
    : public DevicePickerObserver {
 public:
  using InterfaceType = DevicePickerObserver;

  explicit DevicePickerObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnMediaUIOpened() final;
  
  void OnMediaUIClosed() final;
  
  void OnMediaUIUpdated() final;
  
  void OnPickerDismissed() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DeviceListHostStubDispatch {
 public:
  static bool Accept(DeviceListHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceListHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceListHost>>
class DeviceListHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceListHostStub() = default;
  ~DeviceListHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceListHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceListHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceListClientStubDispatch {
 public:
  static bool Accept(DeviceListClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceListClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceListClient>>
class DeviceListClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceListClientStub() = default;
  ~DeviceListClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceListClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceListClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceServiceStubDispatch {
 public:
  static bool Accept(DeviceService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DeviceService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DeviceService>>
class DeviceServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DeviceServiceStub() = default;
  ~DeviceServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DeviceServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DevicePickerProviderStubDispatch {
 public:
  static bool Accept(DevicePickerProvider* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevicePickerProvider* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevicePickerProvider>>
class DevicePickerProviderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevicePickerProviderStub() = default;
  ~DevicePickerProviderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePickerProviderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePickerProviderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DevicePickerObserverStubDispatch {
 public:
  static bool Accept(DevicePickerObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DevicePickerObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DevicePickerObserver>>
class DevicePickerObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DevicePickerObserverStub() = default;
  ~DevicePickerObserverStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePickerObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DevicePickerObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DeviceListHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeviceListClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DeviceServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DevicePickerProviderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  DevicePickerObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  Device {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Device, T>::value>;
  using DataView = DeviceDataView;
  using Data_ = internal::Device_Data;

  template <typename... Args>
  static DevicePtr New(Args&&... args) {
    return DevicePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DevicePtr From(const U& u) {
    return mojo::TypeConverter<DevicePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Device>::Convert(*this);
  }


  Device();

  Device(
      const std::string& id,
      const std::string& name,
      const std::string& status_text,
      IconType icon);


  ~Device();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DevicePtr>
  DevicePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Device::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Device::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Device::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Device::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Device::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Device::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Device_UnserializedMessageContext<
            UserType, Device::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Device::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Device::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Device_UnserializedMessageContext<
            UserType, Device::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Device::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  std::string name;
  
  std::string status_text;
  
  IconType icon;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Device::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Device::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Device::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Device::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
DevicePtr Device::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(name),
      mojo::Clone(status_text),
      mojo::Clone(icon)
  );
}

template <typename T, Device::EnableIfSame<T>*>
bool Device::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->status_text, other_struct.status_text))
    return false;
  if (!mojo::Equals(this->icon, other_struct.icon))
    return false;
  return true;
}

template <typename T, Device::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.status_text < rhs.status_text)
    return true;
  if (rhs.status_text < lhs.status_text)
    return false;
  if (lhs.icon < rhs.icon)
    return true;
  if (rhs.icon < lhs.icon)
    return false;
  return false;
}


}  // global_media_controls::mojom

namespace mojo {


template <>
struct  StructTraits<::global_media_controls::mojom::Device::DataView,
                                         ::global_media_controls::mojom::DevicePtr> {
  static bool IsNull(const ::global_media_controls::mojom::DevicePtr& input) { return !input; }
  static void SetToNull(::global_media_controls::mojom::DevicePtr* output) { output->reset(); }

  static const decltype(::global_media_controls::mojom::Device::id)& id(
      const ::global_media_controls::mojom::DevicePtr& input) {
    return input->id;
  }

  static const decltype(::global_media_controls::mojom::Device::name)& name(
      const ::global_media_controls::mojom::DevicePtr& input) {
    return input->name;
  }

  static const decltype(::global_media_controls::mojom::Device::status_text)& status_text(
      const ::global_media_controls::mojom::DevicePtr& input) {
    return input->status_text;
  }

  static decltype(::global_media_controls::mojom::Device::icon) icon(
      const ::global_media_controls::mojom::DevicePtr& input) {
    return input->icon;
  }

  static bool Read(::global_media_controls::mojom::Device::DataView input, ::global_media_controls::mojom::DevicePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_H_