// components/global_media_controls/public/mojom/device_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/global_media_controls/public/mojom/device_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/global_media_controls/public/mojom/device_service.mojom-params-data.h"
namespace global_media_controls {
namespace mojom {

NOINLINE static const char* IconTypeToStringHelper(IconType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case IconType::kUnknown:
      return "kUnknown";
    case IconType::kThrobber:
      return "kThrobber";
    case IconType::kInfo:
      return "kInfo";
    case IconType::kTv:
      return "kTv";
    case IconType::kSpeaker:
      return "kSpeaker";
    case IconType::kSpeakerGroup:
      return "kSpeakerGroup";
    case IconType::kInput:
      return "kInput";
    default:
      return nullptr;
  }
}

std::string IconTypeToString(IconType value) {
  const char *str = IconTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown IconType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, IconType value) {
  return os << IconTypeToString(value);
}

namespace internal {


// static
bool Device_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Device_Data* object =
      static_cast<const Device_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->id, validation_context,
                                         &id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status_text, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& status_text_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->status_text, validation_context,
                                         &status_text_validate_params)) {
    return false;
  }


  if (!::global_media_controls::mojom::internal::IconType_Data
        ::Validate(object->icon, validation_context))
    return false;

  return true;
}

Device_Data::Device_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceListHost_SelectDevice_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceListHost_SelectDevice_Params_Data* object =
      static_cast<const DeviceListHost_SelectDevice_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->device_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& device_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->device_id, validation_context,
                                         &device_id_validate_params)) {
    return false;
  }

  return true;
}

DeviceListHost_SelectDevice_Params_Data::DeviceListHost_SelectDevice_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceListClient_OnDevicesUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceListClient_OnDevicesUpdated_Params_Data* object =
      static_cast<const DeviceListClient_OnDevicesUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devices, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devices, validation_context,
                                         &devices_validate_params)) {
    return false;
  }

  return true;
}

DeviceListClient_OnDevicesUpdated_Params_Data::DeviceListClient_OnDevicesUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceListClient_OnPermissionRejected_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceListClient_OnPermissionRejected_Params_Data* object =
      static_cast<const DeviceListClient_OnPermissionRejected_Params_Data*>(data);

  return true;
}

DeviceListClient_OnPermissionRejected_Params_Data::DeviceListClient_OnPermissionRejected_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceService_GetDeviceListHostForSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceService_GetDeviceListHostForSession_Params_Data* object =
      static_cast<const DeviceService_GetDeviceListHostForSession_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_remote, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceService_GetDeviceListHostForSession_Params_Data::DeviceService_GetDeviceListHostForSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceService_GetDeviceListHostForPresentation_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceService_GetDeviceListHostForPresentation_Params_Data* object =
      static_cast<const DeviceService_GetDeviceListHostForPresentation_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host_receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_remote, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceService_GetDeviceListHostForPresentation_Params_Data::DeviceService_GetDeviceListHostForPresentation_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DeviceService_SetDevicePickerProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DeviceService_SetDevicePickerProvider_Params_Data* object =
      static_cast<const DeviceService_SetDevicePickerProvider_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->provider_remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->provider_remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DeviceService_SetDevicePickerProvider_Params_Data::DeviceService_SetDevicePickerProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_CreateItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_CreateItem_Params_Data* object =
      static_cast<const DevicePickerProvider_CreateItem_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_id, validation_context))
    return false;

  return true;
}

DevicePickerProvider_CreateItem_Params_Data::DevicePickerProvider_CreateItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_DeleteItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_DeleteItem_Params_Data* object =
      static_cast<const DevicePickerProvider_DeleteItem_Params_Data*>(data);

  return true;
}

DevicePickerProvider_DeleteItem_Params_Data::DevicePickerProvider_DeleteItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_ShowItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_ShowItem_Params_Data* object =
      static_cast<const DevicePickerProvider_ShowItem_Params_Data*>(data);

  return true;
}

DevicePickerProvider_ShowItem_Params_Data::DevicePickerProvider_ShowItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_HideItem_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_HideItem_Params_Data* object =
      static_cast<const DevicePickerProvider_HideItem_Params_Data*>(data);

  return true;
}

DevicePickerProvider_HideItem_Params_Data::DevicePickerProvider_HideItem_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_OnMetadataChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_OnMetadataChanged_Params_Data* object =
      static_cast<const DevicePickerProvider_OnMetadataChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->metadata, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->metadata, validation_context))
    return false;

  return true;
}

DevicePickerProvider_OnMetadataChanged_Params_Data::DevicePickerProvider_OnMetadataChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_OnArtworkImageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_OnArtworkImageChanged_Params_Data* object =
      static_cast<const DevicePickerProvider_OnArtworkImageChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->artwork_image, validation_context))
    return false;

  return true;
}

DevicePickerProvider_OnArtworkImageChanged_Params_Data::DevicePickerProvider_OnArtworkImageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_OnFaviconImageChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_OnFaviconImageChanged_Params_Data* object =
      static_cast<const DevicePickerProvider_OnFaviconImageChanged_Params_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->favicon_image, validation_context))
    return false;

  return true;
}

DevicePickerProvider_OnFaviconImageChanged_Params_Data::DevicePickerProvider_OnFaviconImageChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_AddObserver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_AddObserver_Params_Data* object =
      static_cast<const DevicePickerProvider_AddObserver_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->observer, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->observer,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DevicePickerProvider_AddObserver_Params_Data::DevicePickerProvider_AddObserver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerProvider_HideMediaUI_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerProvider_HideMediaUI_Params_Data* object =
      static_cast<const DevicePickerProvider_HideMediaUI_Params_Data*>(data);

  return true;
}

DevicePickerProvider_HideMediaUI_Params_Data::DevicePickerProvider_HideMediaUI_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerObserver_OnMediaUIOpened_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerObserver_OnMediaUIOpened_Params_Data* object =
      static_cast<const DevicePickerObserver_OnMediaUIOpened_Params_Data*>(data);

  return true;
}

DevicePickerObserver_OnMediaUIOpened_Params_Data::DevicePickerObserver_OnMediaUIOpened_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerObserver_OnMediaUIClosed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerObserver_OnMediaUIClosed_Params_Data* object =
      static_cast<const DevicePickerObserver_OnMediaUIClosed_Params_Data*>(data);

  return true;
}

DevicePickerObserver_OnMediaUIClosed_Params_Data::DevicePickerObserver_OnMediaUIClosed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerObserver_OnMediaUIUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerObserver_OnMediaUIUpdated_Params_Data* object =
      static_cast<const DevicePickerObserver_OnMediaUIUpdated_Params_Data*>(data);

  return true;
}

DevicePickerObserver_OnMediaUIUpdated_Params_Data::DevicePickerObserver_OnMediaUIUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevicePickerObserver_OnPickerDismissed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevicePickerObserver_OnPickerDismissed_Params_Data* object =
      static_cast<const DevicePickerObserver_OnPickerDismissed_Params_Data*>(data);

  return true;
}

DevicePickerObserver_OnPickerDismissed_Params_Data::DevicePickerObserver_OnPickerDismissed_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace global_media_controls

namespace perfetto {

// static
void TraceFormatTraits<::global_media_controls::mojom::IconType>::WriteIntoTrace(
   perfetto::TracedValue context, ::global_media_controls::mojom::IconType value) {
  return std::move(context).WriteString(::global_media_controls::mojom::IconTypeToString(value));
}

} // namespace perfetto