// components/global_media_controls/public/mojom/device_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_DATA_VIEW_H_
#define COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/global_media_controls/public/mojom/device_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/media_session/public/mojom/media_session.mojom-shared.h"
#include "ui/gfx/image/mojom/image.mojom-shared.h"


namespace global_media_controls::mojom {
class DeviceDataView;



}  // global_media_controls::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::global_media_controls::mojom::DeviceDataView> {
  using Data = ::global_media_controls::mojom::internal::Device_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace global_media_controls::mojom {


enum class IconType : int32_t {
  
  kUnknown = 0,
  
  kThrobber = 1,
  
  kInfo = 2,
  
  kTv = 3,
  
  kSpeaker = 4,
  
  kSpeakerGroup = 5,
  
  kInput = 6,
  kMinValue = 0,
  kMaxValue = 6,
};

 std::ostream& operator<<(std::ostream& os, IconType value);
inline bool IsKnownEnumValue(IconType value) {
  return internal::IconType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class DeviceListHostInterfaceBase {};

using DeviceListHostPtrDataView =
    mojo::InterfacePtrDataView<DeviceListHostInterfaceBase>;
using DeviceListHostRequestDataView =
    mojo::InterfaceRequestDataView<DeviceListHostInterfaceBase>;
using DeviceListHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceListHostInterfaceBase>;
using DeviceListHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceListHostInterfaceBase>;
class DeviceListClientInterfaceBase {};

using DeviceListClientPtrDataView =
    mojo::InterfacePtrDataView<DeviceListClientInterfaceBase>;
using DeviceListClientRequestDataView =
    mojo::InterfaceRequestDataView<DeviceListClientInterfaceBase>;
using DeviceListClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceListClientInterfaceBase>;
using DeviceListClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceListClientInterfaceBase>;
class DeviceServiceInterfaceBase {};

using DeviceServicePtrDataView =
    mojo::InterfacePtrDataView<DeviceServiceInterfaceBase>;
using DeviceServiceRequestDataView =
    mojo::InterfaceRequestDataView<DeviceServiceInterfaceBase>;
using DeviceServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DeviceServiceInterfaceBase>;
using DeviceServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DeviceServiceInterfaceBase>;
class DevicePickerProviderInterfaceBase {};

using DevicePickerProviderPtrDataView =
    mojo::InterfacePtrDataView<DevicePickerProviderInterfaceBase>;
using DevicePickerProviderRequestDataView =
    mojo::InterfaceRequestDataView<DevicePickerProviderInterfaceBase>;
using DevicePickerProviderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DevicePickerProviderInterfaceBase>;
using DevicePickerProviderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DevicePickerProviderInterfaceBase>;
class DevicePickerObserverInterfaceBase {};

using DevicePickerObserverPtrDataView =
    mojo::InterfacePtrDataView<DevicePickerObserverInterfaceBase>;
using DevicePickerObserverRequestDataView =
    mojo::InterfaceRequestDataView<DevicePickerObserverInterfaceBase>;
using DevicePickerObserverAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<DevicePickerObserverInterfaceBase>;
using DevicePickerObserverAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<DevicePickerObserverInterfaceBase>;


class DeviceDataView {
 public:
  DeviceDataView() = default;

  DeviceDataView(
      internal::Device_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetStatusTextDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStatusText(UserType* output) {
    
    auto* pointer = data_->status_text.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadIcon(UserType* output) const {
    auto data_value = data_->icon;
    return mojo::internal::Deserialize<::global_media_controls::mojom::IconType>(
        data_value, output);
  }
  IconType icon() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::global_media_controls::mojom::IconType>(data_->icon));
  }
 private:
  internal::Device_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // global_media_controls::mojom

#endif  // COMPONENTS_GLOBAL_MEDIA_CONTROLS_PUBLIC_MOJOM_DEVICE_SERVICE_MOJOM_DATA_VIEW_H_