// components/feed/mojom/rss_link_reader.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_SHARED_H_
#define COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/feed/mojom/rss_link_reader.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/feed/mojom/rss_link_reader.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::feed::mojom::RssLinksDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::feed::mojom::RssLinksDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::feed::mojom::internal::RssLinks_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::page_url(input)) in_page_url = Traits::page_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->page_url)::BaseType> page_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_page_url,
      page_url_fragment);

    fragment->page_url.Set(
        page_url_fragment.is_null() ? nullptr : page_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->page_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null page_url in RssLinks struct");

    decltype(Traits::links(input)) in_links = Traits::links(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->links)::BaseType>
        links_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& links_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_links,
      links_fragment,
      &links_validate_params);

    fragment->links.Set(
        links_fragment.is_null() ? nullptr : links_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->links.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null links in RssLinks struct");
  }

  static bool Deserialize(::feed::mojom::internal::RssLinks_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::feed::mojom::RssLinksDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace feed::mojom {

inline void RssLinksDataView::GetPageUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->page_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void RssLinksDataView::GetLinksDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->links.Get();
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}



}  // feed::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_SHARED_H_