// components/feed/mojom/rss_link_reader.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_DATA_VIEW_H_
#define COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/feed/mojom/rss_link_reader.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"


namespace feed::mojom {
class RssLinksDataView;



}  // feed::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::feed::mojom::RssLinksDataView> {
  using Data = ::feed::mojom::internal::RssLinks_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace feed::mojom {
// Interface base classes. They are used for type safety check.
class RssLinkReaderInterfaceBase {};

using RssLinkReaderPtrDataView =
    mojo::InterfacePtrDataView<RssLinkReaderInterfaceBase>;
using RssLinkReaderRequestDataView =
    mojo::InterfaceRequestDataView<RssLinkReaderInterfaceBase>;
using RssLinkReaderAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<RssLinkReaderInterfaceBase>;
using RssLinkReaderAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<RssLinkReaderInterfaceBase>;


class RssLinksDataView {
 public:
  RssLinksDataView() = default;

  RssLinksDataView(
      internal::RssLinks_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetPageUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPageUrl(UserType* output) {
    
    auto* pointer = data_->page_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetLinksDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinks(UserType* output) {
    
    auto* pointer = data_->links.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::RssLinks_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // feed::mojom

#endif  // COMPONENTS_FEED_MOJOM_RSS_LINK_READER_MOJOM_DATA_VIEW_H_