// Copyright 2017 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{addWebUiListener}from"chrome://resources/js/cr.js";import{getRequiredElement}from"chrome://resources/js/util.js";import{html,render}from"chrome://resources/lit/v3_0/lit.rollup.js";import{DownloadInternalsBrowserProxyImpl,ServiceEntryState}from"./download_internals_browser_proxy.js";import{getFinishedServiceEntryClass,getOngoingServiceEntryClass,getServiceRequestClass}from"./download_internals_visuals.js";const browserProxy=DownloadInternalsBrowserProxyImpl.getInstance();const ongoingServiceEntries=[];const finishedServiceEntries=[];const serviceRequests=[];function getOngoingEntriesHtml(entries){return html`
    <table class="styled-table">
      <thead>
        <tr>
          <th>State</th>
          <th>Client</th>
          <th>ID</th>
          <th>URL</th>
          <th>Bytes Downloaded</th>
        </tr>
      </thead>
      <tbody>
        ${entries.map((item=>html`
          <tr class="${getOngoingServiceEntryClass(item)}"
            <td>
              <div>${item.state}</div>
              ${item.driver?html`
                <div><span>${item.driver.state}</span></div>
              `:""}
            </td>
            <td>${item.client}</td>
            <td>${item.guid}</td>
            <td>${item.url}</td>
            <td>${item.bytes_downloaded}</td>
          </tr>
        `))}
      </tbody>
    </table>
  `}function getFinishedEntriesHtml(entries){return html`
    <table class="styled-table">
      <thead>
        <tr>
          <th>Result</th>
          <th>Client</th>
          <th>ID</th>
          <th>URL</th>
          <th>Size</th>
          <th>Time</th>
        </tr>
      </thead>
      <tbody>
        ${entries.map((item=>html`
          <tr class="${getFinishedServiceEntryClass(item)}">
            <td>${item.result}</td>
            <td>${item.client}</td>
            <td>${item.guid}</td>
            <td>
              <div>${item.url}</div>
              <div>${item.file_path}</div>
            </td>
            <td>${item.bytes_downloaded}</td>
            <td>${item.time_downloaded}</td>
          </tr>
        `))}
      </tbody>
    </table>
  `}function getRequestInfoHtml(requests){return html`
    <table class="styled-table">
      <thead>
        <tr>
          <th>Result</th>
          <th>Client</th>
          <th>ID</th>
        </tr>
      </thead>
      <tbody>
        ${requests.map((item=>html`
          <tr class="${getServiceRequestClass(item)}">
            <td>${item.result}</td>
            <td>${item.client}</td>
            <td>${item.guid}</td>
          </tr>
        `))}
      </tbody>
    </table>
  `}function removeGuidFromList(list,guid){const index=list.findIndex((entry=>entry.guid===guid));if(index!==-1){list.splice(index,1)}}function addOrUpdateEntryByGuid(list,newEntry){const index=list.findIndex((entry=>entry.guid===newEntry.guid));if(index!==-1){list[index]=newEntry}else{list.unshift(newEntry)}}function updateEntryTables(){render(getOngoingEntriesHtml(ongoingServiceEntries),getRequiredElement("download-service-ongoing-entries-info"));render(getFinishedEntriesHtml(finishedServiceEntries),getRequiredElement("download-service-finished-entries-info"))}function onServiceStatusChanged(state){getRequiredElement("service-state").textContent=state.serviceState;getRequiredElement("service-status-model").textContent=state.modelStatus;getRequiredElement("service-status-driver").textContent=state.driverStatus;getRequiredElement("service-status-file").textContent=state.fileMonitorStatus}function onServiceDownloadsAvailable(entries){for(let i=0;i<entries.length;i++){const entry=entries[i];if(entry.state===ServiceEntryState.COMPLETE){finishedServiceEntries.unshift(entry)}else{ongoingServiceEntries.unshift(entry)}}updateEntryTables()}function onServiceDownloadChanged(entry){if(entry.state===ServiceEntryState.COMPLETE){removeGuidFromList(ongoingServiceEntries,entry.guid);addOrUpdateEntryByGuid(finishedServiceEntries,entry)}else{addOrUpdateEntryByGuid(ongoingServiceEntries,entry)}updateEntryTables()}function onServiceDownloadFailed(entry){removeGuidFromList(ongoingServiceEntries,entry.guid);addOrUpdateEntryByGuid(finishedServiceEntries,entry);updateEntryTables()}function onServiceRequestMade(request){serviceRequests.unshift(request);render(getRequestInfoHtml(serviceRequests),getRequiredElement("download-service-request-info"))}function initialize(){addWebUiListener("service-status-changed",onServiceStatusChanged);addWebUiListener("service-downloads-available",onServiceDownloadsAvailable);addWebUiListener("service-download-changed",onServiceDownloadChanged);addWebUiListener("service-download-failed",onServiceDownloadFailed);addWebUiListener("service-request-made",onServiceRequestMade);getRequiredElement("start-download").onclick=function(){browserProxy.startDownload(getRequiredElement("download-url").value)};browserProxy.getServiceStatus().then(onServiceStatusChanged);browserProxy.getServiceDownloads().then(onServiceDownloadsAvailable)}document.addEventListener("DOMContentLoaded",initialize);