// components/download/public/common/download_stream.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_SEND_VALIDATION_H_
#define COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_SEND_VALIDATION_H_

#include "components/download/public/common/download_stream.mojom-shared-internal.h"

#include "components/download/public/common/download_stream.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::download::mojom::NetworkRequestStatus, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::download::mojom::DownloadStreamHandleDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::download::mojom::DownloadStreamHandleDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::download::mojom::internal::DownloadStreamHandle_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::stream(input)) in_stream = Traits::stream(input);

      
      mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
        in_stream,
        &fragment->stream,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->stream)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid stream in DownloadStreamHandle struct");

      decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::download::mojom::DownloadStreamClientInterfaceBase>>(
        in_client_receiver,
        &fragment->client_receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client_receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_receiver in DownloadStreamHandle struct");
  }
};

}  // namespace mojo::internal

#endif  // COMPONENTS_DOWNLOAD_PUBLIC_COMMON_DOWNLOAD_STREAM_MOJOM_SEND_VALIDATION_H_