// components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DOM_DISTILLER_CONTENT_COMMON_MOJOM_DISTILLER_JAVASCRIPT_SERVICE_MOJOM_H_
#define COMPONENTS_DOM_DISTILLER_CONTENT_COMMON_MOJOM_DISTILLER_JAVASCRIPT_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom-features.h"  // IWYU pragma: export
#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom-shared.h"  // IWYU pragma: export
#include "components/dom_distiller/content/common/mojom/distiller_javascript_service.mojom-forward.h"  // IWYU pragma: export
#include "components/dom_distiller/core/mojom/distilled_page_prefs.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace dom_distiller::mojom {

class DistillerJavaScriptServiceProxy;

template <typename ImplRefTraits>
class DistillerJavaScriptServiceStub;

class DistillerJavaScriptServiceRequestValidator;


class DistillerJavaScriptService
    : public DistillerJavaScriptServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "dom_distiller.mojom.DistillerJavaScriptService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DistillerJavaScriptServiceInterfaceBase;
  using Proxy_ = DistillerJavaScriptServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DistillerJavaScriptServiceStub<ImplRefTraits>;

  using RequestValidator_ = DistillerJavaScriptServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kHandleDistillerOpenSettingsCallMinVersion = 0,
    kHandleStoreThemePrefMinVersion = 0,
    kHandleStoreFontFamilyPrefMinVersion = 0,
    kHandleStoreFontScalingPrefMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct HandleDistillerOpenSettingsCall_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleStoreThemePref_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleStoreFontFamilyPref_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HandleStoreFontScalingPref_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DistillerJavaScriptService() = default;

  virtual void HandleDistillerOpenSettingsCall() = 0;

  virtual void HandleStoreThemePref(::dom_distiller::mojom::Theme theme) = 0;

  virtual void HandleStoreFontFamilyPref(::dom_distiller::mojom::FontFamily font_family) = 0;

  virtual void HandleStoreFontScalingPref(float font_scale) = 0;
};



class  DistillerJavaScriptServiceProxy
    : public DistillerJavaScriptService {
 public:
  using InterfaceType = DistillerJavaScriptService;

  explicit DistillerJavaScriptServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HandleDistillerOpenSettingsCall() final;
  
  void HandleStoreThemePref(::dom_distiller::mojom::Theme theme) final;
  
  void HandleStoreFontFamilyPref(::dom_distiller::mojom::FontFamily font_family) final;
  
  void HandleStoreFontScalingPref(float font_scale) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DistillerJavaScriptServiceStubDispatch {
 public:
  static bool Accept(DistillerJavaScriptService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DistillerJavaScriptService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DistillerJavaScriptService>>
class DistillerJavaScriptServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DistillerJavaScriptServiceStub() = default;
  ~DistillerJavaScriptServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DistillerJavaScriptServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DistillerJavaScriptServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DistillerJavaScriptServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // dom_distiller::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_DOM_DISTILLER_CONTENT_COMMON_MOJOM_DISTILLER_JAVASCRIPT_SERVICE_MOJOM_H_