// components/dom_distiller/content/common/mojom/distillability_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DOM_DISTILLER_CONTENT_COMMON_MOJOM_DISTILLABILITY_SERVICE_MOJOM_H_
#define COMPONENTS_DOM_DISTILLER_CONTENT_COMMON_MOJOM_DISTILLABILITY_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/dom_distiller/content/common/mojom/distillability_service.mojom-features.h"  // IWYU pragma: export
#include "components/dom_distiller/content/common/mojom/distillability_service.mojom-shared.h"  // IWYU pragma: export
#include "components/dom_distiller/content/common/mojom/distillability_service.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace dom_distiller::mojom {

class DistillabilityServiceProxy;

template <typename ImplRefTraits>
class DistillabilityServiceStub;

class DistillabilityServiceRequestValidator;


class DistillabilityService
    : public DistillabilityServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "dom_distiller.mojom.DistillabilityService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = DistillabilityServiceInterfaceBase;
  using Proxy_ = DistillabilityServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = DistillabilityServiceStub<ImplRefTraits>;

  using RequestValidator_ = DistillabilityServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kNotifyIsDistillableMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct NotifyIsDistillable_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~DistillabilityService() = default;

  virtual void NotifyIsDistillable(bool page_is_distillable, bool is_last_update, bool is_long_article, bool is_mobile_friendly) = 0;
};



class  DistillabilityServiceProxy
    : public DistillabilityService {
 public:
  using InterfaceType = DistillabilityService;

  explicit DistillabilityServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void NotifyIsDistillable(bool page_is_distillable, bool is_last_update, bool is_long_article, bool is_mobile_friendly) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  DistillabilityServiceStubDispatch {
 public:
  static bool Accept(DistillabilityService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      DistillabilityService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<DistillabilityService>>
class DistillabilityServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DistillabilityServiceStub() = default;
  ~DistillabilityServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DistillabilityServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DistillabilityServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  DistillabilityServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // dom_distiller::mojom

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_DOM_DISTILLER_CONTENT_COMMON_MOJOM_DISTILLABILITY_SERVICE_MOJOM_H_