// components/digital_goods/mojom/digital_goods.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_SHARED_H_
#define COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/digital_goods/mojom/digital_goods.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"




#include "components/digital_goods/mojom/digital_goods.mojom-data-view.h"




namespace std {

template <>
struct hash<::payments::mojom::BillingResponseCode>
    : public mojo::internal::EnumHashImpl<::payments::mojom::BillingResponseCode> {};

template <>
struct hash<::payments::mojom::ItemType>
    : public mojo::internal::EnumHashImpl<::payments::mojom::ItemType> {};

template <>
struct hash<::payments::mojom::CreateDigitalGoodsResponseCode>
    : public mojo::internal::EnumHashImpl<::payments::mojom::CreateDigitalGoodsResponseCode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::BillingResponseCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::BillingResponseCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::BillingResponseCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::ItemType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::ItemType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::ItemType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::CreateDigitalGoodsResponseCode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::payments::mojom::CreateDigitalGoodsResponseCode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::payments::mojom::CreateDigitalGoodsResponseCode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::ItemDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::ItemDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::ItemDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::item_id(input)) in_item_id = Traits::item_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->item_id)::BaseType> item_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_item_id,
      item_id_fragment);

    fragment->item_id.Set(
        item_id_fragment.is_null() ? nullptr : item_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->item_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_id in ItemDetails struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in ItemDetails struct");

    decltype(Traits::description(input)) in_description = Traits::description(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->description)::BaseType> description_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_description,
      description_fragment);

    fragment->description.Set(
        description_fragment.is_null() ? nullptr : description_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->description.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null description in ItemDetails struct");

    decltype(Traits::price(input)) in_price = Traits::price(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->price)::BaseType> price_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
      in_price,
      price_fragment);

    fragment->price.Set(
        price_fragment.is_null() ? nullptr : price_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->price.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null price in ItemDetails struct");

    decltype(Traits::subscription_period(input)) in_subscription_period = Traits::subscription_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->subscription_period)::BaseType> subscription_period_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_subscription_period,
      subscription_period_fragment);

    fragment->subscription_period.Set(
        subscription_period_fragment.is_null() ? nullptr : subscription_period_fragment.data());

    decltype(Traits::free_trial_period(input)) in_free_trial_period = Traits::free_trial_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->free_trial_period)::BaseType> free_trial_period_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_free_trial_period,
      free_trial_period_fragment);

    fragment->free_trial_period.Set(
        free_trial_period_fragment.is_null() ? nullptr : free_trial_period_fragment.data());

    decltype(Traits::introductory_price(input)) in_introductory_price = Traits::introductory_price(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->introductory_price)::BaseType> introductory_price_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::payments::mojom::PaymentCurrencyAmountDataView>(
      in_introductory_price,
      introductory_price_fragment);

    fragment->introductory_price.Set(
        introductory_price_fragment.is_null() ? nullptr : introductory_price_fragment.data());

    decltype(Traits::introductory_price_period(input)) in_introductory_price_period = Traits::introductory_price_period(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->introductory_price_period)::BaseType> introductory_price_period_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_introductory_price_period,
      introductory_price_period_fragment);

    fragment->introductory_price_period.Set(
        introductory_price_period_fragment.is_null() ? nullptr : introductory_price_period_fragment.data());

    fragment->introductory_price_cycles = Traits::introductory_price_cycles(input);

    
    mojo::internal::Serialize<::payments::mojom::ItemType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::icon_urls(input)) in_icon_urls = Traits::icon_urls(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->icon_urls)::BaseType>
        icon_urls_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& icon_urls_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
      in_icon_urls,
      icon_urls_fragment,
      &icon_urls_validate_params);

    fragment->icon_urls.Set(
        icon_urls_fragment.is_null() ? nullptr : icon_urls_fragment.data());
  }

  static bool Deserialize(::payments::mojom::internal::ItemDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::ItemDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::payments::mojom::PurchaseReferenceDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::payments::mojom::PurchaseReferenceDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::payments::mojom::internal::PurchaseReference_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::item_id(input)) in_item_id = Traits::item_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->item_id)::BaseType> item_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_item_id,
      item_id_fragment);

    fragment->item_id.Set(
        item_id_fragment.is_null() ? nullptr : item_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->item_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null item_id in PurchaseReference struct");

    decltype(Traits::purchase_token(input)) in_purchase_token = Traits::purchase_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->purchase_token)::BaseType> purchase_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_purchase_token,
      purchase_token_fragment);

    fragment->purchase_token.Set(
        purchase_token_fragment.is_null() ? nullptr : purchase_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->purchase_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null purchase_token in PurchaseReference struct");
  }

  static bool Deserialize(::payments::mojom::internal::PurchaseReference_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::payments::mojom::PurchaseReferenceDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace payments::mojom {

inline void ItemDetailsDataView::GetItemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->item_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetTitleDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->title.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetDescriptionDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->description.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetPriceDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->price.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetSubscriptionPeriodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->subscription_period.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetFreeTrialPeriodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->free_trial_period.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetIntroductoryPriceDataView(
    ::payments::mojom::PaymentCurrencyAmountDataView* output) {
  auto pointer = data_->introductory_price.Get();
  *output = ::payments::mojom::PaymentCurrencyAmountDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetIntroductoryPricePeriodDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->introductory_price_period.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ItemDetailsDataView::GetIconUrlsDataView(
    mojo::ArrayDataView<::url::mojom::UrlDataView>* output) {
  auto pointer = data_->header_.version >= 1
                 ? data_->icon_urls.Get() : nullptr;
  *output = mojo::ArrayDataView<::url::mojom::UrlDataView>(pointer, message_);
}


inline void PurchaseReferenceDataView::GetItemIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->item_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void PurchaseReferenceDataView::GetPurchaseTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->purchase_token.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // payments::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::payments::mojom::BillingResponseCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::BillingResponseCode value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::payments::mojom::ItemType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::ItemType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::payments::mojom::CreateDigitalGoodsResponseCode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::payments::mojom::CreateDigitalGoodsResponseCode value);
};

} // namespace perfetto

#endif  // COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_SHARED_H_