// components/digital_goods/mojom/digital_goods.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_DATA_VIEW_H_
#define COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "components/digital_goods/mojom/digital_goods.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "components/payments/mojom/payment_request_data.mojom-shared.h"


namespace payments::mojom {
class ItemDetailsDataView;

class PurchaseReferenceDataView;



}  // payments::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::payments::mojom::ItemDetailsDataView> {
  using Data = ::payments::mojom::internal::ItemDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::payments::mojom::PurchaseReferenceDataView> {
  using Data = ::payments::mojom::internal::PurchaseReference_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace payments::mojom {


enum class BillingResponseCode : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kItemAlreadyOwned = 2,
  
  kItemNotOwned = 3,
  
  kItemUnavailable = 4,
  
  kClientAppUnavailable = 5,
  
  kClientAppError = 6,
  kMinValue = 0,
  kMaxValue = 6,
  kDefaultValue = 1
};

 std::ostream& operator<<(std::ostream& os, BillingResponseCode value);
inline bool IsKnownEnumValue(BillingResponseCode value) {
  return internal::BillingResponseCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline BillingResponseCode ToKnownEnumValue(BillingResponseCode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return BillingResponseCode::kDefaultValue;
}


enum class ItemType : int32_t {
  
  kUnknown = 0,
  
  kProduct = 1,
  
  kSubscription = 2,
  kMinValue = 0,
  kMaxValue = 2,
  kDefaultValue = 0
};

 std::ostream& operator<<(std::ostream& os, ItemType value);
inline bool IsKnownEnumValue(ItemType value) {
  return internal::ItemType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline ItemType ToKnownEnumValue(ItemType value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return ItemType::kDefaultValue;
}


enum class CreateDigitalGoodsResponseCode : int32_t {
  
  kOk = 0,
  
  kError = 1,
  
  kUnsupportedPaymentMethod = 2,
  
  kUnsupportedContext = 3,
  kMinValue = 0,
  kMaxValue = 3,
  kDefaultValue = 1
};

 std::ostream& operator<<(std::ostream& os, CreateDigitalGoodsResponseCode value);
inline bool IsKnownEnumValue(CreateDigitalGoodsResponseCode value) {
  return internal::CreateDigitalGoodsResponseCode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
inline CreateDigitalGoodsResponseCode ToKnownEnumValue(CreateDigitalGoodsResponseCode value) {
  if (IsKnownEnumValue(value)) {
    return value;
  }
  return CreateDigitalGoodsResponseCode::kDefaultValue;
}


class ItemDetailsDataView {
 public:
  ItemDetailsDataView() = default;

  ItemDetailsDataView(
      internal::ItemDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItemId(UserType* output) {
    
    auto* pointer = data_->item_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDescriptionDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDescription(UserType* output) {
    
    auto* pointer = data_->description.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPriceDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPrice(UserType* output) {
    
    auto* pointer = data_->price.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetSubscriptionPeriodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSubscriptionPeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `subscription_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSubscriptionPeriod` instead "
    "of `ReadSubscriptionPeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->subscription_period.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetFreeTrialPeriodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFreeTrialPeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `free_trial_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadFreeTrialPeriod` instead "
    "of `ReadFreeTrialPeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->free_trial_period.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIntroductoryPriceDataView(
      ::payments::mojom::PaymentCurrencyAmountDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntroductoryPrice(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::payments::mojom::PaymentCurrencyAmountDataView, UserType>(),
    "Attempting to read the optional `introductory_price` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntroductoryPrice` instead "
    "of `ReadIntroductoryPrice if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->introductory_price.Get();
    return mojo::internal::Deserialize<::payments::mojom::PaymentCurrencyAmountDataView>(
        pointer, output, message_);
  }
  inline void GetIntroductoryPricePeriodDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntroductoryPricePeriod(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `introductory_price_period` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntroductoryPricePeriod` instead "
    "of `ReadIntroductoryPricePeriod if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->introductory_price_period.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  uint32_t introductory_price_cycles() const {
    if (data_->header_.version < 1)
      return uint32_t{};
    return data_->introductory_price_cycles;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->header_.version >= 1
                      ? data_->type : 0;
    return mojo::internal::Deserialize<::payments::mojom::ItemType>(
        data_value, output);
  }
  ItemType type() const {
    if (data_->header_.version < 1)
      return ItemType{};
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::payments::mojom::ItemType>(data_->type));
  }
  inline void GetIconUrlsDataView(
      mojo::ArrayDataView<::url::mojom::UrlDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIconUrls(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<::url::mojom::UrlDataView>, UserType>(),
    "Attempting to read the optional `icon_urls` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIconUrls` instead "
    "of `ReadIconUrls if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->header_.version >= 1
                    ? data_->icon_urls.Get() : nullptr;
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::UrlDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ItemDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PurchaseReferenceDataView {
 public:
  PurchaseReferenceDataView() = default;

  PurchaseReferenceDataView(
      internal::PurchaseReference_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetItemIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadItemId(UserType* output) {
    
    auto* pointer = data_->item_id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetPurchaseTokenDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPurchaseToken(UserType* output) {
    
    auto* pointer = data_->purchase_token.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PurchaseReference_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // payments::mojom

#endif  // COMPONENTS_DIGITAL_GOODS_MOJOM_DIGITAL_GOODS_MOJOM_DATA_VIEW_H_