// components/device_signals/core/common/mojom/system_signals.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/device_signals/core/common/mojom/system_signals.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/device_signals/core/common/mojom/system_signals.mojom-params-data.h"
namespace device_signals {
namespace mojom {

NOINLINE static const char* PresenceValueToStringHelper(PresenceValue value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case PresenceValue::kUnspecified:
      return "kUnspecified";
    case PresenceValue::kAccessDenied:
      return "kAccessDenied";
    case PresenceValue::kNotFound:
      return "kNotFound";
    case PresenceValue::kFound:
      return "kFound";
    default:
      return nullptr;
  }
}

std::string PresenceValueToString(PresenceValue value) {
  const char *str = PresenceValueToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown PresenceValue value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, PresenceValue value) {
  return os << PresenceValueToString(value);
}

namespace internal {


// static
bool ExecutableMetadata_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ExecutableMetadata_Data* object =
      static_cast<const ExecutableMetadata_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& public_keys_hashes_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->public_keys_hashes, validation_context,
                                         &public_keys_hashes_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& product_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->product_name, validation_context,
                                         &product_name_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& version_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->version, validation_context,
                                         &version_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& subject_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->subject_name, validation_context,
                                         &subject_name_validate_params)) {
    return false;
  }

  return true;
}

ExecutableMetadata_Data::ExecutableMetadata_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemItem_Data* object =
      static_cast<const FileSystemItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;


  if (!::device_signals::mojom::internal::PresenceValue_Data
        ::Validate(object->presence, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->sha256_hash, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->executable_metadata, validation_context))
    return false;

  return true;
}

FileSystemItem_Data::FileSystemItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool FileSystemItemRequest_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const FileSystemItemRequest_Data* object =
      static_cast<const FileSystemItemRequest_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file_path, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file_path, validation_context))
    return false;

  return true;
}

FileSystemItemRequest_Data::FileSystemItemRequest_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemSignalsService_GetFileSystemSignals_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemSignalsService_GetFileSystemSignals_Params_Data* object =
      static_cast<const SystemSignalsService_GetFileSystemSignals_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->requests, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& requests_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->requests, validation_context,
                                         &requests_validate_params)) {
    return false;
  }

  return true;
}

SystemSignalsService_GetFileSystemSignals_Params_Data::SystemSignalsService_GetFileSystemSignals_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SystemSignalsService_GetFileSystemSignals_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SystemSignalsService_GetFileSystemSignals_ResponseParams_Data* object =
      static_cast<const SystemSignalsService_GetFileSystemSignals_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

SystemSignalsService_GetFileSystemSignals_ResponseParams_Data::SystemSignalsService_GetFileSystemSignals_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device_signals

namespace perfetto {

// static
void TraceFormatTraits<::device_signals::mojom::PresenceValue>::WriteIntoTrace(
   perfetto::TracedValue context, ::device_signals::mojom::PresenceValue value) {
  return std::move(context).WriteString(::device_signals::mojom::PresenceValueToString(value));
}

} // namespace perfetto