// components/device_signals/core/common/mojom/system_signals.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "sandbox/policy/mojom/context.mojom-shared-internal.h"
#include "sandbox/policy/mojom/sandbox.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared-internal.h"
#include "mojo/public/mojom/base/file_path.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace device_signals::mojom {
namespace internal {
class ExecutableMetadata_Data;
class FileSystemItem_Data;
class FileSystemItemRequest_Data;

struct PresenceValue_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  ExecutableMetadata_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t is_running : 1;
  uint8_t is_os_verified : 1;
  uint8_t pad1_[7];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data>>> public_keys_hashes;
  mojo::internal::Pointer<mojo::internal::String_Data> product_name;
  mojo::internal::Pointer<mojo::internal::String_Data> version;
  mojo::internal::Pointer<mojo::internal::String_Data> subject_name;

 private:
  friend class mojo::internal::MessageFragment<ExecutableMetadata_Data>;

  ExecutableMetadata_Data();
  ~ExecutableMetadata_Data() = delete;
};
static_assert(sizeof(ExecutableMetadata_Data) == 48,
              "Bad sizeof(ExecutableMetadata_Data)");
// Used by ExecutableMetadata::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ExecutableMetadata_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ExecutableMetadata_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ExecutableMetadata_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ExecutableMetadata_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ExecutableMetadata_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  FileSystemItem_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> file_path;
  int32_t presence;
  uint8_t pad1_[4];
  mojo::internal::Pointer<::mojo_base::mojom::internal::ByteString_Data> sha256_hash;
  mojo::internal::Pointer<internal::ExecutableMetadata_Data> executable_metadata;

 private:
  friend class mojo::internal::MessageFragment<FileSystemItem_Data>;

  FileSystemItem_Data();
  ~FileSystemItem_Data() = delete;
};
static_assert(sizeof(FileSystemItem_Data) == 40,
              "Bad sizeof(FileSystemItem_Data)");
// Used by FileSystemItem::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FileSystemItem_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FileSystemItem_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FileSystemItem_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<FileSystemItem_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FileSystemItem_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  FileSystemItemRequest_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::FilePath_Data> file_path;
  uint8_t compute_sha256 : 1;
  uint8_t compute_executable_metadata : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<FileSystemItemRequest_Data>;

  FileSystemItemRequest_Data();
  ~FileSystemItemRequest_Data() = delete;
};
static_assert(sizeof(FileSystemItemRequest_Data) == 24,
              "Bad sizeof(FileSystemItemRequest_Data)");
// Used by FileSystemItemRequest::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct FileSystemItemRequest_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  FileSystemItemRequest_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~FileSystemItemRequest_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<FileSystemItemRequest_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    FileSystemItemRequest_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // device_signals::mojom

#endif  // COMPONENTS_DEVICE_SIGNALS_CORE_COMMON_MOJOM_SYSTEM_SIGNALS_MOJOM_SHARED_INTERNAL_H_