// components/data_sharing/public/protocol/group_data.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_H_
#define COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/data_sharing/public/protocol/group_data.mojom-features.h"  // IWYU pragma: export
#include "components/data_sharing/public/protocol/group_data.mojom-shared.h"  // IWYU pragma: export
#include "components/data_sharing/public/protocol/group_data.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>








namespace data_sharing::mojom {









class  GroupMember {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GroupMember, T>::value>;
  using DataView = GroupMemberDataView;
  using Data_ = internal::GroupMember_Data;

  template <typename... Args>
  static GroupMemberPtr New(Args&&... args) {
    return GroupMemberPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GroupMemberPtr From(const U& u) {
    return mojo::TypeConverter<GroupMemberPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GroupMember>::Convert(*this);
  }


  GroupMember();

  GroupMember(
      const std::string& gaia_id,
      const std::string& display_name,
      const std::string& email,
      MemberRole role,
      const ::GURL& avatar_url,
      const std::string& given_name,
      ::base::Time creation_time,
      ::base::Time last_updated_time);


  ~GroupMember();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GroupMemberPtr>
  GroupMemberPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GroupMember::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GroupMember::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GroupMember::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupMember::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupMember::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GroupMember::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GroupMember_UnserializedMessageContext<
            UserType, GroupMember::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GroupMember::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GroupMember::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GroupMember_UnserializedMessageContext<
            UserType, GroupMember::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GroupMember::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string gaia_id;
  
  std::string display_name;
  
  std::string email;
  
  MemberRole role;
  
  ::GURL avatar_url;
  
  std::string given_name;
  
  ::base::Time creation_time;
  
  ::base::Time last_updated_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GroupMember::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GroupMember::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GroupMember::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GroupMember::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  GroupData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<GroupData, T>::value>;
  using DataView = GroupDataDataView;
  using Data_ = internal::GroupData_Data;

  template <typename... Args>
  static GroupDataPtr New(Args&&... args) {
    return GroupDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static GroupDataPtr From(const U& u) {
    return mojo::TypeConverter<GroupDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, GroupData>::Convert(*this);
  }


  GroupData();

  GroupData(
      const std::string& group_id,
      const std::string& display_name,
      std::vector<GroupMemberPtr> members,
      std::vector<GroupMemberPtr> former_members,
      const std::string& access_token);

GroupData(const GroupData&) = delete;
GroupData& operator=(const GroupData&) = delete;

  ~GroupData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = GroupDataPtr>
  GroupDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, GroupData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, GroupData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, GroupData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        GroupData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        GroupData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::GroupData_UnserializedMessageContext<
            UserType, GroupData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<GroupData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return GroupData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::GroupData_UnserializedMessageContext<
            UserType, GroupData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<GroupData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string group_id;
  
  std::string display_name;
  
  std::vector<GroupMemberPtr> members;
  
  std::vector<GroupMemberPtr> former_members;
  
  std::string access_token;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, GroupData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, GroupData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, GroupData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, GroupData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
GroupMemberPtr GroupMember::Clone() const {
  return New(
      mojo::Clone(gaia_id),
      mojo::Clone(display_name),
      mojo::Clone(email),
      mojo::Clone(role),
      mojo::Clone(avatar_url),
      mojo::Clone(given_name),
      mojo::Clone(creation_time),
      mojo::Clone(last_updated_time)
  );
}

template <typename T, GroupMember::EnableIfSame<T>*>
bool GroupMember::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->gaia_id, other_struct.gaia_id))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->email, other_struct.email))
    return false;
  if (!mojo::Equals(this->role, other_struct.role))
    return false;
  if (!mojo::Equals(this->avatar_url, other_struct.avatar_url))
    return false;
  if (!mojo::Equals(this->given_name, other_struct.given_name))
    return false;
  if (!mojo::Equals(this->creation_time, other_struct.creation_time))
    return false;
  if (!mojo::Equals(this->last_updated_time, other_struct.last_updated_time))
    return false;
  return true;
}

template <typename T, GroupMember::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.gaia_id < rhs.gaia_id)
    return true;
  if (rhs.gaia_id < lhs.gaia_id)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.email < rhs.email)
    return true;
  if (rhs.email < lhs.email)
    return false;
  if (lhs.role < rhs.role)
    return true;
  if (rhs.role < lhs.role)
    return false;
  if (lhs.avatar_url < rhs.avatar_url)
    return true;
  if (rhs.avatar_url < lhs.avatar_url)
    return false;
  if (lhs.given_name < rhs.given_name)
    return true;
  if (rhs.given_name < lhs.given_name)
    return false;
  if (lhs.creation_time < rhs.creation_time)
    return true;
  if (rhs.creation_time < lhs.creation_time)
    return false;
  if (lhs.last_updated_time < rhs.last_updated_time)
    return true;
  if (rhs.last_updated_time < lhs.last_updated_time)
    return false;
  return false;
}
template <typename StructPtrType>
GroupDataPtr GroupData::Clone() const {
  return New(
      mojo::Clone(group_id),
      mojo::Clone(display_name),
      mojo::Clone(members),
      mojo::Clone(former_members),
      mojo::Clone(access_token)
  );
}

template <typename T, GroupData::EnableIfSame<T>*>
bool GroupData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->group_id, other_struct.group_id))
    return false;
  if (!mojo::Equals(this->display_name, other_struct.display_name))
    return false;
  if (!mojo::Equals(this->members, other_struct.members))
    return false;
  if (!mojo::Equals(this->former_members, other_struct.former_members))
    return false;
  if (!mojo::Equals(this->access_token, other_struct.access_token))
    return false;
  return true;
}

template <typename T, GroupData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.group_id < rhs.group_id)
    return true;
  if (rhs.group_id < lhs.group_id)
    return false;
  if (lhs.display_name < rhs.display_name)
    return true;
  if (rhs.display_name < lhs.display_name)
    return false;
  if (lhs.members < rhs.members)
    return true;
  if (rhs.members < lhs.members)
    return false;
  if (lhs.former_members < rhs.former_members)
    return true;
  if (rhs.former_members < lhs.former_members)
    return false;
  if (lhs.access_token < rhs.access_token)
    return true;
  if (rhs.access_token < lhs.access_token)
    return false;
  return false;
}


}  // data_sharing::mojom

namespace mojo {


template <>
struct  StructTraits<::data_sharing::mojom::GroupMember::DataView,
                                         ::data_sharing::mojom::GroupMemberPtr> {
  static bool IsNull(const ::data_sharing::mojom::GroupMemberPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::GroupMemberPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::GroupMember::gaia_id)& gaia_id(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->gaia_id;
  }

  static const decltype(::data_sharing::mojom::GroupMember::display_name)& display_name(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->display_name;
  }

  static const decltype(::data_sharing::mojom::GroupMember::email)& email(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->email;
  }

  static decltype(::data_sharing::mojom::GroupMember::role) role(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->role;
  }

  static const decltype(::data_sharing::mojom::GroupMember::avatar_url)& avatar_url(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->avatar_url;
  }

  static const decltype(::data_sharing::mojom::GroupMember::given_name)& given_name(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->given_name;
  }

  static const decltype(::data_sharing::mojom::GroupMember::creation_time)& creation_time(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->creation_time;
  }

  static const decltype(::data_sharing::mojom::GroupMember::last_updated_time)& last_updated_time(
      const ::data_sharing::mojom::GroupMemberPtr& input) {
    return input->last_updated_time;
  }

  static bool Read(::data_sharing::mojom::GroupMember::DataView input, ::data_sharing::mojom::GroupMemberPtr* output);
};


template <>
struct  StructTraits<::data_sharing::mojom::GroupData::DataView,
                                         ::data_sharing::mojom::GroupDataPtr> {
  static bool IsNull(const ::data_sharing::mojom::GroupDataPtr& input) { return !input; }
  static void SetToNull(::data_sharing::mojom::GroupDataPtr* output) { output->reset(); }

  static const decltype(::data_sharing::mojom::GroupData::group_id)& group_id(
      const ::data_sharing::mojom::GroupDataPtr& input) {
    return input->group_id;
  }

  static const decltype(::data_sharing::mojom::GroupData::display_name)& display_name(
      const ::data_sharing::mojom::GroupDataPtr& input) {
    return input->display_name;
  }

  static const decltype(::data_sharing::mojom::GroupData::members)& members(
      const ::data_sharing::mojom::GroupDataPtr& input) {
    return input->members;
  }

  static const decltype(::data_sharing::mojom::GroupData::former_members)& former_members(
      const ::data_sharing::mojom::GroupDataPtr& input) {
    return input->former_members;
  }

  static const decltype(::data_sharing::mojom::GroupData::access_token)& access_token(
      const ::data_sharing::mojom::GroupDataPtr& input) {
    return input->access_token;
  }

  static bool Read(::data_sharing::mojom::GroupData::DataView input, ::data_sharing::mojom::GroupDataPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_H_