// components/data_sharing/public/protocol/group_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_SHARED_H_
#define COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/data_sharing/public/protocol/group_data.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"




#include "components/data_sharing/public/protocol/group_data.mojom-data-view.h"




namespace std {

template <>
struct hash<::data_sharing::mojom::MemberRole>
    : public mojo::internal::EnumHashImpl<::data_sharing::mojom::MemberRole> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::MemberRole, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::data_sharing::mojom::MemberRole, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::data_sharing::mojom::MemberRole>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::GroupMemberDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::GroupMemberDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::GroupMember_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::gaia_id(input)) in_gaia_id = Traits::gaia_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->gaia_id)::BaseType> gaia_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_gaia_id,
      gaia_id_fragment);

    fragment->gaia_id.Set(
        gaia_id_fragment.is_null() ? nullptr : gaia_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->gaia_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null gaia_id in GroupMember struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in GroupMember struct");

    decltype(Traits::email(input)) in_email = Traits::email(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->email)::BaseType> email_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_email,
      email_fragment);

    fragment->email.Set(
        email_fragment.is_null() ? nullptr : email_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->email.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null email in GroupMember struct");

    
    mojo::internal::Serialize<::data_sharing::mojom::MemberRole>(
      Traits::role(input),
      &fragment->role);

    decltype(Traits::avatar_url(input)) in_avatar_url = Traits::avatar_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->avatar_url)::BaseType> avatar_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_avatar_url,
      avatar_url_fragment);

    fragment->avatar_url.Set(
        avatar_url_fragment.is_null() ? nullptr : avatar_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->avatar_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null avatar_url in GroupMember struct");

    decltype(Traits::given_name(input)) in_given_name = Traits::given_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->given_name)::BaseType> given_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_given_name,
      given_name_fragment);

    fragment->given_name.Set(
        given_name_fragment.is_null() ? nullptr : given_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->given_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null given_name in GroupMember struct");

    decltype(Traits::creation_time(input)) in_creation_time = Traits::creation_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->creation_time)::BaseType> creation_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::JSTimeDataView>(
      in_creation_time,
      creation_time_fragment);

    fragment->creation_time.Set(
        creation_time_fragment.is_null() ? nullptr : creation_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->creation_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null creation_time in GroupMember struct");

    decltype(Traits::last_updated_time(input)) in_last_updated_time = Traits::last_updated_time(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->last_updated_time)::BaseType> last_updated_time_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::JSTimeDataView>(
      in_last_updated_time,
      last_updated_time_fragment);

    fragment->last_updated_time.Set(
        last_updated_time_fragment.is_null() ? nullptr : last_updated_time_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->last_updated_time.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null last_updated_time in GroupMember struct");
  }

  static bool Deserialize(::data_sharing::mojom::internal::GroupMember_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::GroupMemberDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::data_sharing::mojom::GroupDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::data_sharing::mojom::GroupDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::data_sharing::mojom::internal::GroupData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::group_id(input)) in_group_id = Traits::group_id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->group_id)::BaseType> group_id_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_group_id,
      group_id_fragment);

    fragment->group_id.Set(
        group_id_fragment.is_null() ? nullptr : group_id_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->group_id.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group_id in GroupData struct");

    decltype(Traits::display_name(input)) in_display_name = Traits::display_name(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->display_name)::BaseType> display_name_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_display_name,
      display_name_fragment);

    fragment->display_name.Set(
        display_name_fragment.is_null() ? nullptr : display_name_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->display_name.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null display_name in GroupData struct");

    decltype(Traits::members(input)) in_members = Traits::members(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->members)::BaseType>
        members_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& members_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::GroupMemberDataView>>(
      in_members,
      members_fragment,
      &members_validate_params);

    fragment->members.Set(
        members_fragment.is_null() ? nullptr : members_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->members.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null members in GroupData struct");

    decltype(Traits::former_members(input)) in_former_members = Traits::former_members(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->former_members)::BaseType>
        former_members_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& former_members_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::data_sharing::mojom::GroupMemberDataView>>(
      in_former_members,
      former_members_fragment,
      &former_members_validate_params);

    fragment->former_members.Set(
        former_members_fragment.is_null() ? nullptr : former_members_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->former_members.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null former_members in GroupData struct");

    decltype(Traits::access_token(input)) in_access_token = Traits::access_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->access_token)::BaseType> access_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_access_token,
      access_token_fragment);

    fragment->access_token.Set(
        access_token_fragment.is_null() ? nullptr : access_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->access_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null access_token in GroupData struct");
  }

  static bool Deserialize(::data_sharing::mojom::internal::GroupData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::data_sharing::mojom::GroupDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace data_sharing::mojom {

inline void GroupMemberDataView::GetGaiaIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->gaia_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GroupMemberDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GroupMemberDataView::GetEmailDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->email.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GroupMemberDataView::GetAvatarUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->avatar_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void GroupMemberDataView::GetGivenNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->given_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GroupMemberDataView::GetCreationTimeDataView(
    ::mojo_base::mojom::JSTimeDataView* output) {
  auto pointer = data_->creation_time.Get();
  *output = ::mojo_base::mojom::JSTimeDataView(pointer, message_);
}
inline void GroupMemberDataView::GetLastUpdatedTimeDataView(
    ::mojo_base::mojom::JSTimeDataView* output) {
  auto pointer = data_->last_updated_time.Get();
  *output = ::mojo_base::mojom::JSTimeDataView(pointer, message_);
}


inline void GroupDataDataView::GetGroupIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->group_id.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GroupDataDataView::GetDisplayNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->display_name.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void GroupDataDataView::GetMembersDataView(
    mojo::ArrayDataView<GroupMemberDataView>* output) {
  auto pointer = data_->members.Get();
  *output = mojo::ArrayDataView<GroupMemberDataView>(pointer, message_);
}
inline void GroupDataDataView::GetFormerMembersDataView(
    mojo::ArrayDataView<GroupMemberDataView>* output) {
  auto pointer = data_->former_members.Get();
  *output = mojo::ArrayDataView<GroupMemberDataView>(pointer, message_);
}
inline void GroupDataDataView::GetAccessTokenDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->access_token.Get();
  *output = mojo::StringDataView(pointer, message_);
}



}  // data_sharing::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::data_sharing::mojom::MemberRole> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::data_sharing::mojom::MemberRole value);
};

} // namespace perfetto

#endif  // COMPONENTS_DATA_SHARING_PUBLIC_PROTOCOL_GROUP_DATA_MOJOM_SHARED_H_