// components/data_sharing/public/protocol/group_data.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/data_sharing/public/protocol/group_data.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/data_sharing/public/protocol/group_data.mojom-params-data.h"
namespace data_sharing {
namespace mojom {

NOINLINE static const char* MemberRoleToStringHelper(MemberRole value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case MemberRole::kUnspecified:
      return "kUnspecified";
    case MemberRole::kOwner:
      return "kOwner";
    case MemberRole::kMember:
      return "kMember";
    case MemberRole::kInvitee:
      return "kInvitee";
    case MemberRole::kFormerMember:
      return "kFormerMember";
    default:
      return nullptr;
  }
}

std::string MemberRoleToString(MemberRole value) {
  const char *str = MemberRoleToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown MemberRole value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, MemberRole value) {
  return os << MemberRoleToString(value);
}

namespace internal {


// static
bool GroupMember_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 72, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GroupMember_Data* object =
      static_cast<const GroupMember_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gaia_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gaia_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gaia_id, validation_context,
                                         &gaia_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->email, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& email_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->email, validation_context,
                                         &email_validate_params)) {
    return false;
  }


  if (!::data_sharing::mojom::internal::MemberRole_Data
        ::Validate(object->role, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->avatar_url, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->avatar_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->given_name, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& given_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->given_name, validation_context,
                                         &given_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->creation_time, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->creation_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->last_updated_time, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->last_updated_time, validation_context))
    return false;

  return true;
}

GroupMember_Data::GroupMember_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool GroupData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const GroupData_Data* object =
      static_cast<const GroupData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->group_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& group_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->group_id, validation_context,
                                         &group_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& display_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->display_name, validation_context,
                                         &display_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->members, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& members_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->members, validation_context,
                                         &members_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->former_members, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& former_members_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->former_members, validation_context,
                                         &former_members_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->access_token, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& access_token_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->access_token, validation_context,
                                         &access_token_validate_params)) {
    return false;
  }

  return true;
}

GroupData_Data::GroupData_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace data_sharing

namespace perfetto {

// static
void TraceFormatTraits<::data_sharing::mojom::MemberRole>::WriteIntoTrace(
   perfetto::TracedValue context, ::data_sharing::mojom::MemberRole value) {
  return std::move(context).WriteString(::data_sharing::mojom::MemberRoleToString(value));
}

} // namespace perfetto