// components/continuous_search/common/public/mojom/continuous_search.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_H_
#define COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/continuous_search/common/public/mojom/continuous_search.mojom-features.h"  // IWYU pragma: export
#include "components/continuous_search/common/public/mojom/continuous_search.mojom-shared.h"  // IWYU pragma: export
#include "components/continuous_search/common/public/mojom/continuous_search.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace continuous_search::mojom {

class SearchResultExtractorProxy;

template <typename ImplRefTraits>
class SearchResultExtractorStub;

class SearchResultExtractorRequestValidator;
class SearchResultExtractorResponseValidator;


class SearchResultExtractor
    : public SearchResultExtractorInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "continuous_search.mojom.SearchResultExtractor";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SearchResultExtractorInterfaceBase;
  using Proxy_ = SearchResultExtractorProxy;

  template <typename ImplRefTraits>
  using Stub_ = SearchResultExtractorStub<ImplRefTraits>;

  using RequestValidator_ = SearchResultExtractorRequestValidator;
  using ResponseValidator_ = SearchResultExtractorResponseValidator;
  enum MethodMinVersions : uint32_t {
    kExtractCurrentSearchResultsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct ExtractCurrentSearchResults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  
  using Status = SearchResultExtractor_Status;
  virtual ~SearchResultExtractor() = default;

  using ExtractCurrentSearchResultsCallback = base::OnceCallback<void(SearchResultExtractor::Status, CategoryResultsPtr)>;
  using ExtractCurrentSearchResultsMojoCallback = base::OnceCallback<void(SearchResultExtractor::Status, CategoryResultsPtr)>;

  virtual void ExtractCurrentSearchResults(const std::vector<ResultType>& result_types, ExtractCurrentSearchResultsCallback callback) = 0;
};



class  SearchResultExtractorProxy
    : public SearchResultExtractor {
 public:
  using InterfaceType = SearchResultExtractor;

  explicit SearchResultExtractorProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ExtractCurrentSearchResults(const std::vector<ResultType>& result_types, ExtractCurrentSearchResultsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  SearchResultExtractorStubDispatch {
 public:
  static bool Accept(SearchResultExtractor* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SearchResultExtractor* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SearchResultExtractor>>
class SearchResultExtractorStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SearchResultExtractorStub() = default;
  ~SearchResultExtractorStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SearchResultExtractorStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SearchResultExtractorStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SearchResultExtractorRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SearchResultExtractorResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  SearchResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchResult, T>::value>;
  using DataView = SearchResultDataView;
  using Data_ = internal::SearchResult_Data;

  template <typename... Args>
  static SearchResultPtr New(Args&&... args) {
    return SearchResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchResultPtr From(const U& u) {
    return mojo::TypeConverter<SearchResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchResult>::Convert(*this);
  }


  SearchResult();

  SearchResult(
      const ::GURL& link,
      const ::std::u16string& title);


  ~SearchResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchResultPtr>
  SearchResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchResult_UnserializedMessageContext<
            UserType, SearchResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchResult_UnserializedMessageContext<
            UserType, SearchResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL link;
  
  ::std::u16string title;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ResultGroup {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ResultGroup, T>::value>;
  using DataView = ResultGroupDataView;
  using Data_ = internal::ResultGroup_Data;

  template <typename... Args>
  static ResultGroupPtr New(Args&&... args) {
    return ResultGroupPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ResultGroupPtr From(const U& u) {
    return mojo::TypeConverter<ResultGroupPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ResultGroup>::Convert(*this);
  }


  ResultGroup();

  ResultGroup(
      ResultType type,
      std::vector<SearchResultPtr> results);

ResultGroup(const ResultGroup&) = delete;
ResultGroup& operator=(const ResultGroup&) = delete;

  ~ResultGroup();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ResultGroupPtr>
  ResultGroupPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ResultGroup::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ResultGroup::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ResultGroup::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResultGroup::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ResultGroup::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ResultGroup::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ResultGroup_UnserializedMessageContext<
            UserType, ResultGroup::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ResultGroup::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ResultGroup::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ResultGroup_UnserializedMessageContext<
            UserType, ResultGroup::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ResultGroup::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ResultType type;
  
  std::vector<SearchResultPtr> results;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ResultGroup::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ResultGroup::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ResultGroup::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ResultGroup::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  CategoryResults {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CategoryResults, T>::value>;
  using DataView = CategoryResultsDataView;
  using Data_ = internal::CategoryResults_Data;

  template <typename... Args>
  static CategoryResultsPtr New(Args&&... args) {
    return CategoryResultsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CategoryResultsPtr From(const U& u) {
    return mojo::TypeConverter<CategoryResultsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CategoryResults>::Convert(*this);
  }


  CategoryResults();

  CategoryResults(
      const ::GURL& document_url,
      Category category_type,
      std::vector<ResultGroupPtr> groups);

CategoryResults(const CategoryResults&) = delete;
CategoryResults& operator=(const CategoryResults&) = delete;

  ~CategoryResults();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CategoryResultsPtr>
  CategoryResultsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CategoryResults::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, CategoryResults::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, CategoryResults::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CategoryResults::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CategoryResults::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CategoryResults::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CategoryResults_UnserializedMessageContext<
            UserType, CategoryResults::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<CategoryResults::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return CategoryResults::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CategoryResults_UnserializedMessageContext<
            UserType, CategoryResults::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CategoryResults::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::GURL document_url;
  
  Category category_type;
  
  std::vector<ResultGroupPtr> groups;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CategoryResults::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CategoryResults::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CategoryResults::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CategoryResults::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SearchResultPtr SearchResult::Clone() const {
  return New(
      mojo::Clone(link),
      mojo::Clone(title)
  );
}

template <typename T, SearchResult::EnableIfSame<T>*>
bool SearchResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->link, other_struct.link))
    return false;
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  return true;
}

template <typename T, SearchResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.link < rhs.link)
    return true;
  if (rhs.link < lhs.link)
    return false;
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  return false;
}
template <typename StructPtrType>
ResultGroupPtr ResultGroup::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(results)
  );
}

template <typename T, ResultGroup::EnableIfSame<T>*>
bool ResultGroup::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->results, other_struct.results))
    return false;
  return true;
}

template <typename T, ResultGroup::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.results < rhs.results)
    return true;
  if (rhs.results < lhs.results)
    return false;
  return false;
}
template <typename StructPtrType>
CategoryResultsPtr CategoryResults::Clone() const {
  return New(
      mojo::Clone(document_url),
      mojo::Clone(category_type),
      mojo::Clone(groups)
  );
}

template <typename T, CategoryResults::EnableIfSame<T>*>
bool CategoryResults::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->document_url, other_struct.document_url))
    return false;
  if (!mojo::Equals(this->category_type, other_struct.category_type))
    return false;
  if (!mojo::Equals(this->groups, other_struct.groups))
    return false;
  return true;
}

template <typename T, CategoryResults::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.document_url < rhs.document_url)
    return true;
  if (rhs.document_url < lhs.document_url)
    return false;
  if (lhs.category_type < rhs.category_type)
    return true;
  if (rhs.category_type < lhs.category_type)
    return false;
  if (lhs.groups < rhs.groups)
    return true;
  if (rhs.groups < lhs.groups)
    return false;
  return false;
}


}  // continuous_search::mojom

namespace mojo {


template <>
struct  StructTraits<::continuous_search::mojom::SearchResult::DataView,
                                         ::continuous_search::mojom::SearchResultPtr> {
  static bool IsNull(const ::continuous_search::mojom::SearchResultPtr& input) { return !input; }
  static void SetToNull(::continuous_search::mojom::SearchResultPtr* output) { output->reset(); }

  static const decltype(::continuous_search::mojom::SearchResult::link)& link(
      const ::continuous_search::mojom::SearchResultPtr& input) {
    return input->link;
  }

  static const decltype(::continuous_search::mojom::SearchResult::title)& title(
      const ::continuous_search::mojom::SearchResultPtr& input) {
    return input->title;
  }

  static bool Read(::continuous_search::mojom::SearchResult::DataView input, ::continuous_search::mojom::SearchResultPtr* output);
};


template <>
struct  StructTraits<::continuous_search::mojom::ResultGroup::DataView,
                                         ::continuous_search::mojom::ResultGroupPtr> {
  static bool IsNull(const ::continuous_search::mojom::ResultGroupPtr& input) { return !input; }
  static void SetToNull(::continuous_search::mojom::ResultGroupPtr* output) { output->reset(); }

  static decltype(::continuous_search::mojom::ResultGroup::type) type(
      const ::continuous_search::mojom::ResultGroupPtr& input) {
    return input->type;
  }

  static const decltype(::continuous_search::mojom::ResultGroup::results)& results(
      const ::continuous_search::mojom::ResultGroupPtr& input) {
    return input->results;
  }

  static bool Read(::continuous_search::mojom::ResultGroup::DataView input, ::continuous_search::mojom::ResultGroupPtr* output);
};


template <>
struct  StructTraits<::continuous_search::mojom::CategoryResults::DataView,
                                         ::continuous_search::mojom::CategoryResultsPtr> {
  static bool IsNull(const ::continuous_search::mojom::CategoryResultsPtr& input) { return !input; }
  static void SetToNull(::continuous_search::mojom::CategoryResultsPtr* output) { output->reset(); }

  static const decltype(::continuous_search::mojom::CategoryResults::document_url)& document_url(
      const ::continuous_search::mojom::CategoryResultsPtr& input) {
    return input->document_url;
  }

  static decltype(::continuous_search::mojom::CategoryResults::category_type) category_type(
      const ::continuous_search::mojom::CategoryResultsPtr& input) {
    return input->category_type;
  }

  static const decltype(::continuous_search::mojom::CategoryResults::groups)& groups(
      const ::continuous_search::mojom::CategoryResultsPtr& input) {
    return input->groups;
  }

  static bool Read(::continuous_search::mojom::CategoryResults::DataView input, ::continuous_search::mojom::CategoryResultsPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_H_