// components/continuous_search/common/public/mojom/continuous_search.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "components/continuous_search/common/public/mojom/continuous_search.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/continuous_search/common/public/mojom/continuous_search.mojom-params-data.h"
#include "components/continuous_search/common/public/mojom/continuous_search.mojom-shared-message-ids.h"

#include "components/continuous_search/common/public/mojom/continuous_search.mojom-import-headers.h"
#include "components/continuous_search/common/public/mojom/continuous_search.mojom-test-utils.h"


namespace continuous_search::mojom {
SearchResult::SearchResult()
    : link(),
      title() {}

SearchResult::SearchResult(
    const ::GURL& link_in,
    const ::std::u16string& title_in)
    : link(std::move(link_in)),
      title(std::move(title_in)) {}

SearchResult::~SearchResult() = default;

void SearchResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "link"), this->link,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "title"), this->title,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::std::u16string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SearchResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ResultGroup::ResultGroup()
    : type(),
      results() {}

ResultGroup::ResultGroup(
    ResultType type_in,
    std::vector<SearchResultPtr> results_in)
    : type(std::move(type_in)),
      results(std::move(results_in)) {}

ResultGroup::~ResultGroup() = default;

void ResultGroup::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResultType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "results"), this->results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<SearchResultPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ResultGroup::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CategoryResults::CategoryResults()
    : document_url(),
      category_type(Category::kNone),
      groups() {}

CategoryResults::CategoryResults(
    const ::GURL& document_url_in,
    Category category_type_in,
    std::vector<ResultGroupPtr> groups_in)
    : document_url(std::move(document_url_in)),
      category_type(std::move(category_type_in)),
      groups(std::move(groups_in)) {}

CategoryResults::~CategoryResults() = default;

void CategoryResults::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "document_url"), this->document_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "category_type"), this->category_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type Category>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "groups"), this->groups,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::vector<ResultGroupPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CategoryResults::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SearchResultExtractor::IPCStableHashFunction SearchResultExtractor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SearchResultExtractor>(message.name())) {
    case messages::SearchResultExtractor::kExtractCurrentSearchResults: {
      return &SearchResultExtractor::ExtractCurrentSearchResults_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SearchResultExtractor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SearchResultExtractor>(message.name())) {
      case messages::SearchResultExtractor::kExtractCurrentSearchResults:
            return "Receive continuous_search::mojom::SearchResultExtractor::ExtractCurrentSearchResults";
    }
  } else {
    switch (static_cast<messages::SearchResultExtractor>(message.name())) {
      case messages::SearchResultExtractor::kExtractCurrentSearchResults:
            return "Receive reply continuous_search::mojom::SearchResultExtractor::ExtractCurrentSearchResults";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SearchResultExtractor::ExtractCurrentSearchResults_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1b9720f4;  // IPCStableHash for continuous_search::mojom::SearchResultExtractor::ExtractCurrentSearchResults
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback(
      SearchResultExtractor::ExtractCurrentSearchResultsCallback callback
      ) : callback_(std::move(callback)) {
  }

  SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback(const SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback&) = delete;
  SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback& operator=(const SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SearchResultExtractor::ExtractCurrentSearchResultsCallback callback_;
};

SearchResultExtractorProxy::SearchResultExtractorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SearchResultExtractorProxy::ExtractCurrentSearchResults(
    const std::vector<ResultType>& in_result_types, ExtractCurrentSearchResultsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send continuous_search::mojom::SearchResultExtractor::ExtractCurrentSearchResults", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result_types"), in_result_types,
                        "<value of type const std::vector<ResultType>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SearchResultExtractor::kExtractCurrentSearchResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::continuous_search::mojom::internal::SearchResultExtractor_ExtractCurrentSearchResults_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result_types)::BaseType>
      result_types_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::continuous_search::mojom::internal::ResultType_Data::Validate>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::continuous_search::mojom::ResultType>>(
    in_result_types,
    result_types_fragment,
    &result_types_validate_params);

  params->result_types.Set(
      result_types_fragment.is_null() ? nullptr : result_types_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result_types.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result_types in SearchResultExtractor.ExtractCurrentSearchResults request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SearchResultExtractor::Name_);
  message.set_method_name("ExtractCurrentSearchResults");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SearchResultExtractor::ExtractCurrentSearchResultsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder> proxy(
        new SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SearchResultExtractor::ExtractCurrentSearchResultsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SearchResultExtractor::Status in_status, CategoryResultsPtr in_results);
};

bool SearchResultExtractor_ExtractCurrentSearchResults_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SearchResultExtractor.0
  bool success = true;
  SearchResultExtractor::Status p_status{};
  CategoryResultsPtr p_results{};
  SearchResultExtractor_ExtractCurrentSearchResults_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadResults(&p_results))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SearchResultExtractor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_results));
  }
  return true;
}

void SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder::Run(
    SearchResultExtractor::Status in_status, CategoryResultsPtr in_results) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply continuous_search::mojom::SearchResultExtractor::ExtractCurrentSearchResults", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type SearchResultExtractor::Status>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("results"), in_results,
                        "<value of type CategoryResultsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SearchResultExtractor::kExtractCurrentSearchResults), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::continuous_search::mojom::internal::SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::continuous_search::mojom::SearchResultExtractor_Status>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->results)::BaseType> results_fragment(
          params.message());
  
  mojo::internal::Serialize<::continuous_search::mojom::CategoryResultsDataView>(
    in_results,
    results_fragment);

  params->results.Set(
      results_fragment.is_null() ? nullptr : results_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->results.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null results in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SearchResultExtractor::Name_);
  message.set_method_name("ExtractCurrentSearchResults");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SearchResultExtractorStubDispatch::Accept(
    SearchResultExtractor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SearchResultExtractor>(message->header()->name)) {
    case messages::SearchResultExtractor::kExtractCurrentSearchResults: {
      break;
    }
  }
  return false;
}

// static
bool SearchResultExtractorStubDispatch::AcceptWithResponder(
    SearchResultExtractor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SearchResultExtractor>(message->header()->name)) {
    case messages::SearchResultExtractor::kExtractCurrentSearchResults: {
      internal::SearchResultExtractor_ExtractCurrentSearchResults_Params_Data* params =
          reinterpret_cast<
              internal::SearchResultExtractor_ExtractCurrentSearchResults_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SearchResultExtractor.0
      bool success = true;
      std::vector<ResultType> p_result_types{};
      SearchResultExtractor_ExtractCurrentSearchResults_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResultTypes(&p_result_types))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SearchResultExtractor::Name_, 0, false);
        return false;
      }
      auto callback =
          SearchResultExtractor_ExtractCurrentSearchResults_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ExtractCurrentSearchResults(        
        std::move(p_result_types), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSearchResultExtractorValidationInfo[] = {
    { &internal::SearchResultExtractor_ExtractCurrentSearchResults_Params_Data::Validate,
     &internal::SearchResultExtractor_ExtractCurrentSearchResults_ResponseParams_Data::Validate},
};

bool SearchResultExtractorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::continuous_search::mojom::SearchResultExtractor::Name_,
    kSearchResultExtractorValidationInfo);
}

bool SearchResultExtractorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::continuous_search::mojom::SearchResultExtractor::Name_,
    kSearchResultExtractorValidationInfo);
}


}  // continuous_search::mojom


namespace mojo {


// static
bool StructTraits<::continuous_search::mojom::SearchResult::DataView, ::continuous_search::mojom::SearchResultPtr>::Read(
    ::continuous_search::mojom::SearchResult::DataView input,
    ::continuous_search::mojom::SearchResultPtr* output) {
  bool success = true;
  ::continuous_search::mojom::SearchResultPtr result(::continuous_search::mojom::SearchResult::New());
  
      if (success && !input.ReadLink(&result->link))
        success = false;
      if (success && !input.ReadTitle(&result->title))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::continuous_search::mojom::ResultGroup::DataView, ::continuous_search::mojom::ResultGroupPtr>::Read(
    ::continuous_search::mojom::ResultGroup::DataView input,
    ::continuous_search::mojom::ResultGroupPtr* output) {
  bool success = true;
  ::continuous_search::mojom::ResultGroupPtr result(::continuous_search::mojom::ResultGroup::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadResults(&result->results))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::continuous_search::mojom::CategoryResults::DataView, ::continuous_search::mojom::CategoryResultsPtr>::Read(
    ::continuous_search::mojom::CategoryResults::DataView input,
    ::continuous_search::mojom::CategoryResultsPtr* output) {
  bool success = true;
  ::continuous_search::mojom::CategoryResultsPtr result(::continuous_search::mojom::CategoryResults::New());
  
      if (success && !input.ReadDocumentUrl(&result->document_url))
        success = false;
      if (success && !input.ReadCategoryType(&result->category_type))
        success = false;
      if (success && !input.ReadGroups(&result->groups))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace continuous_search::mojom {


void SearchResultExtractorInterceptorForTesting::ExtractCurrentSearchResults(const std::vector<ResultType>& result_types, ExtractCurrentSearchResultsCallback callback) {
  GetForwardingInterface()->ExtractCurrentSearchResults(
    std::move(result_types)
    , std::move(callback));
}
SearchResultExtractorAsyncWaiter::SearchResultExtractorAsyncWaiter(
    SearchResultExtractor* proxy) : proxy_(proxy) {}

SearchResultExtractorAsyncWaiter::~SearchResultExtractorAsyncWaiter() = default;


void SearchResultExtractorAsyncWaiter::ExtractCurrentSearchResults(
    const std::vector<ResultType>& result_types, SearchResultExtractor::Status* out_status, CategoryResultsPtr* out_results) {
  base::RunLoop loop;
  proxy_->ExtractCurrentSearchResults(
      std::move(result_types),
      base::BindOnce(
          [](base::RunLoop* loop,
             SearchResultExtractor::Status* out_status
,
             CategoryResultsPtr* out_results
,
             SearchResultExtractor::Status status,
             CategoryResultsPtr results) {*out_status = std::move(status);*out_results = std::move(results);
            loop->Quit();
          },
          &loop,
          out_status,
          out_results));
  loop.Run();
}








}  // continuous_search::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif