// components/continuous_search/common/public/mojom/continuous_search.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_SHARED_H_
#define COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/continuous_search/common/public/mojom/continuous_search.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "components/continuous_search/common/public/mojom/continuous_search.mojom-data-view.h"




namespace std {

template <>
struct hash<::continuous_search::mojom::ResultType>
    : public mojo::internal::EnumHashImpl<::continuous_search::mojom::ResultType> {};

template <>
struct hash<::continuous_search::mojom::Category>
    : public mojo::internal::EnumHashImpl<::continuous_search::mojom::Category> {};

template <>
struct hash<::continuous_search::mojom::SearchResultExtractor_Status>
    : public mojo::internal::EnumHashImpl<::continuous_search::mojom::SearchResultExtractor_Status> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::continuous_search::mojom::ResultType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::continuous_search::mojom::ResultType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::continuous_search::mojom::ResultType>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::continuous_search::mojom::Category, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::continuous_search::mojom::Category, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::continuous_search::mojom::Category>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::continuous_search::mojom::SearchResultExtractor_Status, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::continuous_search::mojom::SearchResultExtractor_Status, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::continuous_search::mojom::SearchResultExtractor_Status>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::continuous_search::mojom::SearchResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::continuous_search::mojom::SearchResultDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::continuous_search::mojom::internal::SearchResult_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::link(input)) in_link = Traits::link(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->link)::BaseType> link_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_link,
      link_fragment);

    fragment->link.Set(
        link_fragment.is_null() ? nullptr : link_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->link.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null link in SearchResult struct");

    decltype(Traits::title(input)) in_title = Traits::title(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->title)::BaseType> title_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_title,
      title_fragment);

    fragment->title.Set(
        title_fragment.is_null() ? nullptr : title_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->title.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null title in SearchResult struct");
  }

  static bool Deserialize(::continuous_search::mojom::internal::SearchResult_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::continuous_search::mojom::SearchResultDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::continuous_search::mojom::ResultGroupDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::continuous_search::mojom::ResultGroupDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::continuous_search::mojom::internal::ResultGroup_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    
    mojo::internal::Serialize<::continuous_search::mojom::ResultType>(
      Traits::type(input),
      &fragment->type);

    decltype(Traits::results(input)) in_results = Traits::results(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->results)::BaseType>
        results_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& results_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::continuous_search::mojom::SearchResultDataView>>(
      in_results,
      results_fragment,
      &results_validate_params);

    fragment->results.Set(
        results_fragment.is_null() ? nullptr : results_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->results.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null results in ResultGroup struct");
  }

  static bool Deserialize(::continuous_search::mojom::internal::ResultGroup_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::continuous_search::mojom::ResultGroupDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::continuous_search::mojom::CategoryResultsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::continuous_search::mojom::CategoryResultsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::continuous_search::mojom::internal::CategoryResults_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::document_url(input)) in_document_url = Traits::document_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->document_url)::BaseType> document_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_document_url,
      document_url_fragment);

    fragment->document_url.Set(
        document_url_fragment.is_null() ? nullptr : document_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->document_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null document_url in CategoryResults struct");

    
    mojo::internal::Serialize<::continuous_search::mojom::Category>(
      Traits::category_type(input),
      &fragment->category_type);

    decltype(Traits::groups(input)) in_groups = Traits::groups(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->groups)::BaseType>
        groups_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& groups_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::continuous_search::mojom::ResultGroupDataView>>(
      in_groups,
      groups_fragment,
      &groups_validate_params);

    fragment->groups.Set(
        groups_fragment.is_null() ? nullptr : groups_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->groups.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null groups in CategoryResults struct");
  }

  static bool Deserialize(::continuous_search::mojom::internal::CategoryResults_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::continuous_search::mojom::CategoryResultsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace continuous_search::mojom {

inline void SearchResultDataView::GetLinkDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->link.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void SearchResultDataView::GetTitleDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->title.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void ResultGroupDataView::GetResultsDataView(
    mojo::ArrayDataView<SearchResultDataView>* output) {
  auto pointer = data_->results.Get();
  *output = mojo::ArrayDataView<SearchResultDataView>(pointer, message_);
}


inline void CategoryResultsDataView::GetDocumentUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->document_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CategoryResultsDataView::GetGroupsDataView(
    mojo::ArrayDataView<ResultGroupDataView>* output) {
  auto pointer = data_->groups.Get();
  *output = mojo::ArrayDataView<ResultGroupDataView>(pointer, message_);
}



}  // continuous_search::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::continuous_search::mojom::ResultType> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::continuous_search::mojom::ResultType value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::continuous_search::mojom::Category> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::continuous_search::mojom::Category value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::continuous_search::mojom::SearchResultExtractor_Status> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::continuous_search::mojom::SearchResultExtractor_Status value);
};

} // namespace perfetto

#endif  // COMPONENTS_CONTINUOUS_SEARCH_COMMON_PUBLIC_MOJOM_CONTINUOUS_SEARCH_MOJOM_SHARED_H_