// components/content_settings/core/common/content_settings.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'components/content_settings/core/common/content_settings.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('contentSettings.mojom');
  var content_settings_enums$ =
      mojo.internal.exposeNamespace('contentSettings.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'components/content_settings/core/common/content_settings_enums.mojom', 'content_settings_enums.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../mojo/public/mojom/base/values.mojom.js');
  }


  var ContentSetting = {};
  ContentSetting.DEFAULT = 0;
  ContentSetting.ALLOW = 1;
  ContentSetting.BLOCK = 2;
  ContentSetting.ASK = 3;
  ContentSetting.SESSION_ONLY = 4;
  ContentSetting.MIN_VALUE = 0;
  ContentSetting.MAX_VALUE = 4;

  ContentSetting.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
      return true;
    }
    return false;
  };

  ContentSetting.toKnownEnumValue = function(value) {
    return value;
  };

  ContentSetting.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function PatternParts(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PatternParts.prototype.initDefaults_ = function() {
    this.scheme = null;
    this.isSchemeWildcard = false;
    this.hasDomainWildcard = false;
    this.isPortWildcard = false;
    this.isPathWildcard = false;
    this.host = null;
    this.port = null;
    this.path = null;
  };
  PatternParts.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PatternParts.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PatternParts.scheme
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate PatternParts.host
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate PatternParts.port
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate PatternParts.path
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 32, false)
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PatternParts.encodedSize = codec.kStructHeaderSize + 40;

  PatternParts.decode = function(decoder) {
    var packed;
    var val = new PatternParts();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scheme =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isSchemeWildcard = (packed >> 0) & 1 ? true : false;
    val.hasDomainWildcard = (packed >> 1) & 1 ? true : false;
    val.isPortWildcard = (packed >> 2) & 1 ? true : false;
    val.isPathWildcard = (packed >> 3) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.host =
        decoder.decodeStruct(codec.String);
    val.port =
        decoder.decodeStruct(codec.String);
    val.path =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PatternParts.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PatternParts.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.scheme);
    packed = 0;
    packed |= (val.isSchemeWildcard & 1) << 0
    packed |= (val.hasDomainWildcard & 1) << 1
    packed |= (val.isPortWildcard & 1) << 2
    packed |= (val.isPathWildcard & 1) << 3
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.host);
    encoder.encodeStruct(codec.String, val.port);
    encoder.encodeStruct(codec.String, val.path);
  };
  function ContentSettingsPattern(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContentSettingsPattern.prototype.initDefaults_ = function() {
    this.parts = null;
    this.isValid = false;
  };
  ContentSettingsPattern.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContentSettingsPattern.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSettingsPattern.parts
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PatternParts, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ContentSettingsPattern.encodedSize = codec.kStructHeaderSize + 16;

  ContentSettingsPattern.decode = function(decoder) {
    var packed;
    var val = new ContentSettingsPattern();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.parts =
        decoder.decodeStructPointer(PatternParts);
    packed = decoder.readUint8();
    val.isValid = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ContentSettingsPattern.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContentSettingsPattern.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PatternParts, val.parts);
    packed = 0;
    packed |= (val.isValid & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RuleMetaData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RuleMetaData.prototype.initDefaults_ = function() {
    this.lastModified = null;
    this.lastUsed = null;
    this.lastVisited = null;
    this.expiration = null;
    this.sessionModel = 0;
    this.tpcdMetadataRuleSource = 0;
    this.lifetime = null;
    this.tpcdMetadataCohort = 0;
    this.decidedByRelatedWebsiteSets = false;
    this.ruleOptions = null;
  };
  RuleMetaData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RuleMetaData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.lastModified
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.lastUsed
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.lastVisited
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.expiration
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.sessionModel
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, content_settings_enums$.SessionModel);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.lifetime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, time$.TimeDelta, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.tpcdMetadataRuleSource
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, content_settings_enums$.TpcdMetadataRuleSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RuleMetaData.tpcdMetadataCohort
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 48, content_settings_enums$.TpcdMetadataCohort);
    if (err !== validator.validationError.NONE)
        return err;



    // validate RuleMetaData.ruleOptions
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 56, values$.Value, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RuleMetaData.encodedSize = codec.kStructHeaderSize + 72;

  RuleMetaData.decode = function(decoder) {
    var packed;
    var val = new RuleMetaData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lastModified =
        decoder.decodeStructPointer(time$.Time);
    val.lastUsed =
        decoder.decodeStructPointer(time$.Time);
    val.lastVisited =
        decoder.decodeStructPointer(time$.Time);
    val.expiration =
        decoder.decodeStructPointer(time$.Time);
    val.sessionModel =
        decoder.decodeStruct(new codec.Enum(content_settings_enums$.SessionModel));
    val.tpcdMetadataRuleSource =
        decoder.decodeStruct(new codec.Enum(content_settings_enums$.TpcdMetadataRuleSource));
    val.lifetime =
        decoder.decodeStructPointer(time$.TimeDelta);
    val.tpcdMetadataCohort =
        decoder.decodeStruct(new codec.Enum(content_settings_enums$.TpcdMetadataCohort));
    packed = decoder.readUint8();
    val.decidedByRelatedWebsiteSets = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.ruleOptions =
        decoder.decodeStruct(values$.Value);
    return val;
  };

  RuleMetaData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RuleMetaData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.Time, val.lastModified);
    encoder.encodeStructPointer(time$.Time, val.lastUsed);
    encoder.encodeStructPointer(time$.Time, val.lastVisited);
    encoder.encodeStructPointer(time$.Time, val.expiration);
    encoder.encodeStruct(codec.Int32, val.sessionModel);
    encoder.encodeStruct(codec.Int32, val.tpcdMetadataRuleSource);
    encoder.encodeStructPointer(time$.TimeDelta, val.lifetime);
    encoder.encodeStruct(codec.Int32, val.tpcdMetadataCohort);
    packed = 0;
    packed |= (val.decidedByRelatedWebsiteSets & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(values$.Value, val.ruleOptions);
  };
  function ContentSettingPatternSource(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ContentSettingPatternSource.prototype.initDefaults_ = function() {
    this.primaryPattern = null;
    this.secondaryPattern = null;
    this.settingValue = null;
    this.metadata = null;
    this.source = 0;
    this.incognito = false;
  };
  ContentSettingPatternSource.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ContentSettingPatternSource.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSettingPatternSource.primaryPattern
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ContentSettingsPattern, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSettingPatternSource.secondaryPattern
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, ContentSettingsPattern, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSettingPatternSource.settingValue
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 16, values$.Value, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSettingPatternSource.metadata
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, RuleMetaData, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ContentSettingPatternSource.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 40, content_settings_enums$.ProviderType);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  ContentSettingPatternSource.encodedSize = codec.kStructHeaderSize + 48;

  ContentSettingPatternSource.decode = function(decoder) {
    var packed;
    var val = new ContentSettingPatternSource();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.primaryPattern =
        decoder.decodeStructPointer(ContentSettingsPattern);
    val.secondaryPattern =
        decoder.decodeStructPointer(ContentSettingsPattern);
    val.settingValue =
        decoder.decodeStruct(values$.Value);
    val.metadata =
        decoder.decodeStructPointer(RuleMetaData);
    val.source =
        decoder.decodeStruct(new codec.Enum(content_settings_enums$.ProviderType));
    packed = decoder.readUint8();
    val.incognito = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  ContentSettingPatternSource.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ContentSettingPatternSource.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ContentSettingsPattern, val.primaryPattern);
    encoder.encodeStructPointer(ContentSettingsPattern, val.secondaryPattern);
    encoder.encodeStruct(values$.Value, val.settingValue);
    encoder.encodeStructPointer(RuleMetaData, val.metadata);
    encoder.encodeStruct(codec.Int32, val.source);
    packed = 0;
    packed |= (val.incognito & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function RendererContentSettingRules(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RendererContentSettingRules.prototype.initDefaults_ = function() {
    this.mixedContentRules = null;
  };
  RendererContentSettingRules.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RendererContentSettingRules.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RendererContentSettingRules.mixedContentRules
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(ContentSettingPatternSource), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RendererContentSettingRules.encodedSize = codec.kStructHeaderSize + 8;

  RendererContentSettingRules.decode = function(decoder) {
    var packed;
    var val = new RendererContentSettingRules();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mixedContentRules =
        decoder.decodeArrayPointer(new codec.PointerTo(ContentSettingPatternSource));
    return val;
  };

  RendererContentSettingRules.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RendererContentSettingRules.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(ContentSettingPatternSource), val.mixedContentRules);
  };
  exports.ContentSetting = ContentSetting;
  exports.PatternParts = PatternParts;
  exports.ContentSettingsPattern = ContentSettingsPattern;
  exports.RuleMetaData = RuleMetaData;
  exports.ContentSettingPatternSource = ContentSettingPatternSource;
  exports.RendererContentSettingRules = RendererContentSettingRules;
})();