// components/content_settings/core/common/content_settings.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SHARED_INTERNAL_H_
#define COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/message_fragment.h"
#include "components/content_settings/core/common/content_settings_enums.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace content_settings::mojom {
namespace internal {
class PatternParts_Data;
class ContentSettingsPattern_Data;
class RuleMetaData_Data;
class ContentSettingPatternSource_Data;
class RendererContentSettingRules_Data;

struct ContentSetting_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 0:
      case 1:
      case 2:
      case 3:
      case 4:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)
class  PatternParts_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::String_Data> scheme;
  uint8_t is_scheme_wildcard : 1;
  uint8_t has_domain_wildcard : 1;
  uint8_t is_port_wildcard : 1;
  uint8_t is_path_wildcard : 1;
  uint8_t pad4_[7];
  mojo::internal::Pointer<mojo::internal::String_Data> host;
  mojo::internal::Pointer<mojo::internal::String_Data> port;
  mojo::internal::Pointer<mojo::internal::String_Data> path;

 private:
  friend class mojo::internal::MessageFragment<PatternParts_Data>;

  PatternParts_Data();
  ~PatternParts_Data() = delete;
};
static_assert(sizeof(PatternParts_Data) == 48,
              "Bad sizeof(PatternParts_Data)");
// Used by PatternParts::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct PatternParts_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  PatternParts_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~PatternParts_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<PatternParts_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    PatternParts_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ContentSettingsPattern_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::PatternParts_Data> parts;
  uint8_t is_valid : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<ContentSettingsPattern_Data>;

  ContentSettingsPattern_Data();
  ~ContentSettingsPattern_Data() = delete;
};
static_assert(sizeof(ContentSettingsPattern_Data) == 24,
              "Bad sizeof(ContentSettingsPattern_Data)");
// Used by ContentSettingsPattern::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ContentSettingsPattern_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ContentSettingsPattern_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ContentSettingsPattern_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ContentSettingsPattern_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ContentSettingsPattern_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  RuleMetaData_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_modified;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_used;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> last_visited;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> expiration;
  int32_t session_model;
  int32_t tpcd_metadata_rule_source;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> lifetime;
  int32_t tpcd_metadata_cohort;
  uint8_t decided_by_related_website_sets : 1;
  uint8_t pad8_[3];
  ::mojo_base::mojom::internal::Value_Data rule_options;

 private:
  friend class mojo::internal::MessageFragment<RuleMetaData_Data>;

  RuleMetaData_Data();
  ~RuleMetaData_Data() = delete;
};
static_assert(sizeof(RuleMetaData_Data) == 80,
              "Bad sizeof(RuleMetaData_Data)");
// Used by RuleMetaData::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RuleMetaData_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RuleMetaData_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RuleMetaData_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<RuleMetaData_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RuleMetaData_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  ContentSettingPatternSource_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::ContentSettingsPattern_Data> primary_pattern;
  mojo::internal::Pointer<internal::ContentSettingsPattern_Data> secondary_pattern;
  ::mojo_base::mojom::internal::Value_Data setting_value;
  mojo::internal::Pointer<internal::RuleMetaData_Data> metadata;
  int32_t source;
  uint8_t incognito : 1;
  uint8_t padfinal_[3];

 private:
  friend class mojo::internal::MessageFragment<ContentSettingPatternSource_Data>;

  ContentSettingPatternSource_Data();
  ~ContentSettingPatternSource_Data() = delete;
};
static_assert(sizeof(ContentSettingPatternSource_Data) == 56,
              "Bad sizeof(ContentSettingPatternSource_Data)");
// Used by ContentSettingPatternSource::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct ContentSettingPatternSource_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  ContentSettingPatternSource_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~ContentSettingPatternSource_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<ContentSettingPatternSource_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    ContentSettingPatternSource_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  RendererContentSettingRules_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::ContentSettingPatternSource_Data>>> mixed_content_rules;

 private:
  friend class mojo::internal::MessageFragment<RendererContentSettingRules_Data>;

  RendererContentSettingRules_Data();
  ~RendererContentSettingRules_Data() = delete;
};
static_assert(sizeof(RendererContentSettingRules_Data) == 16,
              "Bad sizeof(RendererContentSettingRules_Data)");
// Used by RendererContentSettingRules::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct RendererContentSettingRules_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  RendererContentSettingRules_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~RendererContentSettingRules_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<RendererContentSettingRules_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    RendererContentSettingRules_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // content_settings::mojom

#endif  // COMPONENTS_CONTENT_SETTINGS_CORE_COMMON_CONTENT_SETTINGS_MOJOM_SHARED_INTERNAL_H_