// components/content_capture/common/content_capture_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_DATA_MOJOM_SHARED_H_
#define COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "mojo/public/cpp/system/message_pipe.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/content_capture/common/content_capture_data.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"




#include "components/content_capture/common/content_capture_data.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::content_capture::mojom::ContentCaptureDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::content_capture::mojom::ContentCaptureDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::content_capture::mojom::internal::ContentCaptureData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in ContentCaptureData struct");

    decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bounds)::BaseType> bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_bounds,
      bounds_fragment);

    fragment->bounds.Set(
        bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bounds in ContentCaptureData struct");

    decltype(Traits::children(input)) in_children = Traits::children(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->children)::BaseType>
        children_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& children_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::content_capture::mojom::ContentCaptureDataDataView>>(
      in_children,
      children_fragment,
      &children_validate_params);

    fragment->children.Set(
        children_fragment.is_null() ? nullptr : children_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->children.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null children in ContentCaptureData struct");
  }

  static bool Deserialize(::content_capture::mojom::internal::ContentCaptureData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::content_capture::mojom::ContentCaptureDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace content_capture::mojom {

inline void ContentCaptureDataDataView::GetValueDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->value.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}
inline void ContentCaptureDataDataView::GetBoundsDataView(
    ::gfx::mojom::RectDataView* output) {
  auto pointer = data_->bounds.Get();
  *output = ::gfx::mojom::RectDataView(pointer, message_);
}
inline void ContentCaptureDataDataView::GetChildrenDataView(
    mojo::ArrayDataView<ContentCaptureDataDataView>* output) {
  auto pointer = data_->children.Get();
  *output = mojo::ArrayDataView<ContentCaptureDataDataView>(pointer, message_);
}



}  // content_capture::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // COMPONENTS_CONTENT_CAPTURE_COMMON_CONTENT_CAPTURE_DATA_MOJOM_SHARED_H_