// components/commerce/core/mojom/shopping_service.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ProductInfoSpec as commerce_shared_mojom_ProductInfoSpec,
  ProductInfo as commerce_shared_mojom_ProductInfo,
  ProductSpecificationsSetSpec as commerce_shared_mojom_ProductSpecificationsSetSpec,
  ProductSpecificationsSet as commerce_shared_mojom_ProductSpecificationsSet
} from './shared.mojom-webui.js';
import {
  UuidSpec as mojoBase_mojom_UuidSpec,
  Uuid as mojoBase_mojom_Uuid
} from '//resources/mojo/mojo/public/mojom/base/uuid.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const UserFeedbackSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum UserFeedback {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kUnspecified = 0,
  kThumbsUp = 1,
  kThumbsDown = 2,
}



export type ShoppingServiceHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerFactoryPendingReceiver>;

export class ShoppingServiceHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ShoppingServiceHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|ShoppingServiceHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'shopping_service.mojom.ShoppingServiceHandlerFactory',
        scope);
  }
}

export interface ShoppingServiceHandlerFactoryInterface {
  createShoppingServiceHandler(handler: ShoppingServiceHandlerPendingReceiver): void;
}

export class ShoppingServiceHandlerFactoryRemote implements ShoppingServiceHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ShoppingServiceHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ShoppingServiceHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ShoppingServiceHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ShoppingServiceHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createShoppingServiceHandler(
      handler: ShoppingServiceHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$,
        null,
        [
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ShoppingServiceHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShoppingServiceHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ShoppingServiceHandlerFactoryRemote, ShoppingServiceHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ShoppingServiceHandlerFactoryRemote, ShoppingServiceHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ShoppingServiceHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ShoppingServiceHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$,
        null,
        impl.createShoppingServiceHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ShoppingServiceHandlerFactory {
  static get $interfaceName(): string {
    return "shopping_service.mojom.ShoppingServiceHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ShoppingServiceHandlerFactoryRemote {
    let remote = new ShoppingServiceHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ShoppingServiceHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShoppingServiceHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ShoppingServiceHandlerFactoryRemote, ShoppingServiceHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ShoppingServiceHandlerFactoryRemote, ShoppingServiceHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createShoppingServiceHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ShoppingServiceHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createShoppingServiceHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$,
        null,
        this.createShoppingServiceHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type ShoppingServiceHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerPendingReceiver>;

export class ShoppingServiceHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<ShoppingServiceHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<ShoppingServiceHandlerPendingReceiver>;
  constructor(handle: MojoHandle|ShoppingServiceHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'shopping_service.mojom.ShoppingServiceHandler',
        scope);
  }
}

export interface ShoppingServiceHandlerInterface {
  getProductInfoForCurrentUrl(): Promise<{
        productInfo: commerce_shared_mojom_ProductInfo, }>;
  getProductInfoForUrl(url: url_mojom_Url): Promise<{
        url: url_mojom_Url,
        productInfo: commerce_shared_mojom_ProductInfo, }>;
  getProductInfoForUrls(urls: url_mojom_Url[]): Promise<{
        productInfos: commerce_shared_mojom_ProductInfo[], }>;
  getPriceInsightsInfoForCurrentUrl(): Promise<{
        priceInsightsInfo: PriceInsightsInfo, }>;
  getPriceInsightsInfoForUrl(url: url_mojom_Url): Promise<{
        url: url_mojom_Url,
        priceInsightsInfo: PriceInsightsInfo, }>;
  getProductSpecificationsForUrls(urls: url_mojom_Url[]): Promise<{
        productSpecs: ProductSpecifications, }>;
  getUrlInfosForProductTabs(): Promise<{
        urlInfos: UrlInfo[], }>;
  getUrlInfosForRecentlyViewedTabs(): Promise<{
        urlInfos: UrlInfo[], }>;
  isShoppingListEligible(): Promise<{
        eligible: boolean, }>;
  getPriceTrackingStatusForCurrentUrl(): Promise<{
        tracked: boolean, }>;
  openUrlInNewTab(url: url_mojom_Url): void;
  switchToOrOpenTab(url: url_mojom_Url): void;
  getAllProductSpecificationsSets(): Promise<{
        sets: commerce_shared_mojom_ProductSpecificationsSet[], }>;
  getProductSpecificationsSetByUuid(uuid: mojoBase_mojom_Uuid): Promise<{
        set: (commerce_shared_mojom_ProductSpecificationsSet | null), }>;
  addProductSpecificationsSet(name: string, urls: url_mojom_Url[]): Promise<{
        createdSet: (commerce_shared_mojom_ProductSpecificationsSet | null), }>;
  deleteProductSpecificationsSet(uuid: mojoBase_mojom_Uuid): void;
  setNameForProductSpecificationsSet(uuid: mojoBase_mojom_Uuid, name: string): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null), }>;
  setUrlsForProductSpecificationsSet(uuid: mojoBase_mojom_Uuid, urls: url_mojom_Url[]): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null), }>;
  setProductSpecificationsUserFeedback(feedback: UserFeedback): void;
  getProductSpecificationsFeatureState(): Promise<{
        state: ProductSpecificationsFeatureState, }>;
}

export class ShoppingServiceHandlerRemote implements ShoppingServiceHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<ShoppingServiceHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<ShoppingServiceHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|ShoppingServiceHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ShoppingServiceHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getProductInfoForCurrentUrl(): Promise<{
        productInfo: commerce_shared_mojom_ProductInfo, }> {
    return this.proxy.sendMessage(
        0,
        ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getProductInfoForUrl(
      url: url_mojom_Url): Promise<{
        url: url_mojom_Url,
        productInfo: commerce_shared_mojom_ProductInfo, }> {
    return this.proxy.sendMessage(
        1,
        ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  getProductInfoForUrls(
      urls: url_mojom_Url[]): Promise<{
        productInfos: commerce_shared_mojom_ProductInfo[], }> {
    return this.proxy.sendMessage(
        2,
        ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$,
        [
          urls
        ],
        false);
  }

  getPriceInsightsInfoForCurrentUrl(): Promise<{
        priceInsightsInfo: PriceInsightsInfo, }> {
    return this.proxy.sendMessage(
        3,
        ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getPriceInsightsInfoForUrl(
      url: url_mojom_Url): Promise<{
        url: url_mojom_Url,
        priceInsightsInfo: PriceInsightsInfo, }> {
    return this.proxy.sendMessage(
        4,
        ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$,
        [
          url
        ],
        false);
  }

  getProductSpecificationsForUrls(
      urls: url_mojom_Url[]): Promise<{
        productSpecs: ProductSpecifications, }> {
    return this.proxy.sendMessage(
        5,
        ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$,
        [
          urls
        ],
        false);
  }

  getUrlInfosForProductTabs(): Promise<{
        urlInfos: UrlInfo[], }> {
    return this.proxy.sendMessage(
        6,
        ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$,
        ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getUrlInfosForRecentlyViewedTabs(): Promise<{
        urlInfos: UrlInfo[], }> {
    return this.proxy.sendMessage(
        7,
        ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$,
        ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  isShoppingListEligible(): Promise<{
        eligible: boolean, }> {
    return this.proxy.sendMessage(
        8,
        ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$,
        ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getPriceTrackingStatusForCurrentUrl(): Promise<{
        tracked: boolean, }> {
    return this.proxy.sendMessage(
        9,
        ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  openUrlInNewTab(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        10,
        ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  switchToOrOpenTab(
      url: url_mojom_Url): void {
    this.proxy.sendMessage(
        11,
        ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$,
        null,
        [
          url
        ],
        false);
  }

  getAllProductSpecificationsSets(): Promise<{
        sets: commerce_shared_mojom_ProductSpecificationsSet[], }> {
    return this.proxy.sendMessage(
        12,
        ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$,
        ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  getProductSpecificationsSetByUuid(
      uuid: mojoBase_mojom_Uuid): Promise<{
        set: (commerce_shared_mojom_ProductSpecificationsSet | null), }> {
    return this.proxy.sendMessage(
        13,
        ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$,
        [
          uuid
        ],
        false);
  }

  addProductSpecificationsSet(
      name: string,
      urls: url_mojom_Url[]): Promise<{
        createdSet: (commerce_shared_mojom_ProductSpecificationsSet | null), }> {
    return this.proxy.sendMessage(
        14,
        ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$,
        [
          name,
          urls
        ],
        false);
  }

  deleteProductSpecificationsSet(
      uuid: mojoBase_mojom_Uuid): void {
    this.proxy.sendMessage(
        15,
        ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$,
        null,
        [
          uuid
        ],
        false);
  }

  setNameForProductSpecificationsSet(
      uuid: mojoBase_mojom_Uuid,
      name: string): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null), }> {
    return this.proxy.sendMessage(
        16,
        ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$,
        [
          uuid,
          name
        ],
        false);
  }

  setUrlsForProductSpecificationsSet(
      uuid: mojoBase_mojom_Uuid,
      urls: url_mojom_Url[]): Promise<{
        updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null), }> {
    return this.proxy.sendMessage(
        17,
        ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$,
        [
          uuid,
          urls
        ],
        false);
  }

  setProductSpecificationsUserFeedback(
      feedback: UserFeedback): void {
    this.proxy.sendMessage(
        18,
        ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$,
        null,
        [
          feedback
        ],
        false);
  }

  getProductSpecificationsFeatureState(): Promise<{
        state: ProductSpecificationsFeatureState, }> {
    return this.proxy.sendMessage(
        19,
        ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the ShoppingServiceHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ShoppingServiceHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ShoppingServiceHandlerRemote, ShoppingServiceHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ShoppingServiceHandlerRemote, ShoppingServiceHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: ShoppingServiceHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ShoppingServiceHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$,
        impl.getProductInfoForCurrentUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
        impl.getProductInfoForUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$,
        impl.getProductInfoForUrls.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$,
        impl.getPriceInsightsInfoForCurrentUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$,
        impl.getPriceInsightsInfoForUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$,
        impl.getProductSpecificationsForUrls.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$,
        ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$,
        impl.getUrlInfosForProductTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$,
        ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$,
        impl.getUrlInfosForRecentlyViewedTabs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$,
        ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$,
        impl.isShoppingListEligible.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$,
        impl.getPriceTrackingStatusForCurrentUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$,
        null,
        impl.openUrlInNewTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$,
        null,
        impl.switchToOrOpenTab.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$,
        ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$,
        impl.getAllProductSpecificationsSets.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$,
        impl.getProductSpecificationsSetByUuid.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$,
        impl.addProductSpecificationsSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$,
        null,
        impl.deleteProductSpecificationsSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$,
        impl.setNameForProductSpecificationsSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$,
        impl.setUrlsForProductSpecificationsSet.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$,
        null,
        impl.setProductSpecificationsUserFeedback.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$,
        impl.getProductSpecificationsFeatureState.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ShoppingServiceHandler {
  static get $interfaceName(): string {
    return "shopping_service.mojom.ShoppingServiceHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): ShoppingServiceHandlerRemote {
    let remote = new ShoppingServiceHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the ShoppingServiceHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ShoppingServiceHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    ShoppingServiceHandlerRemote, ShoppingServiceHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    ShoppingServiceHandlerRemote, ShoppingServiceHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getProductInfoForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProductInfoForUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProductInfoForUrls: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPriceInsightsInfoForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPriceInsightsInfoForUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProductSpecificationsForUrls: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getUrlInfosForProductTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getUrlInfosForRecentlyViewedTabs: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  isShoppingListEligible: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getPriceTrackingStatusForCurrentUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openUrlInNewTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  switchToOrOpenTab: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getAllProductSpecificationsSets: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProductSpecificationsSetByUuid: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setNameForProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setUrlsForProductSpecificationsSet: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setProductSpecificationsUserFeedback: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getProductSpecificationsFeatureState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ShoppingServiceHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getProductInfoForCurrentUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$,
        this.getProductInfoForCurrentUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getProductInfoForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
        this.getProductInfoForUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getProductInfoForUrls =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$,
        ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$,
        this.getProductInfoForUrls.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getPriceInsightsInfoForCurrentUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$,
        this.getPriceInsightsInfoForCurrentUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getPriceInsightsInfoForUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$,
        this.getPriceInsightsInfoForUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getProductSpecificationsForUrls =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$,
        this.getProductSpecificationsForUrls.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getUrlInfosForProductTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$,
        ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$,
        this.getUrlInfosForProductTabs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getUrlInfosForRecentlyViewedTabs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$,
        ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$,
        this.getUrlInfosForRecentlyViewedTabs.createReceiverHandler(true /* expectsResponse */),
        false);
    this.isShoppingListEligible =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$,
        ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$,
        this.isShoppingListEligible.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getPriceTrackingStatusForCurrentUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
        ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$,
        this.getPriceTrackingStatusForCurrentUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openUrlInNewTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$,
        null,
        this.openUrlInNewTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.switchToOrOpenTab =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$,
        null,
        this.switchToOrOpenTab.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getAllProductSpecificationsSets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$,
        ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$,
        this.getAllProductSpecificationsSets.createReceiverHandler(true /* expectsResponse */),
        false);
    this.getProductSpecificationsSetByUuid =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$,
        this.getProductSpecificationsSetByUuid.createReceiverHandler(true /* expectsResponse */),
        false);
    this.addProductSpecificationsSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$,
        this.addProductSpecificationsSet.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteProductSpecificationsSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$,
        null,
        this.deleteProductSpecificationsSet.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setNameForProductSpecificationsSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$,
        this.setNameForProductSpecificationsSet.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setUrlsForProductSpecificationsSet =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$,
        ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$,
        this.setUrlsForProductSpecificationsSet.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setProductSpecificationsUserFeedback =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$,
        null,
        this.setProductSpecificationsUserFeedback.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getProductSpecificationsFeatureState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$,
        ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$,
        this.getProductSpecificationsFeatureState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const PricePointSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const UrlInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PriceInsightsInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsDescriptionTextSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsOptionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsDescriptionSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsValueSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsProductSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsFeatureStateSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ProductSpecificationsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface PricePointMojoType {
  date: string;
  price: number;
  formattedPrice: string;
}


export type PricePoint = PricePointMojoType;
mojo.internal.Struct<PricePointMojoType>(
    PricePointSpec.$,
    'PricePoint',
    [
      mojo.internal.StructField<PricePointMojoType, string>(
        'date', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PricePointMojoType, number>(
        'price', 8,
        0,
        mojo.internal.Float,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PricePointMojoType, string>(
        'formattedPrice', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface UrlInfoMojoType {
  title: string;
  url: url_mojom_Url;
  faviconUrl: url_mojom_Url;
  thumbnailUrl: url_mojom_Url;
  previewText: string;
}


export type UrlInfo = UrlInfoMojoType;
mojo.internal.Struct<UrlInfoMojoType>(
    UrlInfoSpec.$,
    'UrlInfo',
    [
      mojo.internal.StructField<UrlInfoMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UrlInfoMojoType, url_mojom_Url>(
        'url', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UrlInfoMojoType, url_mojom_Url>(
        'faviconUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UrlInfoMojoType, url_mojom_Url>(
        'thumbnailUrl', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<UrlInfoMojoType, string>(
        'previewText', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 48],]);




export const PriceInsightsInfo_PriceBucketSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum PriceInsightsInfo_PriceBucket {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kUnknown = 0,
  kLow = 1,
  kTypical = 2,
  kHigh = 3,
}


export interface PriceInsightsInfoMojoType {
  clusterId: bigint;
  typicalLowPrice: string;
  typicalHighPrice: string;
  catalogAttributes: string;
  jackpot: url_mojom_Url;
  bucket: PriceInsightsInfo_PriceBucket;
  hasMultipleCatalogs: boolean;
  history: PricePoint[];
  locale: string;
  currencyCode: string;
}


export type PriceInsightsInfo = PriceInsightsInfoMojoType;
mojo.internal.Struct<PriceInsightsInfoMojoType>(
    PriceInsightsInfoSpec.$,
    'PriceInsightsInfo',
    [
      mojo.internal.StructField<PriceInsightsInfoMojoType, bigint>(
        'clusterId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, string>(
        'typicalLowPrice', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, string>(
        'typicalHighPrice', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, string>(
        'catalogAttributes', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, url_mojom_Url>(
        'jackpot', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, PriceInsightsInfo_PriceBucket>(
        'bucket', 40,
        0,
        PriceInsightsInfo_PriceBucketSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, boolean>(
        'hasMultipleCatalogs', 44,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, PricePoint[]>(
        'history', 48,
        0,
        mojo.internal.Array(PricePointSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, string>(
        'locale', 56,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PriceInsightsInfoMojoType, string>(
        'currencyCode', 64,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 80],]);





export interface ProductSpecificationsDescriptionTextMojoType {
  text: string;
  urls: UrlInfo[];
}


export type ProductSpecificationsDescriptionText = ProductSpecificationsDescriptionTextMojoType;
mojo.internal.Struct<ProductSpecificationsDescriptionTextMojoType>(
    ProductSpecificationsDescriptionTextSpec.$,
    'ProductSpecificationsDescriptionText',
    [
      mojo.internal.StructField<ProductSpecificationsDescriptionTextMojoType, string>(
        'text', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsDescriptionTextMojoType, UrlInfo[]>(
        'urls', 8,
        0,
        mojo.internal.Array(UrlInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ProductSpecificationsOptionMojoType {
  descriptions: ProductSpecificationsDescriptionText[];
}


export type ProductSpecificationsOption = ProductSpecificationsOptionMojoType;
mojo.internal.Struct<ProductSpecificationsOptionMojoType>(
    ProductSpecificationsOptionSpec.$,
    'ProductSpecificationsOption',
    [
      mojo.internal.StructField<ProductSpecificationsOptionMojoType, ProductSpecificationsDescriptionText[]>(
        'descriptions', 0,
        0,
        mojo.internal.Array(ProductSpecificationsDescriptionTextSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsDescriptionMojoType {
  options: ProductSpecificationsOption[];
  label: string;
  altText: string;
}


export type ProductSpecificationsDescription = ProductSpecificationsDescriptionMojoType;
mojo.internal.Struct<ProductSpecificationsDescriptionMojoType>(
    ProductSpecificationsDescriptionSpec.$,
    'ProductSpecificationsDescription',
    [
      mojo.internal.StructField<ProductSpecificationsDescriptionMojoType, ProductSpecificationsOption[]>(
        'options', 0,
        0,
        mojo.internal.Array(ProductSpecificationsOptionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsDescriptionMojoType, string>(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsDescriptionMojoType, string>(
        'altText', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface ProductSpecificationsValueMojoType {
  specificationDescriptions: ProductSpecificationsDescription[];
  summary: ProductSpecificationsDescriptionText[];
}


export type ProductSpecificationsValue = ProductSpecificationsValueMojoType;
mojo.internal.Struct<ProductSpecificationsValueMojoType>(
    ProductSpecificationsValueSpec.$,
    'ProductSpecificationsValue',
    [
      mojo.internal.StructField<ProductSpecificationsValueMojoType, ProductSpecificationsDescription[]>(
        'specificationDescriptions', 0,
        0,
        mojo.internal.Array(ProductSpecificationsDescriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsValueMojoType, ProductSpecificationsDescriptionText[]>(
        'summary', 8,
        0,
        mojo.internal.Array(ProductSpecificationsDescriptionTextSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ProductSpecificationsProductMojoType {
  productClusterId: bigint;
  title: string;
  imageUrl: url_mojom_Url;
  productDimensionValues: Map<bigint, ProductSpecificationsValue>;
  summary: ProductSpecificationsDescriptionText[];
  buyingOptionsUrl: url_mojom_Url;
}


export type ProductSpecificationsProduct = ProductSpecificationsProductMojoType;
mojo.internal.Struct<ProductSpecificationsProductMojoType>(
    ProductSpecificationsProductSpec.$,
    'ProductSpecificationsProduct',
    [
      mojo.internal.StructField<ProductSpecificationsProductMojoType, bigint>(
        'productClusterId', 0,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsProductMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsProductMojoType, url_mojom_Url>(
        'imageUrl', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsProductMojoType, Map<bigint, ProductSpecificationsValue>>(
        'productDimensionValues', 24,
        0,
        mojo.internal.Map(mojo.internal.Uint64, ProductSpecificationsValueSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsProductMojoType, ProductSpecificationsDescriptionText[]>(
        'summary', 32,
        0,
        mojo.internal.Array(ProductSpecificationsDescriptionTextSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsProductMojoType, url_mojom_Url>(
        'buyingOptionsUrl', 40,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 56],]);





export interface ProductSpecificationsFeatureStateMojoType {
  isSyncingTabCompare: boolean;
  canLoadFullPageUi: boolean;
  canManageSets: boolean;
  canFetchData: boolean;
  isAllowedForEnterprise: boolean;
  isQualityLoggingAllowed: boolean;
  isSignedIn: boolean;
}


export type ProductSpecificationsFeatureState = ProductSpecificationsFeatureStateMojoType;
mojo.internal.Struct<ProductSpecificationsFeatureStateMojoType>(
    ProductSpecificationsFeatureStateSpec.$,
    'ProductSpecificationsFeatureState',
    [
      mojo.internal.StructField<ProductSpecificationsFeatureStateMojoType, boolean>(
        'isSyncingTabCompare', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsFeatureStateMojoType, boolean>(
        'canLoadFullPageUi', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsFeatureStateMojoType, boolean>(
        'canManageSets', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsFeatureStateMojoType, boolean>(
        'canFetchData', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsFeatureStateMojoType, boolean>(
        'isAllowedForEnterprise', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsFeatureStateMojoType, boolean>(
        'isQualityLoggingAllowed', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsFeatureStateMojoType, boolean>(
        'isSignedIn', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ProductSpecificationsMojoType {
  productDimensionMap: Map<bigint, string>;
  products: ProductSpecificationsProduct[];
}


export type ProductSpecifications = ProductSpecificationsMojoType;
mojo.internal.Struct<ProductSpecificationsMojoType>(
    ProductSpecificationsSpec.$,
    'ProductSpecifications',
    [
      mojo.internal.StructField<ProductSpecificationsMojoType, Map<bigint, string>>(
        'productDimensionMap', 0,
        0,
        mojo.internal.Map(mojo.internal.Uint64, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ProductSpecificationsMojoType, ProductSpecificationsProduct[]>(
        'products', 8,
        0,
        mojo.internal.Array(ProductSpecificationsProductSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsMojoType {
  handler: ShoppingServiceHandlerPendingReceiver;
}


export type ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params = ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsMojoType>(
    ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsSpec.$,
    'ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandlerFactory_CreateShoppingServiceHandler_ParamsMojoType, ShoppingServiceHandlerPendingReceiver>(
        'handler', 0,
        0,
        mojo.internal.InterfaceRequest(ShoppingServiceHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsMojoType {
}


export type ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params = ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsMojoType>(
    ShoppingServiceHandler_GetProductInfoForCurrentUrl_ParamsSpec.$,
    'ShoppingServiceHandler_GetProductInfoForCurrentUrl_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsMojoType {
  productInfo: commerce_shared_mojom_ProductInfo;
}


export type ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams = ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductInfoForCurrentUrl_ResponseParamsMojoType, commerce_shared_mojom_ProductInfo>(
        'productInfo', 0,
        0,
        commerce_shared_mojom_ProductInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductInfoForUrl_ParamsMojoType {
  url: url_mojom_Url;
}


export type ShoppingServiceHandler_GetProductInfoForUrl_Params = ShoppingServiceHandler_GetProductInfoForUrl_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductInfoForUrl_ParamsMojoType>(
    ShoppingServiceHandler_GetProductInfoForUrl_ParamsSpec.$,
    'ShoppingServiceHandler_GetProductInfoForUrl_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductInfoForUrl_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsMojoType {
  url: url_mojom_Url;
  productInfo: commerce_shared_mojom_ProductInfo;
}


export type ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams = ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetProductInfoForUrl_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ShoppingServiceHandler_GetProductInfoForUrl_ResponseParamsMojoType, commerce_shared_mojom_ProductInfo>(
        'productInfo', 8,
        0,
        commerce_shared_mojom_ProductInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ShoppingServiceHandler_GetProductInfoForUrls_ParamsMojoType {
  urls: url_mojom_Url[];
}


export type ShoppingServiceHandler_GetProductInfoForUrls_Params = ShoppingServiceHandler_GetProductInfoForUrls_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductInfoForUrls_ParamsMojoType>(
    ShoppingServiceHandler_GetProductInfoForUrls_ParamsSpec.$,
    'ShoppingServiceHandler_GetProductInfoForUrls_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductInfoForUrls_ParamsMojoType, url_mojom_Url[]>(
        'urls', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsMojoType {
  productInfos: commerce_shared_mojom_ProductInfo[];
}


export type ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams = ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetProductInfoForUrls_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductInfoForUrls_ResponseParamsMojoType, commerce_shared_mojom_ProductInfo[]>(
        'productInfos', 0,
        0,
        mojo.internal.Array(commerce_shared_mojom_ProductInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsMojoType {
}


export type ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params = ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsMojoType>(
    ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ParamsSpec.$,
    'ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsMojoType {
  priceInsightsInfo: PriceInsightsInfo;
}


export type ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams = ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetPriceInsightsInfoForCurrentUrl_ResponseParamsMojoType, PriceInsightsInfo>(
        'priceInsightsInfo', 0,
        0,
        PriceInsightsInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsMojoType {
  url: url_mojom_Url;
}


export type ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params = ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsMojoType>(
    ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsSpec.$,
    'ShoppingServiceHandler_GetPriceInsightsInfoForUrl_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsMojoType {
  url: url_mojom_Url;
  priceInsightsInfo: PriceInsightsInfo;
}


export type ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams = ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ShoppingServiceHandler_GetPriceInsightsInfoForUrl_ResponseParamsMojoType, PriceInsightsInfo>(
        'priceInsightsInfo', 8,
        0,
        PriceInsightsInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsMojoType {
  urls: url_mojom_Url[];
}


export type ShoppingServiceHandler_GetProductSpecificationsForUrls_Params = ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsMojoType>(
    ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsSpec.$,
    'ShoppingServiceHandler_GetProductSpecificationsForUrls_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductSpecificationsForUrls_ParamsMojoType, url_mojom_Url[]>(
        'urls', 0,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsMojoType {
  productSpecs: ProductSpecifications;
}


export type ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams = ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductSpecificationsForUrls_ResponseParamsMojoType, ProductSpecifications>(
        'productSpecs', 0,
        0,
        ProductSpecificationsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsMojoType {
}


export type ShoppingServiceHandler_GetUrlInfosForProductTabs_Params = ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsMojoType>(
    ShoppingServiceHandler_GetUrlInfosForProductTabs_ParamsSpec.$,
    'ShoppingServiceHandler_GetUrlInfosForProductTabs_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsMojoType {
  urlInfos: UrlInfo[];
}


export type ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams = ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetUrlInfosForProductTabs_ResponseParamsMojoType, UrlInfo[]>(
        'urlInfos', 0,
        0,
        mojo.internal.Array(UrlInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsMojoType {
}


export type ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params = ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsMojoType>(
    ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ParamsSpec.$,
    'ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsMojoType {
  urlInfos: UrlInfo[];
}


export type ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams = ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetUrlInfosForRecentlyViewedTabs_ResponseParamsMojoType, UrlInfo[]>(
        'urlInfos', 0,
        0,
        mojo.internal.Array(UrlInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_IsShoppingListEligible_ParamsMojoType {
}


export type ShoppingServiceHandler_IsShoppingListEligible_Params = ShoppingServiceHandler_IsShoppingListEligible_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_IsShoppingListEligible_ParamsMojoType>(
    ShoppingServiceHandler_IsShoppingListEligible_ParamsSpec.$,
    'ShoppingServiceHandler_IsShoppingListEligible_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsMojoType {
  eligible: boolean;
}


export type ShoppingServiceHandler_IsShoppingListEligible_ResponseParams = ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsMojoType>(
    ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsSpec.$,
    'ShoppingServiceHandler_IsShoppingListEligible_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_IsShoppingListEligible_ResponseParamsMojoType, boolean>(
        'eligible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsMojoType {
}


export type ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params = ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsMojoType>(
    ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ParamsSpec.$,
    'ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsMojoType {
  tracked: boolean;
}


export type ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams = ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetPriceTrackingStatusForCurrentUrl_ResponseParamsMojoType, boolean>(
        'tracked', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_OpenUrlInNewTab_ParamsMojoType {
  url: url_mojom_Url;
}


export type ShoppingServiceHandler_OpenUrlInNewTab_Params = ShoppingServiceHandler_OpenUrlInNewTab_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_OpenUrlInNewTab_ParamsMojoType>(
    ShoppingServiceHandler_OpenUrlInNewTab_ParamsSpec.$,
    'ShoppingServiceHandler_OpenUrlInNewTab_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_OpenUrlInNewTab_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_SwitchToOrOpenTab_ParamsMojoType {
  url: url_mojom_Url;
}


export type ShoppingServiceHandler_SwitchToOrOpenTab_Params = ShoppingServiceHandler_SwitchToOrOpenTab_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_SwitchToOrOpenTab_ParamsMojoType>(
    ShoppingServiceHandler_SwitchToOrOpenTab_ParamsSpec.$,
    'ShoppingServiceHandler_SwitchToOrOpenTab_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_SwitchToOrOpenTab_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsMojoType {
}


export type ShoppingServiceHandler_GetAllProductSpecificationsSets_Params = ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsMojoType>(
    ShoppingServiceHandler_GetAllProductSpecificationsSets_ParamsSpec.$,
    'ShoppingServiceHandler_GetAllProductSpecificationsSets_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsMojoType {
  sets: commerce_shared_mojom_ProductSpecificationsSet[];
}


export type ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams = ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetAllProductSpecificationsSets_ResponseParamsMojoType, commerce_shared_mojom_ProductSpecificationsSet[]>(
        'sets', 0,
        0,
        mojo.internal.Array(commerce_shared_mojom_ProductSpecificationsSetSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params = ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsMojoType>(
    ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsSpec.$,
    'ShoppingServiceHandler_GetProductSpecificationsSetByUuid_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsMojoType {
  set: (commerce_shared_mojom_ProductSpecificationsSet | null);
}


export type ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams = ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductSpecificationsSetByUuid_ResponseParamsMojoType, commerce_shared_mojom_ProductSpecificationsSet>(
        'set', 0,
        0,
        commerce_shared_mojom_ProductSpecificationsSetSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_AddProductSpecificationsSet_ParamsMojoType {
  name: string;
  urls: url_mojom_Url[];
}


export type ShoppingServiceHandler_AddProductSpecificationsSet_Params = ShoppingServiceHandler_AddProductSpecificationsSet_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_AddProductSpecificationsSet_ParamsMojoType>(
    ShoppingServiceHandler_AddProductSpecificationsSet_ParamsSpec.$,
    'ShoppingServiceHandler_AddProductSpecificationsSet_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_AddProductSpecificationsSet_ParamsMojoType, string>(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ShoppingServiceHandler_AddProductSpecificationsSet_ParamsMojoType, url_mojom_Url[]>(
        'urls', 8,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsMojoType {
  createdSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
}


export type ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams = ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsMojoType>(
    ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsSpec.$,
    'ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_AddProductSpecificationsSet_ResponseParamsMojoType, commerce_shared_mojom_ProductSpecificationsSet>(
        'createdSet', 0,
        0,
        commerce_shared_mojom_ProductSpecificationsSetSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
}


export type ShoppingServiceHandler_DeleteProductSpecificationsSet_Params = ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsMojoType>(
    ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsSpec.$,
    'ShoppingServiceHandler_DeleteProductSpecificationsSet_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_DeleteProductSpecificationsSet_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
  name: string;
}


export type ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params = ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsMojoType>(
    ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsSpec.$,
    'ShoppingServiceHandler_SetNameForProductSpecificationsSet_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ShoppingServiceHandler_SetNameForProductSpecificationsSet_ParamsMojoType, string>(
        'name', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsMojoType {
  updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
}


export type ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams = ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsMojoType>(
    ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsSpec.$,
    'ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_SetNameForProductSpecificationsSet_ResponseParamsMojoType, commerce_shared_mojom_ProductSpecificationsSet>(
        'updatedSet', 0,
        0,
        commerce_shared_mojom_ProductSpecificationsSetSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsMojoType {
  uuid: mojoBase_mojom_Uuid;
  urls: url_mojom_Url[];
}


export type ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params = ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsMojoType>(
    ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsSpec.$,
    'ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsMojoType, mojoBase_mojom_Uuid>(
        'uuid', 0,
        0,
        mojoBase_mojom_UuidSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ParamsMojoType, url_mojom_Url[]>(
        'urls', 8,
        0,
        mojo.internal.Array(url_mojom_UrlSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsMojoType {
  updatedSet: (commerce_shared_mojom_ProductSpecificationsSet | null);
}


export type ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams = ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsMojoType>(
    ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsSpec.$,
    'ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_SetUrlsForProductSpecificationsSet_ResponseParamsMojoType, commerce_shared_mojom_ProductSpecificationsSet>(
        'updatedSet', 0,
        0,
        commerce_shared_mojom_ProductSpecificationsSetSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsMojoType {
  feedback: UserFeedback;
}


export type ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params = ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsMojoType>(
    ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsSpec.$,
    'ShoppingServiceHandler_SetProductSpecificationsUserFeedback_Params',
    [
      mojo.internal.StructField<ShoppingServiceHandler_SetProductSpecificationsUserFeedback_ParamsMojoType, UserFeedback>(
        'feedback', 0,
        0,
        UserFeedbackSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsMojoType {
}


export type ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params = ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsMojoType>(
    ShoppingServiceHandler_GetProductSpecificationsFeatureState_ParamsSpec.$,
    'ShoppingServiceHandler_GetProductSpecificationsFeatureState_Params',
    [
    ],
    [[0, 8],]);





export interface ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsMojoType {
  state: ProductSpecificationsFeatureState;
}


export type ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams = ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsMojoType;
mojo.internal.Struct<ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsMojoType>(
    ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsSpec.$,
    'ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParams',
    [
      mojo.internal.StructField<ShoppingServiceHandler_GetProductSpecificationsFeatureState_ResponseParamsMojoType, ProductSpecificationsFeatureState>(
        'state', 0,
        0,
        ProductSpecificationsFeatureStateSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



