// components/commerce/core/mojom/product_specifications.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "components/commerce/core/mojom/product_specifications.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "components/commerce/core/mojom/product_specifications.mojom-params-data.h"
namespace commerce {
namespace product_specifications {
namespace mojom {

NOINLINE static const char* DisclosureVersionToStringHelper(DisclosureVersion value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DisclosureVersion::kUnknown:
      return "kUnknown";
    case DisclosureVersion::kV1:
      return "kV1";
    default:
      return nullptr;
  }
}

std::string DisclosureVersionToString(DisclosureVersion value) {
  const char *str = DisclosureVersionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DisclosureVersion value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DisclosureVersion value) {
  return os << DisclosureVersionToString(value);
}

NOINLINE static const char* ShowSetDispositionToStringHelper(ShowSetDisposition value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ShowSetDisposition::kInNewTabs:
      return "kInNewTabs";
    case ShowSetDisposition::kInNewWindow:
      return "kInNewWindow";
    default:
      return nullptr;
  }
}

std::string ShowSetDispositionToString(ShowSetDisposition value) {
  const char *str = ShowSetDispositionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ShowSetDisposition value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ShowSetDisposition value) {
  return os << ShowSetDispositionToString(value);
}

namespace internal {


// static
bool ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data*>(data);


  if (!::commerce::product_specifications::mojom::internal::DisclosureVersion_Data
        ::Validate(object->version, validation_context))
    return false;

  return true;
}

ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data::ProductSpecificationsHandler_SetAcceptedDisclosureVersion_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->urls, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& urls_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->urls, validation_context,
                                         &urls_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->set_id, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& set_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->set_id, validation_context,
                                         &set_id_validate_params)) {
    return false;
  }

  return true;
}

ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data::ProductSpecificationsHandler_MaybeShowDisclosure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data* object =
      static_cast<const ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data*>(data);

  return true;
}

ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data::ProductSpecificationsHandler_MaybeShowDisclosure_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_DeclineDisclosure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_DeclineDisclosure_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_DeclineDisclosure_Params_Data*>(data);

  return true;
}

ProductSpecificationsHandler_DeclineDisclosure_Params_Data::ProductSpecificationsHandler_DeclineDisclosure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data*>(data);

  return true;
}

ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data::ProductSpecificationsHandler_ShowSyncSetupFlow_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data::ProductSpecificationsHandler_GetPageTitleFromHistory_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data* object =
      static_cast<const ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  return true;
}

ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data::ProductSpecificationsHandler_GetPageTitleFromHistory_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data::ProductSpecificationsHandler_ShowProductSpecificationsSetForUuid_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuids, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& uuids_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->uuids, validation_context,
                                         &uuids_validate_params)) {
    return false;
  }


  if (!::commerce::product_specifications::mojom::internal::ShowSetDisposition_Data
        ::Validate(object->disposition, validation_context))
    return false;

  return true;
}

ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data::ProductSpecificationsHandler_ShowProductSpecificationsSetsForUuids_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_ShowComparePage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_ShowComparePage_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_ShowComparePage_Params_Data*>(data);

  return true;
}

ProductSpecificationsHandler_ShowComparePage_Params_Data::ProductSpecificationsHandler_ShowComparePage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data* object =
      static_cast<const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data* object =
      static_cast<const ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data::ProductSpecificationsHandler_GetComparisonTableUrlForUuid_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnProductSpecificationsSetAdded_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnProductSpecificationsSetAdded_Params_Data* object =
      static_cast<const Page_OnProductSpecificationsSetAdded_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->set, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->set, validation_context))
    return false;

  return true;
}

Page_OnProductSpecificationsSetAdded_Params_Data::Page_OnProductSpecificationsSetAdded_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnProductSpecificationsSetUpdated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnProductSpecificationsSetUpdated_Params_Data* object =
      static_cast<const Page_OnProductSpecificationsSetUpdated_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->set, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->set, validation_context))
    return false;

  return true;
}

Page_OnProductSpecificationsSetUpdated_Params_Data::Page_OnProductSpecificationsSetUpdated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnProductSpecificationsSetRemoved_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnProductSpecificationsSetRemoved_Params_Data* object =
      static_cast<const Page_OnProductSpecificationsSetRemoved_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->uuid, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->uuid, validation_context))
    return false;

  return true;
}

Page_OnProductSpecificationsSetRemoved_Params_Data::Page_OnProductSpecificationsSetRemoved_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_OnSyncStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_OnSyncStateChanged_Params_Data* object =
      static_cast<const Page_OnSyncStateChanged_Params_Data*>(data);

  return true;
}

Page_OnSyncStateChanged_Params_Data::Page_OnSyncStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data* object =
      static_cast<const ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->handler, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->handler,
                                                 validation_context)) {
    return false;
  }

  return true;
}

ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data::ProductSpecificationsHandlerFactory_CreateProductSpecificationsHandler_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace product_specifications
}  // namespace commerce

namespace perfetto {

// static
void TraceFormatTraits<::commerce::product_specifications::mojom::DisclosureVersion>::WriteIntoTrace(
   perfetto::TracedValue context, ::commerce::product_specifications::mojom::DisclosureVersion value) {
  return std::move(context).WriteString(::commerce::product_specifications::mojom::DisclosureVersionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::commerce::product_specifications::mojom::ShowSetDisposition>::WriteIntoTrace(
   perfetto::TracedValue context, ::commerce::product_specifications::mojom::ShowSetDisposition value) {
  return std::move(context).WriteString(::commerce::product_specifications::mojom::ShowSetDispositionToString(value));
}

} // namespace perfetto