// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import { CrLitElement } from 'chrome://resources/lit/v3_0/lit.rollup.js';
import { CommerceInternalsApiProxy } from './commerce_internals_api_proxy.js';
import { getCss } from './shared_style.css.js';
import { getHtml } from './subscription_list.html.js';
export class SubscriptionListElement extends CrLitElement {
    static get is() {
        return 'subscription-list';
    }
    static get styles() {
        return getCss();
    }
    render() {
        return getHtml.bind(this)();
    }
    static get properties() {
        return {
            subscriptions_: { type: Array },
        };
    }
    #subscriptions__accessor_storage = [];
    get subscriptions_() { return this.#subscriptions__accessor_storage; }
    set subscriptions_(value) { this.#subscriptions__accessor_storage = value; }
    commerceInternalsApi_ = CommerceInternalsApiProxy.getInstance();
    connectedCallback() {
        super.connectedCallback();
        this.loadSubscriptions_();
    }
    async loadSubscriptions_() {
        const subscriptions = (await this.commerceInternalsApi_.getSubscriptionDetails())
            .subscriptions;
        if (!subscriptions || subscriptions.length === 0) {
            this.subscriptions_ = [];
            return;
        }
        this.subscriptions_ = subscriptions;
    }
}
customElements.define(SubscriptionListElement.is, SubscriptionListElement);
