// components/browser_apis/tab_strip/tab_strip_api_types.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_TYPES_MOJOM_H_
#define COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_TYPES_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-features.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-shared.h"  // IWYU pragma: export
#include "components/browser_apis/tab_strip/tab_strip_api_types.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "components/browser_apis/tab_strip/types/image_traits.h"
#include "components/browser_apis/tab_strip/types/node_id.h"
#include "components/browser_apis/tab_strip/types/node_id_traits.h"
#include "components/browser_apis/tab_strip/types/position.h"
#include "components/browser_apis/tab_strip/types/position_traits.h"
#include "components/browser_apis/tab_strip/types/split_tab_visual_data_traits.h"
#include "components/browser_apis/tab_strip/types/tab_group_visual_data_traits.h"
#include "components/tab_groups/tab_group_visual_data.h"
#include "components/tabs/public/split_tab_visual_data.h"
#include "ui/gfx/image/image_skia.h"




namespace tabs_api::mojom {





class  NodeId {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NodeId, T>::value>;
  using DataView = NodeIdDataView;
  using Data_ = internal::NodeId_Data;
  using Type = NodeId_Type;

  template <typename... Args>
  static NodeIdPtr New(Args&&... args) {
    return NodeIdPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NodeIdPtr From(const U& u) {
    return mojo::TypeConverter<NodeIdPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NodeId>::Convert(*this);
  }


  NodeId();

  NodeId(
      const std::string& id,
      enum ::tabs_api::NodeId::Type type);


  ~NodeId();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NodeIdPtr>
  NodeIdPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NodeId::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NodeId::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NodeId::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NodeId::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NodeId::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NodeId::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NodeId_UnserializedMessageContext<
            UserType, NodeId::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NodeId::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NodeId::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NodeId_UnserializedMessageContext<
            UserType, NodeId::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NodeId::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string id;
  
  enum ::tabs_api::NodeId::Type type;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NodeId::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  Position {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Position, T>::value>;
  using DataView = PositionDataView;
  using Data_ = internal::Position_Data;

  template <typename... Args>
  static PositionPtr New(Args&&... args) {
    return PositionPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PositionPtr From(const U& u) {
    return mojo::TypeConverter<PositionPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Position>::Convert(*this);
  }


  Position();

  Position(
      const std::optional<::tabs_api::NodeId>& parent_id,
      uint32_t index);


  ~Position();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PositionPtr>
  PositionPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Position::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Position::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Position::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Position::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Position::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Position::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Position_UnserializedMessageContext<
            UserType, Position::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Position::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Position::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Position_UnserializedMessageContext<
            UserType, Position::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Position::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::optional<::tabs_api::NodeId> parent_id;
  
  uint32_t index;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Position::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Position::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Position::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Position::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
NodeIdPtr NodeId::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(type)
  );
}

template <typename T, NodeId::EnableIfSame<T>*>
bool NodeId::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  return true;
}

template <typename T, NodeId::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  return false;
}
template <typename StructPtrType>
PositionPtr Position::Clone() const {
  return New(
      mojo::Clone(parent_id),
      mojo::Clone(index)
  );
}

template <typename T, Position::EnableIfSame<T>*>
bool Position::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->parent_id, other_struct.parent_id))
    return false;
  if (!mojo::Equals(this->index, other_struct.index))
    return false;
  return true;
}

template <typename T, Position::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.parent_id < rhs.parent_id)
    return true;
  if (rhs.parent_id < lhs.parent_id)
    return false;
  if (lhs.index < rhs.index)
    return true;
  if (rhs.index < lhs.index)
    return false;
  return false;
}


}  // tabs_api::mojom

namespace mojo {


template <>
struct  StructTraits<::tabs_api::mojom::NodeId::DataView,
                                         ::tabs_api::mojom::NodeIdPtr> {
  static bool IsNull(const ::tabs_api::mojom::NodeIdPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::NodeIdPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::NodeId::id)& id(
      const ::tabs_api::mojom::NodeIdPtr& input) {
    return input->id;
  }

  static decltype(::tabs_api::mojom::NodeId::type) type(
      const ::tabs_api::mojom::NodeIdPtr& input) {
    return input->type;
  }

  static bool Read(::tabs_api::mojom::NodeId::DataView input, ::tabs_api::mojom::NodeIdPtr* output);
};


template <>
struct  StructTraits<::tabs_api::mojom::Position::DataView,
                                         ::tabs_api::mojom::PositionPtr> {
  static bool IsNull(const ::tabs_api::mojom::PositionPtr& input) { return !input; }
  static void SetToNull(::tabs_api::mojom::PositionPtr* output) { output->reset(); }

  static const decltype(::tabs_api::mojom::Position::parent_id)& parent_id(
      const ::tabs_api::mojom::PositionPtr& input) {
    return input->parent_id;
  }

  static decltype(::tabs_api::mojom::Position::index) index(
      const ::tabs_api::mojom::PositionPtr& input) {
    return input->index;
  }

  static bool Read(::tabs_api::mojom::Position::DataView input, ::tabs_api::mojom::PositionPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_BROWSER_APIS_TAB_STRIP_TAB_STRIP_API_TYPES_MOJOM_H_